// Code generated by go-swagger; DO NOT EDIT.

package boundary_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-boundary-service/stable/2021-12-21/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// BoundaryServiceUpdateReader is a Reader for the BoundaryServiceUpdate structure.
type BoundaryServiceUpdateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *BoundaryServiceUpdateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewBoundaryServiceUpdateOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewBoundaryServiceUpdateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewBoundaryServiceUpdateOK creates a BoundaryServiceUpdateOK with default headers values
func NewBoundaryServiceUpdateOK() *BoundaryServiceUpdateOK {
	return &BoundaryServiceUpdateOK{}
}

/*
BoundaryServiceUpdateOK describes a response with status code 200, with default header values.

A successful response.
*/
type BoundaryServiceUpdateOK struct {
	Payload models.HashicorpCloudBoundary20211221UpdateResponse
}

// IsSuccess returns true when this boundary service update o k response has a 2xx status code
func (o *BoundaryServiceUpdateOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this boundary service update o k response has a 3xx status code
func (o *BoundaryServiceUpdateOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this boundary service update o k response has a 4xx status code
func (o *BoundaryServiceUpdateOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this boundary service update o k response has a 5xx status code
func (o *BoundaryServiceUpdateOK) IsServerError() bool {
	return false
}

// IsCode returns true when this boundary service update o k response a status code equal to that given
func (o *BoundaryServiceUpdateOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the boundary service update o k response
func (o *BoundaryServiceUpdateOK) Code() int {
	return 200
}

func (o *BoundaryServiceUpdateOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /boundary/2021-12-21/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}][%d] boundaryServiceUpdateOK %s", 200, payload)
}

func (o *BoundaryServiceUpdateOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /boundary/2021-12-21/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}][%d] boundaryServiceUpdateOK %s", 200, payload)
}

func (o *BoundaryServiceUpdateOK) GetPayload() models.HashicorpCloudBoundary20211221UpdateResponse {
	return o.Payload
}

func (o *BoundaryServiceUpdateOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBoundaryServiceUpdateDefault creates a BoundaryServiceUpdateDefault with default headers values
func NewBoundaryServiceUpdateDefault(code int) *BoundaryServiceUpdateDefault {
	return &BoundaryServiceUpdateDefault{
		_statusCode: code,
	}
}

/*
BoundaryServiceUpdateDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type BoundaryServiceUpdateDefault struct {
	_statusCode int

	Payload *cloud.GrpcGatewayRuntimeError
}

// IsSuccess returns true when this boundary service update default response has a 2xx status code
func (o *BoundaryServiceUpdateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this boundary service update default response has a 3xx status code
func (o *BoundaryServiceUpdateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this boundary service update default response has a 4xx status code
func (o *BoundaryServiceUpdateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this boundary service update default response has a 5xx status code
func (o *BoundaryServiceUpdateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this boundary service update default response a status code equal to that given
func (o *BoundaryServiceUpdateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the boundary service update default response
func (o *BoundaryServiceUpdateDefault) Code() int {
	return o._statusCode
}

func (o *BoundaryServiceUpdateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /boundary/2021-12-21/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}][%d] BoundaryService_Update default %s", o._statusCode, payload)
}

func (o *BoundaryServiceUpdateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /boundary/2021-12-21/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}][%d] BoundaryService_Update default %s", o._statusCode, payload)
}

func (o *BoundaryServiceUpdateDefault) GetPayload() *cloud.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *BoundaryServiceUpdateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
