// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// HashicorpCloudGlobalNetworkManager20220215Peer Peer represents a single side of the peering connection
//
// swagger:model hashicorp.cloud.global_network_manager_20220215.Peer
type HashicorpCloudGlobalNetworkManager20220215Peer struct {

	// cluster
	Cluster *cloud.HashicorpCloudLocationLink `json:"cluster,omitempty"`

	// cluster partition
	ClusterPartition string `json:"cluster_partition,omitempty"`

	// peer meta
	PeerMeta map[string]string `json:"peer_meta,omitempty"`

	// peer name
	PeerName string `json:"peer_name,omitempty"`

	// server_external_addresses contains user-provided addresses to include in the acceptor's peering token.
	// Typically used to specify load balancers that route external traffic to the Consul servers.
	ServerExternalAddresses []string `json:"server_external_addresses"`
}

// Validate validates this hashicorp cloud global network manager 20220215 peer
func (m *HashicorpCloudGlobalNetworkManager20220215Peer) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCluster(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudGlobalNetworkManager20220215Peer) validateCluster(formats strfmt.Registry) error {
	if swag.IsZero(m.Cluster) { // not required
		return nil
	}

	if m.Cluster != nil {
		if err := m.Cluster.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cluster")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("cluster")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp cloud global network manager 20220215 peer based on the context it is used
func (m *HashicorpCloudGlobalNetworkManager20220215Peer) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCluster(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudGlobalNetworkManager20220215Peer) contextValidateCluster(ctx context.Context, formats strfmt.Registry) error {

	if m.Cluster != nil {

		if swag.IsZero(m.Cluster) { // not required
			return nil
		}

		if err := m.Cluster.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cluster")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("cluster")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudGlobalNetworkManager20220215Peer) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudGlobalNetworkManager20220215Peer) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudGlobalNetworkManager20220215Peer
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
