// Code generated by go-swagger; DO NOT EDIT.

package service_principals_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"
	httptransport "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// New creates a new service principals service API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

// New creates a new service principals service API client with basic auth credentials.
// It takes the following parameters:
// - host: http host (github.com).
// - basePath: any base path for the API client ("/v1", "/v3").
// - scheme: http scheme ("http", "https").
// - user: user for basic authentication header.
// - password: password for basic authentication header.
func NewClientWithBasicAuth(host, basePath, scheme, user, password string) ClientService {
	transport := httptransport.New(host, basePath, []string{scheme})
	transport.DefaultAuthentication = httptransport.BasicAuth(user, password)
	return &Client{transport: transport, formats: strfmt.Default}
}

// New creates a new service principals service API client with a bearer token for authentication.
// It takes the following parameters:
// - host: http host (github.com).
// - basePath: any base path for the API client ("/v1", "/v3").
// - scheme: http scheme ("http", "https").
// - bearerToken: bearer token for Bearer authentication header.
func NewClientWithBearerToken(host, basePath, scheme, bearerToken string) ClientService {
	transport := httptransport.New(host, basePath, []string{scheme})
	transport.DefaultAuthentication = httptransport.BearerToken(bearerToken)
	return &Client{transport: transport, formats: strfmt.Default}
}

/*
Client for service principals service API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption may be used to customize the behavior of Client methods.
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	ServicePrincipalsServiceCreateOrganizationServicePrincipal(params *ServicePrincipalsServiceCreateOrganizationServicePrincipalParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceCreateOrganizationServicePrincipalOK, error)

	ServicePrincipalsServiceCreateOrganizationServicePrincipalKey(params *ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyOK, error)

	ServicePrincipalsServiceCreateProjectServicePrincipal(params *ServicePrincipalsServiceCreateProjectServicePrincipalParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceCreateProjectServicePrincipalOK, error)

	ServicePrincipalsServiceCreateProjectServicePrincipalKey(params *ServicePrincipalsServiceCreateProjectServicePrincipalKeyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceCreateProjectServicePrincipalKeyOK, error)

	ServicePrincipalsServiceCreateServicePrincipal(params *ServicePrincipalsServiceCreateServicePrincipalParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceCreateServicePrincipalOK, error)

	ServicePrincipalsServiceCreateServicePrincipal2(params *ServicePrincipalsServiceCreateServicePrincipal2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceCreateServicePrincipal2OK, error)

	ServicePrincipalsServiceCreateServicePrincipalKey(params *ServicePrincipalsServiceCreateServicePrincipalKeyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceCreateServicePrincipalKeyOK, error)

	ServicePrincipalsServiceCreateServicePrincipalKey2(params *ServicePrincipalsServiceCreateServicePrincipalKey2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceCreateServicePrincipalKey2OK, error)

	ServicePrincipalsServiceCreateWorkloadIdentityProvider(params *ServicePrincipalsServiceCreateWorkloadIdentityProviderParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceCreateWorkloadIdentityProviderOK, error)

	ServicePrincipalsServiceDeleteOrganizationServicePrincipal(params *ServicePrincipalsServiceDeleteOrganizationServicePrincipalParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceDeleteOrganizationServicePrincipalOK, error)

	ServicePrincipalsServiceDeleteOrganizationServicePrincipalKey(params *ServicePrincipalsServiceDeleteOrganizationServicePrincipalKeyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceDeleteOrganizationServicePrincipalKeyOK, error)

	ServicePrincipalsServiceDeleteProjectServicePrincipal(params *ServicePrincipalsServiceDeleteProjectServicePrincipalParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceDeleteProjectServicePrincipalOK, error)

	ServicePrincipalsServiceDeleteProjectServicePrincipalKey(params *ServicePrincipalsServiceDeleteProjectServicePrincipalKeyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceDeleteProjectServicePrincipalKeyOK, error)

	ServicePrincipalsServiceDeleteServicePrincipal(params *ServicePrincipalsServiceDeleteServicePrincipalParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceDeleteServicePrincipalOK, error)

	ServicePrincipalsServiceDeleteServicePrincipal2(params *ServicePrincipalsServiceDeleteServicePrincipal2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceDeleteServicePrincipal2OK, error)

	ServicePrincipalsServiceDeleteServicePrincipalKey(params *ServicePrincipalsServiceDeleteServicePrincipalKeyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceDeleteServicePrincipalKeyOK, error)

	ServicePrincipalsServiceDeleteServicePrincipalKey2(params *ServicePrincipalsServiceDeleteServicePrincipalKey2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceDeleteServicePrincipalKey2OK, error)

	ServicePrincipalsServiceDeleteWorkloadIdentityProvider(params *ServicePrincipalsServiceDeleteWorkloadIdentityProviderParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceDeleteWorkloadIdentityProviderOK, error)

	ServicePrincipalsServiceExchangeWorkloadIdentityToken(params *ServicePrincipalsServiceExchangeWorkloadIdentityTokenParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceExchangeWorkloadIdentityTokenOK, error)

	ServicePrincipalsServiceGetOrganizationServicePrincipal(params *ServicePrincipalsServiceGetOrganizationServicePrincipalParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceGetOrganizationServicePrincipalOK, error)

	ServicePrincipalsServiceGetProjectServicePrincipal(params *ServicePrincipalsServiceGetProjectServicePrincipalParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceGetProjectServicePrincipalOK, error)

	ServicePrincipalsServiceGetServicePrincipal(params *ServicePrincipalsServiceGetServicePrincipalParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceGetServicePrincipalOK, error)

	ServicePrincipalsServiceGetServicePrincipal2(params *ServicePrincipalsServiceGetServicePrincipal2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceGetServicePrincipal2OK, error)

	ServicePrincipalsServiceGetWorkloadIdentityProvider(params *ServicePrincipalsServiceGetWorkloadIdentityProviderParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceGetWorkloadIdentityProviderOK, error)

	ServicePrincipalsServiceListOrganizationServicePrincipals(params *ServicePrincipalsServiceListOrganizationServicePrincipalsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceListOrganizationServicePrincipalsOK, error)

	ServicePrincipalsServiceListProjectServicePrincipals(params *ServicePrincipalsServiceListProjectServicePrincipalsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceListProjectServicePrincipalsOK, error)

	ServicePrincipalsServiceListServicePrincipals(params *ServicePrincipalsServiceListServicePrincipalsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceListServicePrincipalsOK, error)

	ServicePrincipalsServiceListServicePrincipals2(params *ServicePrincipalsServiceListServicePrincipals2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceListServicePrincipals2OK, error)

	ServicePrincipalsServiceListWorkloadIdentityProvider(params *ServicePrincipalsServiceListWorkloadIdentityProviderParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceListWorkloadIdentityProviderOK, error)

	ServicePrincipalsServiceUpdateWorkloadIdentityProvider(params *ServicePrincipalsServiceUpdateWorkloadIdentityProviderParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceUpdateWorkloadIdentityProviderOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
ServicePrincipalsServiceCreateOrganizationServicePrincipal creates organization service principal creates a new service principal on organization level
*/
func (a *Client) ServicePrincipalsServiceCreateOrganizationServicePrincipal(params *ServicePrincipalsServiceCreateOrganizationServicePrincipalParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceCreateOrganizationServicePrincipalOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewServicePrincipalsServiceCreateOrganizationServicePrincipalParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ServicePrincipalsService_CreateOrganizationServicePrincipal",
		Method:             "POST",
		PathPattern:        "/iam/2019-12-10/organizations/{organization_id}/service-principals",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ServicePrincipalsServiceCreateOrganizationServicePrincipalReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ServicePrincipalsServiceCreateOrganizationServicePrincipalOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ServicePrincipalsServiceCreateOrganizationServicePrincipalDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ServicePrincipalsServiceCreateOrganizationServicePrincipalKey creates organization service principal key creates a new service principal key for a service principal on organization level
*/
func (a *Client) ServicePrincipalsServiceCreateOrganizationServicePrincipalKey(params *ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewServicePrincipalsServiceCreateOrganizationServicePrincipalKeyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ServicePrincipalsService_CreateOrganizationServicePrincipalKey",
		Method:             "POST",
		PathPattern:        "/iam/2019-12-10/organizations/{organization_id}/service-principal-keys",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ServicePrincipalsServiceCreateOrganizationServicePrincipalKeyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ServicePrincipalsServiceCreateProjectServicePrincipal creates project service principal creates a new service principal on project level
*/
func (a *Client) ServicePrincipalsServiceCreateProjectServicePrincipal(params *ServicePrincipalsServiceCreateProjectServicePrincipalParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceCreateProjectServicePrincipalOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewServicePrincipalsServiceCreateProjectServicePrincipalParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ServicePrincipalsService_CreateProjectServicePrincipal",
		Method:             "POST",
		PathPattern:        "/iam/2019-12-10/organizations/{organization_id}/projects/{project_id}/service-principals",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ServicePrincipalsServiceCreateProjectServicePrincipalReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ServicePrincipalsServiceCreateProjectServicePrincipalOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ServicePrincipalsServiceCreateProjectServicePrincipalDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ServicePrincipalsServiceCreateProjectServicePrincipalKey creates project service principal key creates a new service principal key for a service principal on project level
*/
func (a *Client) ServicePrincipalsServiceCreateProjectServicePrincipalKey(params *ServicePrincipalsServiceCreateProjectServicePrincipalKeyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceCreateProjectServicePrincipalKeyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewServicePrincipalsServiceCreateProjectServicePrincipalKeyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ServicePrincipalsService_CreateProjectServicePrincipalKey",
		Method:             "POST",
		PathPattern:        "/iam/2019-12-10/organizations/{organization_id}/projects/{project_id}/service-principal-keys",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ServicePrincipalsServiceCreateProjectServicePrincipalKeyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ServicePrincipalsServiceCreateProjectServicePrincipalKeyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ServicePrincipalsServiceCreateProjectServicePrincipalKeyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ServicePrincipalsServiceCreateServicePrincipal creates service principal creates a new service principal
*/
func (a *Client) ServicePrincipalsServiceCreateServicePrincipal(params *ServicePrincipalsServiceCreateServicePrincipalParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceCreateServicePrincipalOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewServicePrincipalsServiceCreateServicePrincipalParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ServicePrincipalsService_CreateServicePrincipal",
		Method:             "POST",
		PathPattern:        "/2019-12-10/iam/{parent_resource_name}/service-principals",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ServicePrincipalsServiceCreateServicePrincipalReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ServicePrincipalsServiceCreateServicePrincipalOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ServicePrincipalsServiceCreateServicePrincipalDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ServicePrincipalsServiceCreateServicePrincipal2 creates service principal creates a new service principal
*/
func (a *Client) ServicePrincipalsServiceCreateServicePrincipal2(params *ServicePrincipalsServiceCreateServicePrincipal2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceCreateServicePrincipal2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewServicePrincipalsServiceCreateServicePrincipal2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "ServicePrincipalsService_CreateServicePrincipal2",
		Method:             "POST",
		PathPattern:        "/2019-12-10/iam/{parent_resource_name_1}/service-principals",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ServicePrincipalsServiceCreateServicePrincipal2Reader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ServicePrincipalsServiceCreateServicePrincipal2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ServicePrincipalsServiceCreateServicePrincipal2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ServicePrincipalsServiceCreateServicePrincipalKey creates service principal key creates a new service principal key for a service principal
*/
func (a *Client) ServicePrincipalsServiceCreateServicePrincipalKey(params *ServicePrincipalsServiceCreateServicePrincipalKeyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceCreateServicePrincipalKeyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewServicePrincipalsServiceCreateServicePrincipalKeyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ServicePrincipalsService_CreateServicePrincipalKey",
		Method:             "POST",
		PathPattern:        "/2019-12-10/{parent_resource_name}/keys",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ServicePrincipalsServiceCreateServicePrincipalKeyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ServicePrincipalsServiceCreateServicePrincipalKeyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ServicePrincipalsServiceCreateServicePrincipalKeyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ServicePrincipalsServiceCreateServicePrincipalKey2 creates service principal key creates a new service principal key for a service principal
*/
func (a *Client) ServicePrincipalsServiceCreateServicePrincipalKey2(params *ServicePrincipalsServiceCreateServicePrincipalKey2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceCreateServicePrincipalKey2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewServicePrincipalsServiceCreateServicePrincipalKey2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "ServicePrincipalsService_CreateServicePrincipalKey2",
		Method:             "POST",
		PathPattern:        "/2019-12-10/{parent_resource_name_1}/keys",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ServicePrincipalsServiceCreateServicePrincipalKey2Reader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ServicePrincipalsServiceCreateServicePrincipalKey2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ServicePrincipalsServiceCreateServicePrincipalKey2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ServicePrincipalsServiceCreateWorkloadIdentityProvider creates workload identity provider creates a workload identity provider nested under a service principal
*/
func (a *Client) ServicePrincipalsServiceCreateWorkloadIdentityProvider(params *ServicePrincipalsServiceCreateWorkloadIdentityProviderParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceCreateWorkloadIdentityProviderOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewServicePrincipalsServiceCreateWorkloadIdentityProviderParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ServicePrincipalsService_CreateWorkloadIdentityProvider",
		Method:             "POST",
		PathPattern:        "/2019-12-10/{parent_resource_name}/workload-identity-providers",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ServicePrincipalsServiceCreateWorkloadIdentityProviderReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ServicePrincipalsServiceCreateWorkloadIdentityProviderOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ServicePrincipalsServiceCreateWorkloadIdentityProviderDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ServicePrincipalsServiceDeleteOrganizationServicePrincipal deletes organization service principal deletes a service principal on organization level
*/
func (a *Client) ServicePrincipalsServiceDeleteOrganizationServicePrincipal(params *ServicePrincipalsServiceDeleteOrganizationServicePrincipalParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceDeleteOrganizationServicePrincipalOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewServicePrincipalsServiceDeleteOrganizationServicePrincipalParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ServicePrincipalsService_DeleteOrganizationServicePrincipal",
		Method:             "DELETE",
		PathPattern:        "/iam/2019-12-10/organizations/{organization_id}/service-principals/{principal_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ServicePrincipalsServiceDeleteOrganizationServicePrincipalReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ServicePrincipalsServiceDeleteOrganizationServicePrincipalOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ServicePrincipalsServiceDeleteOrganizationServicePrincipalDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ServicePrincipalsServiceDeleteOrganizationServicePrincipalKey deletes organization service principal key deletes a service principal key for a service principal on organization level
*/
func (a *Client) ServicePrincipalsServiceDeleteOrganizationServicePrincipalKey(params *ServicePrincipalsServiceDeleteOrganizationServicePrincipalKeyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceDeleteOrganizationServicePrincipalKeyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewServicePrincipalsServiceDeleteOrganizationServicePrincipalKeyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ServicePrincipalsService_DeleteOrganizationServicePrincipalKey",
		Method:             "DELETE",
		PathPattern:        "/iam/2019-12-10/organizations/{organization_id}/service-principal-keys/{client_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ServicePrincipalsServiceDeleteOrganizationServicePrincipalKeyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ServicePrincipalsServiceDeleteOrganizationServicePrincipalKeyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ServicePrincipalsServiceDeleteOrganizationServicePrincipalKeyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ServicePrincipalsServiceDeleteProjectServicePrincipal deletes service principal deletes a service principal on project level
*/
func (a *Client) ServicePrincipalsServiceDeleteProjectServicePrincipal(params *ServicePrincipalsServiceDeleteProjectServicePrincipalParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceDeleteProjectServicePrincipalOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewServicePrincipalsServiceDeleteProjectServicePrincipalParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ServicePrincipalsService_DeleteProjectServicePrincipal",
		Method:             "DELETE",
		PathPattern:        "/iam/2019-12-10/organizations/{organization_id}/projects/{project_id}/service-principals/{principal_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ServicePrincipalsServiceDeleteProjectServicePrincipalReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ServicePrincipalsServiceDeleteProjectServicePrincipalOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ServicePrincipalsServiceDeleteProjectServicePrincipalDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ServicePrincipalsServiceDeleteProjectServicePrincipalKey deletes project service principal key deletes a service principal key for a service principal on project level
*/
func (a *Client) ServicePrincipalsServiceDeleteProjectServicePrincipalKey(params *ServicePrincipalsServiceDeleteProjectServicePrincipalKeyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceDeleteProjectServicePrincipalKeyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewServicePrincipalsServiceDeleteProjectServicePrincipalKeyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ServicePrincipalsService_DeleteProjectServicePrincipalKey",
		Method:             "DELETE",
		PathPattern:        "/iam/2019-12-10/organizations/{organization_id}/projects/{project_id}/service-principal-keys/{client_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ServicePrincipalsServiceDeleteProjectServicePrincipalKeyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ServicePrincipalsServiceDeleteProjectServicePrincipalKeyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ServicePrincipalsServiceDeleteProjectServicePrincipalKeyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ServicePrincipalsServiceDeleteServicePrincipal deletes service principal deletes a service principal
*/
func (a *Client) ServicePrincipalsServiceDeleteServicePrincipal(params *ServicePrincipalsServiceDeleteServicePrincipalParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceDeleteServicePrincipalOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewServicePrincipalsServiceDeleteServicePrincipalParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ServicePrincipalsService_DeleteServicePrincipal",
		Method:             "DELETE",
		PathPattern:        "/2019-12-10/{resource_name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ServicePrincipalsServiceDeleteServicePrincipalReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ServicePrincipalsServiceDeleteServicePrincipalOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ServicePrincipalsServiceDeleteServicePrincipalDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ServicePrincipalsServiceDeleteServicePrincipal2 deletes service principal deletes a service principal
*/
func (a *Client) ServicePrincipalsServiceDeleteServicePrincipal2(params *ServicePrincipalsServiceDeleteServicePrincipal2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceDeleteServicePrincipal2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewServicePrincipalsServiceDeleteServicePrincipal2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "ServicePrincipalsService_DeleteServicePrincipal2",
		Method:             "DELETE",
		PathPattern:        "/2019-12-10/{resource_name_1}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ServicePrincipalsServiceDeleteServicePrincipal2Reader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ServicePrincipalsServiceDeleteServicePrincipal2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ServicePrincipalsServiceDeleteServicePrincipal2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ServicePrincipalsServiceDeleteServicePrincipalKey deletes service principal key deletes a service principal key
*/
func (a *Client) ServicePrincipalsServiceDeleteServicePrincipalKey(params *ServicePrincipalsServiceDeleteServicePrincipalKeyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceDeleteServicePrincipalKeyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewServicePrincipalsServiceDeleteServicePrincipalKeyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ServicePrincipalsService_DeleteServicePrincipalKey",
		Method:             "DELETE",
		PathPattern:        "/2019-12-10/{resource_name_2}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ServicePrincipalsServiceDeleteServicePrincipalKeyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ServicePrincipalsServiceDeleteServicePrincipalKeyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ServicePrincipalsServiceDeleteServicePrincipalKeyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ServicePrincipalsServiceDeleteServicePrincipalKey2 deletes service principal key deletes a service principal key
*/
func (a *Client) ServicePrincipalsServiceDeleteServicePrincipalKey2(params *ServicePrincipalsServiceDeleteServicePrincipalKey2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceDeleteServicePrincipalKey2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewServicePrincipalsServiceDeleteServicePrincipalKey2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "ServicePrincipalsService_DeleteServicePrincipalKey2",
		Method:             "DELETE",
		PathPattern:        "/2019-12-10/{resource_name_3}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ServicePrincipalsServiceDeleteServicePrincipalKey2Reader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ServicePrincipalsServiceDeleteServicePrincipalKey2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ServicePrincipalsServiceDeleteServicePrincipalKey2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ServicePrincipalsServiceDeleteWorkloadIdentityProvider deletes workload identity provider deletes a workload identity provider
*/
func (a *Client) ServicePrincipalsServiceDeleteWorkloadIdentityProvider(params *ServicePrincipalsServiceDeleteWorkloadIdentityProviderParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceDeleteWorkloadIdentityProviderOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewServicePrincipalsServiceDeleteWorkloadIdentityProviderParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ServicePrincipalsService_DeleteWorkloadIdentityProvider",
		Method:             "DELETE",
		PathPattern:        "/2019-12-10/{resource_name_4}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ServicePrincipalsServiceDeleteWorkloadIdentityProviderReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ServicePrincipalsServiceDeleteWorkloadIdentityProviderOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ServicePrincipalsServiceDeleteWorkloadIdentityProviderDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ServicePrincipalsServiceExchangeWorkloadIdentityToken exchanges workload identity token exchanges an external workload identity token for an access token whose subject is that of the service principal the identity federation is nested under
*/
func (a *Client) ServicePrincipalsServiceExchangeWorkloadIdentityToken(params *ServicePrincipalsServiceExchangeWorkloadIdentityTokenParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceExchangeWorkloadIdentityTokenOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewServicePrincipalsServiceExchangeWorkloadIdentityTokenParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ServicePrincipalsService_ExchangeWorkloadIdentityToken",
		Method:             "POST",
		PathPattern:        "/2019-12-10/{resource_name}/exchange-token",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ServicePrincipalsServiceExchangeWorkloadIdentityTokenReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ServicePrincipalsServiceExchangeWorkloadIdentityTokenOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ServicePrincipalsServiceExchangeWorkloadIdentityTokenDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ServicePrincipalsServiceGetOrganizationServicePrincipal gets organization service principal retrieves a service principal on organization level
*/
func (a *Client) ServicePrincipalsServiceGetOrganizationServicePrincipal(params *ServicePrincipalsServiceGetOrganizationServicePrincipalParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceGetOrganizationServicePrincipalOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewServicePrincipalsServiceGetOrganizationServicePrincipalParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ServicePrincipalsService_GetOrganizationServicePrincipal",
		Method:             "GET",
		PathPattern:        "/iam/2019-12-10/organizations/{organization_id}/service-principals/{principal_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ServicePrincipalsServiceGetOrganizationServicePrincipalReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ServicePrincipalsServiceGetOrganizationServicePrincipalOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ServicePrincipalsServiceGetOrganizationServicePrincipalDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ServicePrincipalsServiceGetProjectServicePrincipal gets project service principal retrieves a service principal on project level
*/
func (a *Client) ServicePrincipalsServiceGetProjectServicePrincipal(params *ServicePrincipalsServiceGetProjectServicePrincipalParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceGetProjectServicePrincipalOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewServicePrincipalsServiceGetProjectServicePrincipalParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ServicePrincipalsService_GetProjectServicePrincipal",
		Method:             "GET",
		PathPattern:        "/iam/2019-12-10/organizations/{organization_id}/projects/{project_id}/service-principals/{principal_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ServicePrincipalsServiceGetProjectServicePrincipalReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ServicePrincipalsServiceGetProjectServicePrincipalOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ServicePrincipalsServiceGetProjectServicePrincipalDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ServicePrincipalsServiceGetServicePrincipal gets service principal retrieves a service principal
*/
func (a *Client) ServicePrincipalsServiceGetServicePrincipal(params *ServicePrincipalsServiceGetServicePrincipalParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceGetServicePrincipalOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewServicePrincipalsServiceGetServicePrincipalParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ServicePrincipalsService_GetServicePrincipal",
		Method:             "GET",
		PathPattern:        "/2019-12-10/{resource_name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ServicePrincipalsServiceGetServicePrincipalReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ServicePrincipalsServiceGetServicePrincipalOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ServicePrincipalsServiceGetServicePrincipalDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ServicePrincipalsServiceGetServicePrincipal2 gets service principal retrieves a service principal
*/
func (a *Client) ServicePrincipalsServiceGetServicePrincipal2(params *ServicePrincipalsServiceGetServicePrincipal2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceGetServicePrincipal2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewServicePrincipalsServiceGetServicePrincipal2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "ServicePrincipalsService_GetServicePrincipal2",
		Method:             "GET",
		PathPattern:        "/2019-12-10/{resource_name_1}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ServicePrincipalsServiceGetServicePrincipal2Reader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ServicePrincipalsServiceGetServicePrincipal2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ServicePrincipalsServiceGetServicePrincipal2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ServicePrincipalsServiceGetWorkloadIdentityProvider gets workload identity provider retrieves a workload identity provider
*/
func (a *Client) ServicePrincipalsServiceGetWorkloadIdentityProvider(params *ServicePrincipalsServiceGetWorkloadIdentityProviderParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceGetWorkloadIdentityProviderOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewServicePrincipalsServiceGetWorkloadIdentityProviderParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ServicePrincipalsService_GetWorkloadIdentityProvider",
		Method:             "GET",
		PathPattern:        "/2019-12-10/{resource_name_2}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ServicePrincipalsServiceGetWorkloadIdentityProviderReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ServicePrincipalsServiceGetWorkloadIdentityProviderOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ServicePrincipalsServiceGetWorkloadIdentityProviderDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ServicePrincipalsServiceListOrganizationServicePrincipals lists project service principals lists service principals in an organization
*/
func (a *Client) ServicePrincipalsServiceListOrganizationServicePrincipals(params *ServicePrincipalsServiceListOrganizationServicePrincipalsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceListOrganizationServicePrincipalsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewServicePrincipalsServiceListOrganizationServicePrincipalsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ServicePrincipalsService_ListOrganizationServicePrincipals",
		Method:             "GET",
		PathPattern:        "/iam/2019-12-10/organizations/{organization_id}/service-principals",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ServicePrincipalsServiceListOrganizationServicePrincipalsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ServicePrincipalsServiceListOrganizationServicePrincipalsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ServicePrincipalsServiceListOrganizationServicePrincipalsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ServicePrincipalsServiceListProjectServicePrincipals lists project service principals lists service principals in a project
*/
func (a *Client) ServicePrincipalsServiceListProjectServicePrincipals(params *ServicePrincipalsServiceListProjectServicePrincipalsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceListProjectServicePrincipalsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewServicePrincipalsServiceListProjectServicePrincipalsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ServicePrincipalsService_ListProjectServicePrincipals",
		Method:             "GET",
		PathPattern:        "/iam/2019-12-10/organizations/{organization_id}/projects/{project_id}/service-principals",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ServicePrincipalsServiceListProjectServicePrincipalsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ServicePrincipalsServiceListProjectServicePrincipalsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ServicePrincipalsServiceListProjectServicePrincipalsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ServicePrincipalsServiceListServicePrincipals lists service principals lists service principals at a given scope
*/
func (a *Client) ServicePrincipalsServiceListServicePrincipals(params *ServicePrincipalsServiceListServicePrincipalsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceListServicePrincipalsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewServicePrincipalsServiceListServicePrincipalsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ServicePrincipalsService_ListServicePrincipals",
		Method:             "GET",
		PathPattern:        "/2019-12-10/iam/{parent_resource_name}/service-principals",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ServicePrincipalsServiceListServicePrincipalsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ServicePrincipalsServiceListServicePrincipalsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ServicePrincipalsServiceListServicePrincipalsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ServicePrincipalsServiceListServicePrincipals2 lists service principals lists service principals at a given scope
*/
func (a *Client) ServicePrincipalsServiceListServicePrincipals2(params *ServicePrincipalsServiceListServicePrincipals2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceListServicePrincipals2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewServicePrincipalsServiceListServicePrincipals2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "ServicePrincipalsService_ListServicePrincipals2",
		Method:             "GET",
		PathPattern:        "/2019-12-10/iam/{parent_resource_name_1}/service-principals",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ServicePrincipalsServiceListServicePrincipals2Reader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ServicePrincipalsServiceListServicePrincipals2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ServicePrincipalsServiceListServicePrincipals2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ServicePrincipalsServiceListWorkloadIdentityProvider lists workload identity provider lists workload identity providers under a service principal
*/
func (a *Client) ServicePrincipalsServiceListWorkloadIdentityProvider(params *ServicePrincipalsServiceListWorkloadIdentityProviderParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceListWorkloadIdentityProviderOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewServicePrincipalsServiceListWorkloadIdentityProviderParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ServicePrincipalsService_ListWorkloadIdentityProvider",
		Method:             "GET",
		PathPattern:        "/2019-12-10/{parent_resource_name}/workload-identity-providers",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ServicePrincipalsServiceListWorkloadIdentityProviderReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ServicePrincipalsServiceListWorkloadIdentityProviderOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ServicePrincipalsServiceListWorkloadIdentityProviderDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ServicePrincipalsServiceUpdateWorkloadIdentityProvider updates workload identity provider updates a workload identity provider
*/
func (a *Client) ServicePrincipalsServiceUpdateWorkloadIdentityProvider(params *ServicePrincipalsServiceUpdateWorkloadIdentityProviderParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ServicePrincipalsServiceUpdateWorkloadIdentityProviderOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewServicePrincipalsServiceUpdateWorkloadIdentityProviderParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ServicePrincipalsService_UpdateWorkloadIdentityProvider",
		Method:             "PATCH",
		PathPattern:        "/2019-12-10/{provider.resource_name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ServicePrincipalsServiceUpdateWorkloadIdentityProviderReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ServicePrincipalsServiceUpdateWorkloadIdentityProviderOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ServicePrincipalsServiceUpdateWorkloadIdentityProviderDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
