// Code generated by go-swagger; DO NOT EDIT.

package network_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-network/stable/2020-09-07/models"
)

// NewCreateTGWAttachmentParams creates a new CreateTGWAttachmentParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCreateTGWAttachmentParams() *CreateTGWAttachmentParams {
	return &CreateTGWAttachmentParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCreateTGWAttachmentParamsWithTimeout creates a new CreateTGWAttachmentParams object
// with the ability to set a timeout on a request.
func NewCreateTGWAttachmentParamsWithTimeout(timeout time.Duration) *CreateTGWAttachmentParams {
	return &CreateTGWAttachmentParams{
		timeout: timeout,
	}
}

// NewCreateTGWAttachmentParamsWithContext creates a new CreateTGWAttachmentParams object
// with the ability to set a context for a request.
func NewCreateTGWAttachmentParamsWithContext(ctx context.Context) *CreateTGWAttachmentParams {
	return &CreateTGWAttachmentParams{
		Context: ctx,
	}
}

// NewCreateTGWAttachmentParamsWithHTTPClient creates a new CreateTGWAttachmentParams object
// with the ability to set a custom HTTPClient for a request.
func NewCreateTGWAttachmentParamsWithHTTPClient(client *http.Client) *CreateTGWAttachmentParams {
	return &CreateTGWAttachmentParams{
		HTTPClient: client,
	}
}

/*
CreateTGWAttachmentParams contains all the parameters to send to the API endpoint

	for the create t g w attachment operation.

	Typically these are written to a http.Request.
*/
type CreateTGWAttachmentParams struct {

	// Body.
	Body *models.HashicorpCloudNetwork20200907CreateTGWAttachmentRequest

	/* HvnID.

	   id is the identifier for this resource.
	*/
	HvnID string

	/* HvnLocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	HvnLocationOrganizationID string

	/* HvnLocationProjectID.

	   project_id is the projects id.
	*/
	HvnLocationProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the create t g w attachment params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CreateTGWAttachmentParams) WithDefaults() *CreateTGWAttachmentParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the create t g w attachment params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CreateTGWAttachmentParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the create t g w attachment params
func (o *CreateTGWAttachmentParams) WithTimeout(timeout time.Duration) *CreateTGWAttachmentParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the create t g w attachment params
func (o *CreateTGWAttachmentParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the create t g w attachment params
func (o *CreateTGWAttachmentParams) WithContext(ctx context.Context) *CreateTGWAttachmentParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the create t g w attachment params
func (o *CreateTGWAttachmentParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the create t g w attachment params
func (o *CreateTGWAttachmentParams) WithHTTPClient(client *http.Client) *CreateTGWAttachmentParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the create t g w attachment params
func (o *CreateTGWAttachmentParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the create t g w attachment params
func (o *CreateTGWAttachmentParams) WithBody(body *models.HashicorpCloudNetwork20200907CreateTGWAttachmentRequest) *CreateTGWAttachmentParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the create t g w attachment params
func (o *CreateTGWAttachmentParams) SetBody(body *models.HashicorpCloudNetwork20200907CreateTGWAttachmentRequest) {
	o.Body = body
}

// WithHvnID adds the hvnID to the create t g w attachment params
func (o *CreateTGWAttachmentParams) WithHvnID(hvnID string) *CreateTGWAttachmentParams {
	o.SetHvnID(hvnID)
	return o
}

// SetHvnID adds the hvnId to the create t g w attachment params
func (o *CreateTGWAttachmentParams) SetHvnID(hvnID string) {
	o.HvnID = hvnID
}

// WithHvnLocationOrganizationID adds the hvnLocationOrganizationID to the create t g w attachment params
func (o *CreateTGWAttachmentParams) WithHvnLocationOrganizationID(hvnLocationOrganizationID string) *CreateTGWAttachmentParams {
	o.SetHvnLocationOrganizationID(hvnLocationOrganizationID)
	return o
}

// SetHvnLocationOrganizationID adds the hvnLocationOrganizationId to the create t g w attachment params
func (o *CreateTGWAttachmentParams) SetHvnLocationOrganizationID(hvnLocationOrganizationID string) {
	o.HvnLocationOrganizationID = hvnLocationOrganizationID
}

// WithHvnLocationProjectID adds the hvnLocationProjectID to the create t g w attachment params
func (o *CreateTGWAttachmentParams) WithHvnLocationProjectID(hvnLocationProjectID string) *CreateTGWAttachmentParams {
	o.SetHvnLocationProjectID(hvnLocationProjectID)
	return o
}

// SetHvnLocationProjectID adds the hvnLocationProjectId to the create t g w attachment params
func (o *CreateTGWAttachmentParams) SetHvnLocationProjectID(hvnLocationProjectID string) {
	o.HvnLocationProjectID = hvnLocationProjectID
}

// WriteToRequest writes these params to a swagger request
func (o *CreateTGWAttachmentParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param hvn.id
	if err := r.SetPathParam("hvn.id", o.HvnID); err != nil {
		return err
	}

	// path param hvn.location.organization_id
	if err := r.SetPathParam("hvn.location.organization_id", o.HvnLocationOrganizationID); err != nil {
		return err
	}

	// path param hvn.location.project_id
	if err := r.SetPathParam("hvn.location.project_id", o.HvnLocationProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
