// Code generated by go-swagger; DO NOT EDIT.

package registry_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vagrant-box-registry/stable/2022-09-30/models"
)

// DeleteArchitectureReader is a Reader for the DeleteArchitecture structure.
type DeleteArchitectureReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeleteArchitectureReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDeleteArchitectureOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDeleteArchitectureDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDeleteArchitectureOK creates a DeleteArchitectureOK with default headers values
func NewDeleteArchitectureOK() *DeleteArchitectureOK {
	return &DeleteArchitectureOK{}
}

/*
DeleteArchitectureOK describes a response with status code 200, with default header values.

A successful response.
*/
type DeleteArchitectureOK struct {
	Payload models.HashicorpCloudVagrant20220930DeleteArchitectureResponse
}

// IsSuccess returns true when this delete architecture o k response has a 2xx status code
func (o *DeleteArchitectureOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this delete architecture o k response has a 3xx status code
func (o *DeleteArchitectureOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete architecture o k response has a 4xx status code
func (o *DeleteArchitectureOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete architecture o k response has a 5xx status code
func (o *DeleteArchitectureOK) IsServerError() bool {
	return false
}

// IsCode returns true when this delete architecture o k response a status code equal to that given
func (o *DeleteArchitectureOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the delete architecture o k response
func (o *DeleteArchitectureOK) Code() int {
	return 200
}

func (o *DeleteArchitectureOK) Error() string {
	return fmt.Sprintf("[DELETE /vagrant/2022-09-30/registry/{registry}/box/{box}/version/{version}/provider/{provider}/architecture/{architecture}][%d] deleteArchitectureOK  %+v", 200, o.Payload)
}

func (o *DeleteArchitectureOK) String() string {
	return fmt.Sprintf("[DELETE /vagrant/2022-09-30/registry/{registry}/box/{box}/version/{version}/provider/{provider}/architecture/{architecture}][%d] deleteArchitectureOK  %+v", 200, o.Payload)
}

func (o *DeleteArchitectureOK) GetPayload() models.HashicorpCloudVagrant20220930DeleteArchitectureResponse {
	return o.Payload
}

func (o *DeleteArchitectureOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteArchitectureDefault creates a DeleteArchitectureDefault with default headers values
func NewDeleteArchitectureDefault(code int) *DeleteArchitectureDefault {
	return &DeleteArchitectureDefault{
		_statusCode: code,
	}
}

/*
DeleteArchitectureDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type DeleteArchitectureDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this delete architecture default response has a 2xx status code
func (o *DeleteArchitectureDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this delete architecture default response has a 3xx status code
func (o *DeleteArchitectureDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this delete architecture default response has a 4xx status code
func (o *DeleteArchitectureDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this delete architecture default response has a 5xx status code
func (o *DeleteArchitectureDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this delete architecture default response a status code equal to that given
func (o *DeleteArchitectureDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the delete architecture default response
func (o *DeleteArchitectureDefault) Code() int {
	return o._statusCode
}

func (o *DeleteArchitectureDefault) Error() string {
	return fmt.Sprintf("[DELETE /vagrant/2022-09-30/registry/{registry}/box/{box}/version/{version}/provider/{provider}/architecture/{architecture}][%d] DeleteArchitecture default  %+v", o._statusCode, o.Payload)
}

func (o *DeleteArchitectureDefault) String() string {
	return fmt.Sprintf("[DELETE /vagrant/2022-09-30/registry/{registry}/box/{box}/version/{version}/provider/{provider}/architecture/{architecture}][%d] DeleteArchitecture default  %+v", o._statusCode, o.Payload)
}

func (o *DeleteArchitectureDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *DeleteArchitectureDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
