// Code generated by go-swagger; DO NOT EDIT.

package integration_connection_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new integration connection service API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for integration connection service API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	CreateIntegrationConnection(params *CreateIntegrationConnectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateIntegrationConnectionOK, error)

	DeleteIntegrationConnection(params *DeleteIntegrationConnectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteIntegrationConnectionOK, error)

	GetIntegrationConnectionByID(params *GetIntegrationConnectionByIDParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetIntegrationConnectionByIDOK, error)

	GetIntegrationConnectionByName(params *GetIntegrationConnectionByNameParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetIntegrationConnectionByNameOK, error)

	UpdateIntegrationConnection(params *UpdateIntegrationConnectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateIntegrationConnectionOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
CreateIntegrationConnection create integration connection API
*/
func (a *Client) CreateIntegrationConnection(params *CreateIntegrationConnectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateIntegrationConnectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateIntegrationConnectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreateIntegrationConnection",
		Method:             "POST",
		PathPattern:        "/2023-05-01/vault-radar/projects/{location.project_id}/integrations/connections",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &CreateIntegrationConnectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateIntegrationConnectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CreateIntegrationConnectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DeleteIntegrationConnection delete integration connection API
*/
func (a *Client) DeleteIntegrationConnection(params *DeleteIntegrationConnectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteIntegrationConnectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteIntegrationConnectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "DeleteIntegrationConnection",
		Method:             "DELETE",
		PathPattern:        "/2023-05-01/vault-radar/projects/{location.project_id}/integrations/connections/{id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &DeleteIntegrationConnectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteIntegrationConnectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DeleteIntegrationConnectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetIntegrationConnectionByID get integration connection by ID API
*/
func (a *Client) GetIntegrationConnectionByID(params *GetIntegrationConnectionByIDParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetIntegrationConnectionByIDOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetIntegrationConnectionByIDParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetIntegrationConnectionByID",
		Method:             "GET",
		PathPattern:        "/2023-05-01/vault-radar/projects/{location.project_id}/integrations/connections/{id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetIntegrationConnectionByIDReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetIntegrationConnectionByIDOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetIntegrationConnectionByIDDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetIntegrationConnectionByName get integration connection by name API
*/
func (a *Client) GetIntegrationConnectionByName(params *GetIntegrationConnectionByNameParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetIntegrationConnectionByNameOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetIntegrationConnectionByNameParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetIntegrationConnectionByName",
		Method:             "POST",
		PathPattern:        "/2023-05-01/vault-radar/projects/{location.project_id}/integrations/connections/search-by-name",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetIntegrationConnectionByNameReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetIntegrationConnectionByNameOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetIntegrationConnectionByNameDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
UpdateIntegrationConnection update integration connection API
*/
func (a *Client) UpdateIntegrationConnection(params *UpdateIntegrationConnectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateIntegrationConnectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateIntegrationConnectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "UpdateIntegrationConnection",
		Method:             "PUT",
		PathPattern:        "/2023-05-01/vault-radar/projects/{location.project_id}/integrations/connections",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &UpdateIntegrationConnectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateIntegrationConnectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UpdateIntegrationConnectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
