// Code generated by go-swagger; DO NOT EDIT.

package tenant_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new tenant service API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for tenant service API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	CreateTenant(params *CreateTenantParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateTenantOK, error)

	GetTenant(params *GetTenantParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetTenantOK, error)

	ListOrganizationTenants(params *ListOrganizationTenantsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListOrganizationTenantsOK, error)

	ProvisionTenant(params *ProvisionTenantParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ProvisionTenantOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
CreateTenant create tenant API
*/
func (a *Client) CreateTenant(params *CreateTenantParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateTenantOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateTenantParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreateTenant",
		Method:             "POST",
		PathPattern:        "/2023-05-01/vault-radar/projects/{location.project_id}/tenants",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &CreateTenantReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateTenantOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CreateTenantDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetTenant get tenant API
*/
func (a *Client) GetTenant(params *GetTenantParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetTenantOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetTenantParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetTenant",
		Method:             "GET",
		PathPattern:        "/2023-05-01/vault-radar/projects/{location.project_id}/tenants",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetTenantReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetTenantOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetTenantDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ListOrganizationTenants list organization tenants API
*/
func (a *Client) ListOrganizationTenants(params *ListOrganizationTenantsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListOrganizationTenantsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewListOrganizationTenantsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ListOrganizationTenants",
		Method:             "GET",
		PathPattern:        "/2023-05-01/vault-radar/projects/{location.project_id}/tenants/organizations/{location.organization_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ListOrganizationTenantsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListOrganizationTenantsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ListOrganizationTenantsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ProvisionTenant provision tenant API
*/
func (a *Client) ProvisionTenant(params *ProvisionTenantParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ProvisionTenantOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewProvisionTenantParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ProvisionTenant",
		Method:             "POST",
		PathPattern:        "/2023-05-01/vault-radar/projects/{location.project_id}/tenants/provision",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ProvisionTenantReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ProvisionTenantOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ProvisionTenantDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
