// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// CreateGatewayPoolReader is a Reader for the CreateGatewayPool structure.
type CreateGatewayPoolReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreateGatewayPoolReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCreateGatewayPoolOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCreateGatewayPoolDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCreateGatewayPoolOK creates a CreateGatewayPoolOK with default headers values
func NewCreateGatewayPoolOK() *CreateGatewayPoolOK {
	return &CreateGatewayPoolOK{}
}

/*
CreateGatewayPoolOK describes a response with status code 200, with default header values.

A successful response.
*/
type CreateGatewayPoolOK struct {
	Payload *models.Secrets20231128CreateGatewayPoolResponse
}

// IsSuccess returns true when this create gateway pool o k response has a 2xx status code
func (o *CreateGatewayPoolOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create gateway pool o k response has a 3xx status code
func (o *CreateGatewayPoolOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create gateway pool o k response has a 4xx status code
func (o *CreateGatewayPoolOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this create gateway pool o k response has a 5xx status code
func (o *CreateGatewayPoolOK) IsServerError() bool {
	return false
}

// IsCode returns true when this create gateway pool o k response a status code equal to that given
func (o *CreateGatewayPoolOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the create gateway pool o k response
func (o *CreateGatewayPoolOK) Code() int {
	return 200
}

func (o *CreateGatewayPoolOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/gateway-pools][%d] createGatewayPoolOK %s", 200, payload)
}

func (o *CreateGatewayPoolOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/gateway-pools][%d] createGatewayPoolOK %s", 200, payload)
}

func (o *CreateGatewayPoolOK) GetPayload() *models.Secrets20231128CreateGatewayPoolResponse {
	return o.Payload
}

func (o *CreateGatewayPoolOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20231128CreateGatewayPoolResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateGatewayPoolDefault creates a CreateGatewayPoolDefault with default headers values
func NewCreateGatewayPoolDefault(code int) *CreateGatewayPoolDefault {
	return &CreateGatewayPoolDefault{
		_statusCode: code,
	}
}

/*
CreateGatewayPoolDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type CreateGatewayPoolDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this create gateway pool default response has a 2xx status code
func (o *CreateGatewayPoolDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this create gateway pool default response has a 3xx status code
func (o *CreateGatewayPoolDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this create gateway pool default response has a 4xx status code
func (o *CreateGatewayPoolDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this create gateway pool default response has a 5xx status code
func (o *CreateGatewayPoolDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this create gateway pool default response a status code equal to that given
func (o *CreateGatewayPoolDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the create gateway pool default response
func (o *CreateGatewayPoolDefault) Code() int {
	return o._statusCode
}

func (o *CreateGatewayPoolDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/gateway-pools][%d] CreateGatewayPool default %s", o._statusCode, payload)
}

func (o *CreateGatewayPoolDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/gateway-pools][%d] CreateGatewayPool default %s", o._statusCode, payload)
}

func (o *CreateGatewayPoolDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *CreateGatewayPoolDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
