// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// DeleteIntegrationReader is a Reader for the DeleteIntegration structure.
type DeleteIntegrationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeleteIntegrationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDeleteIntegrationOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDeleteIntegrationDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDeleteIntegrationOK creates a DeleteIntegrationOK with default headers values
func NewDeleteIntegrationOK() *DeleteIntegrationOK {
	return &DeleteIntegrationOK{}
}

/*
DeleteIntegrationOK describes a response with status code 200, with default header values.

A successful response.
*/
type DeleteIntegrationOK struct {
	Payload models.Secrets20231128DeleteIntegrationResponse
}

// IsSuccess returns true when this delete integration o k response has a 2xx status code
func (o *DeleteIntegrationOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this delete integration o k response has a 3xx status code
func (o *DeleteIntegrationOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete integration o k response has a 4xx status code
func (o *DeleteIntegrationOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete integration o k response has a 5xx status code
func (o *DeleteIntegrationOK) IsServerError() bool {
	return false
}

// IsCode returns true when this delete integration o k response a status code equal to that given
func (o *DeleteIntegrationOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the delete integration o k response
func (o *DeleteIntegrationOK) Code() int {
	return 200
}

func (o *DeleteIntegrationOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/{name}][%d] deleteIntegrationOK %s", 200, payload)
}

func (o *DeleteIntegrationOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/{name}][%d] deleteIntegrationOK %s", 200, payload)
}

func (o *DeleteIntegrationOK) GetPayload() models.Secrets20231128DeleteIntegrationResponse {
	return o.Payload
}

func (o *DeleteIntegrationOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteIntegrationDefault creates a DeleteIntegrationDefault with default headers values
func NewDeleteIntegrationDefault(code int) *DeleteIntegrationDefault {
	return &DeleteIntegrationDefault{
		_statusCode: code,
	}
}

/*
DeleteIntegrationDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type DeleteIntegrationDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this delete integration default response has a 2xx status code
func (o *DeleteIntegrationDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this delete integration default response has a 3xx status code
func (o *DeleteIntegrationDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this delete integration default response has a 4xx status code
func (o *DeleteIntegrationDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this delete integration default response has a 5xx status code
func (o *DeleteIntegrationDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this delete integration default response a status code equal to that given
func (o *DeleteIntegrationDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the delete integration default response
func (o *DeleteIntegrationDefault) Code() int {
	return o._statusCode
}

func (o *DeleteIntegrationDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/{name}][%d] DeleteIntegration default %s", o._statusCode, payload)
}

func (o *DeleteIntegrationDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/{name}][%d] DeleteIntegration default %s", o._statusCode, payload)
}

func (o *DeleteIntegrationDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *DeleteIntegrationDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
