// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2023-08-18/models"
)

// WaypointServiceDestroyAddOnReader is a Reader for the WaypointServiceDestroyAddOn structure.
type WaypointServiceDestroyAddOnReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceDestroyAddOnReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceDestroyAddOnOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceDestroyAddOnDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceDestroyAddOnOK creates a WaypointServiceDestroyAddOnOK with default headers values
func NewWaypointServiceDestroyAddOnOK() *WaypointServiceDestroyAddOnOK {
	return &WaypointServiceDestroyAddOnOK{}
}

/*
WaypointServiceDestroyAddOnOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceDestroyAddOnOK struct {
	Payload models.HashicorpCloudWaypointDestroyAddOnResponse
}

// IsSuccess returns true when this waypoint service destroy add on o k response has a 2xx status code
func (o *WaypointServiceDestroyAddOnOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service destroy add on o k response has a 3xx status code
func (o *WaypointServiceDestroyAddOnOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service destroy add on o k response has a 4xx status code
func (o *WaypointServiceDestroyAddOnOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service destroy add on o k response has a 5xx status code
func (o *WaypointServiceDestroyAddOnOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service destroy add on o k response a status code equal to that given
func (o *WaypointServiceDestroyAddOnOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service destroy add on o k response
func (o *WaypointServiceDestroyAddOnOK) Code() int {
	return 200
}

func (o *WaypointServiceDestroyAddOnOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /waypoint/2023-08-18/namespace/{namespace.id}/add-on/{add_on.id}][%d] waypointServiceDestroyAddOnOK %s", 200, payload)
}

func (o *WaypointServiceDestroyAddOnOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /waypoint/2023-08-18/namespace/{namespace.id}/add-on/{add_on.id}][%d] waypointServiceDestroyAddOnOK %s", 200, payload)
}

func (o *WaypointServiceDestroyAddOnOK) GetPayload() models.HashicorpCloudWaypointDestroyAddOnResponse {
	return o.Payload
}

func (o *WaypointServiceDestroyAddOnOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceDestroyAddOnDefault creates a WaypointServiceDestroyAddOnDefault with default headers values
func NewWaypointServiceDestroyAddOnDefault(code int) *WaypointServiceDestroyAddOnDefault {
	return &WaypointServiceDestroyAddOnDefault{
		_statusCode: code,
	}
}

/*
WaypointServiceDestroyAddOnDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceDestroyAddOnDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service destroy add on default response has a 2xx status code
func (o *WaypointServiceDestroyAddOnDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service destroy add on default response has a 3xx status code
func (o *WaypointServiceDestroyAddOnDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service destroy add on default response has a 4xx status code
func (o *WaypointServiceDestroyAddOnDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service destroy add on default response has a 5xx status code
func (o *WaypointServiceDestroyAddOnDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service destroy add on default response a status code equal to that given
func (o *WaypointServiceDestroyAddOnDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service destroy add on default response
func (o *WaypointServiceDestroyAddOnDefault) Code() int {
	return o._statusCode
}

func (o *WaypointServiceDestroyAddOnDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /waypoint/2023-08-18/namespace/{namespace.id}/add-on/{add_on.id}][%d] WaypointService_DestroyAddOn default %s", o._statusCode, payload)
}

func (o *WaypointServiceDestroyAddOnDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /waypoint/2023-08-18/namespace/{namespace.id}/add-on/{add_on.id}][%d] WaypointService_DestroyAddOn default %s", o._statusCode, payload)
}

func (o *WaypointServiceDestroyAddOnDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceDestroyAddOnDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
