// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2023-08-18/models"
)

// WaypointServiceQueueAgentOperationReader is a Reader for the WaypointServiceQueueAgentOperation structure.
type WaypointServiceQueueAgentOperationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceQueueAgentOperationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceQueueAgentOperationOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceQueueAgentOperationDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceQueueAgentOperationOK creates a WaypointServiceQueueAgentOperationOK with default headers values
func NewWaypointServiceQueueAgentOperationOK() *WaypointServiceQueueAgentOperationOK {
	return &WaypointServiceQueueAgentOperationOK{}
}

/*
WaypointServiceQueueAgentOperationOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceQueueAgentOperationOK struct {
	Payload models.HashicorpCloudWaypointQueueAgentOperationResponse
}

// IsSuccess returns true when this waypoint service queue agent operation o k response has a 2xx status code
func (o *WaypointServiceQueueAgentOperationOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service queue agent operation o k response has a 3xx status code
func (o *WaypointServiceQueueAgentOperationOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service queue agent operation o k response has a 4xx status code
func (o *WaypointServiceQueueAgentOperationOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service queue agent operation o k response has a 5xx status code
func (o *WaypointServiceQueueAgentOperationOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service queue agent operation o k response a status code equal to that given
func (o *WaypointServiceQueueAgentOperationOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service queue agent operation o k response
func (o *WaypointServiceQueueAgentOperationOK) Code() int {
	return 200
}

func (o *WaypointServiceQueueAgentOperationOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /waypoint/2023-08-18/namespace/{namespace.id}/agent/operation:queue][%d] waypointServiceQueueAgentOperationOK %s", 200, payload)
}

func (o *WaypointServiceQueueAgentOperationOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /waypoint/2023-08-18/namespace/{namespace.id}/agent/operation:queue][%d] waypointServiceQueueAgentOperationOK %s", 200, payload)
}

func (o *WaypointServiceQueueAgentOperationOK) GetPayload() models.HashicorpCloudWaypointQueueAgentOperationResponse {
	return o.Payload
}

func (o *WaypointServiceQueueAgentOperationOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceQueueAgentOperationDefault creates a WaypointServiceQueueAgentOperationDefault with default headers values
func NewWaypointServiceQueueAgentOperationDefault(code int) *WaypointServiceQueueAgentOperationDefault {
	return &WaypointServiceQueueAgentOperationDefault{
		_statusCode: code,
	}
}

/*
WaypointServiceQueueAgentOperationDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceQueueAgentOperationDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service queue agent operation default response has a 2xx status code
func (o *WaypointServiceQueueAgentOperationDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service queue agent operation default response has a 3xx status code
func (o *WaypointServiceQueueAgentOperationDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service queue agent operation default response has a 4xx status code
func (o *WaypointServiceQueueAgentOperationDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service queue agent operation default response has a 5xx status code
func (o *WaypointServiceQueueAgentOperationDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service queue agent operation default response a status code equal to that given
func (o *WaypointServiceQueueAgentOperationDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service queue agent operation default response
func (o *WaypointServiceQueueAgentOperationDefault) Code() int {
	return o._statusCode
}

func (o *WaypointServiceQueueAgentOperationDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /waypoint/2023-08-18/namespace/{namespace.id}/agent/operation:queue][%d] WaypointService_QueueAgentOperation default %s", o._statusCode, payload)
}

func (o *WaypointServiceQueueAgentOperationDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /waypoint/2023-08-18/namespace/{namespace.id}/agent/operation:queue][%d] WaypointService_QueueAgentOperation default %s", o._statusCode, payload)
}

func (o *WaypointServiceQueueAgentOperationDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceQueueAgentOperationDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
