// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2023-08-18/models"
)

// WaypointServiceUpdateAddOnReader is a Reader for the WaypointServiceUpdateAddOn structure.
type WaypointServiceUpdateAddOnReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceUpdateAddOnReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceUpdateAddOnOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceUpdateAddOnDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceUpdateAddOnOK creates a WaypointServiceUpdateAddOnOK with default headers values
func NewWaypointServiceUpdateAddOnOK() *WaypointServiceUpdateAddOnOK {
	return &WaypointServiceUpdateAddOnOK{}
}

/*
WaypointServiceUpdateAddOnOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceUpdateAddOnOK struct {
	Payload *models.HashicorpCloudWaypointUpdateAddOnResponse
}

// IsSuccess returns true when this waypoint service update add on o k response has a 2xx status code
func (o *WaypointServiceUpdateAddOnOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service update add on o k response has a 3xx status code
func (o *WaypointServiceUpdateAddOnOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service update add on o k response has a 4xx status code
func (o *WaypointServiceUpdateAddOnOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service update add on o k response has a 5xx status code
func (o *WaypointServiceUpdateAddOnOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service update add on o k response a status code equal to that given
func (o *WaypointServiceUpdateAddOnOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service update add on o k response
func (o *WaypointServiceUpdateAddOnOK) Code() int {
	return 200
}

func (o *WaypointServiceUpdateAddOnOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /waypoint/2023-08-18/namespace/{namespace.id}/add-on/{existing_add_on.id}][%d] waypointServiceUpdateAddOnOK %s", 200, payload)
}

func (o *WaypointServiceUpdateAddOnOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /waypoint/2023-08-18/namespace/{namespace.id}/add-on/{existing_add_on.id}][%d] waypointServiceUpdateAddOnOK %s", 200, payload)
}

func (o *WaypointServiceUpdateAddOnOK) GetPayload() *models.HashicorpCloudWaypointUpdateAddOnResponse {
	return o.Payload
}

func (o *WaypointServiceUpdateAddOnOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudWaypointUpdateAddOnResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceUpdateAddOnDefault creates a WaypointServiceUpdateAddOnDefault with default headers values
func NewWaypointServiceUpdateAddOnDefault(code int) *WaypointServiceUpdateAddOnDefault {
	return &WaypointServiceUpdateAddOnDefault{
		_statusCode: code,
	}
}

/*
WaypointServiceUpdateAddOnDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceUpdateAddOnDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service update add on default response has a 2xx status code
func (o *WaypointServiceUpdateAddOnDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service update add on default response has a 3xx status code
func (o *WaypointServiceUpdateAddOnDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service update add on default response has a 4xx status code
func (o *WaypointServiceUpdateAddOnDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service update add on default response has a 5xx status code
func (o *WaypointServiceUpdateAddOnDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service update add on default response a status code equal to that given
func (o *WaypointServiceUpdateAddOnDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service update add on default response
func (o *WaypointServiceUpdateAddOnDefault) Code() int {
	return o._statusCode
}

func (o *WaypointServiceUpdateAddOnDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /waypoint/2023-08-18/namespace/{namespace.id}/add-on/{existing_add_on.id}][%d] WaypointService_UpdateAddOn default %s", o._statusCode, payload)
}

func (o *WaypointServiceUpdateAddOnDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /waypoint/2023-08-18/namespace/{namespace.id}/add-on/{existing_add_on.id}][%d] WaypointService_UpdateAddOn default %s", o._statusCode, payload)
}

func (o *WaypointServiceUpdateAddOnDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceUpdateAddOnDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
