// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// HashicorpCloudWaypointWaypointServiceUpdateApplicationTemplateBody hashicorp cloud waypoint waypoint service update application template body
//
// swagger:model hashicorp.cloud.waypoint.WaypointService.UpdateApplicationTemplateBody
type HashicorpCloudWaypointWaypointServiceUpdateApplicationTemplateBody struct {

	// application_template resembles the desired updated state of the existing
	// application template.
	ApplicationTemplate *HashicorpCloudWaypointApplicationTemplate `json:"application_template,omitempty"`

	// existing application template
	ExistingApplicationTemplate *HashicorpCloudWaypointWaypointServiceUpdateApplicationTemplateBodyExistingApplicationTemplate `json:"existing_application_template,omitempty"`

	// namespace
	Namespace *HashicorpCloudWaypointWaypointServiceUpdateApplicationTemplateBodyNamespace `json:"namespace,omitempty"`

	// Field mask to update only specific fields. I.e. if you want a field updated,
	// you must include it in the field mask. For now, we only use this
	// for ActionConfigRefs inside application_template for clearing assignments.
	UpdateMask string `json:"update_mask,omitempty"`

	// If true, will auto-import the readme from the Terraform module used
	// rather than the one specified in application_template.
	UseModuleReadme bool `json:"use_module_readme,omitempty"`
}

// Validate validates this hashicorp cloud waypoint waypoint service update application template body
func (m *HashicorpCloudWaypointWaypointServiceUpdateApplicationTemplateBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateApplicationTemplate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExistingApplicationTemplate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNamespace(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudWaypointWaypointServiceUpdateApplicationTemplateBody) validateApplicationTemplate(formats strfmt.Registry) error {
	if swag.IsZero(m.ApplicationTemplate) { // not required
		return nil
	}

	if m.ApplicationTemplate != nil {
		if err := m.ApplicationTemplate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("application_template")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("application_template")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudWaypointWaypointServiceUpdateApplicationTemplateBody) validateExistingApplicationTemplate(formats strfmt.Registry) error {
	if swag.IsZero(m.ExistingApplicationTemplate) { // not required
		return nil
	}

	if m.ExistingApplicationTemplate != nil {
		if err := m.ExistingApplicationTemplate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("existing_application_template")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("existing_application_template")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudWaypointWaypointServiceUpdateApplicationTemplateBody) validateNamespace(formats strfmt.Registry) error {
	if swag.IsZero(m.Namespace) { // not required
		return nil
	}

	if m.Namespace != nil {
		if err := m.Namespace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("namespace")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("namespace")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp cloud waypoint waypoint service update application template body based on the context it is used
func (m *HashicorpCloudWaypointWaypointServiceUpdateApplicationTemplateBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateApplicationTemplate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateExistingApplicationTemplate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNamespace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudWaypointWaypointServiceUpdateApplicationTemplateBody) contextValidateApplicationTemplate(ctx context.Context, formats strfmt.Registry) error {

	if m.ApplicationTemplate != nil {

		if swag.IsZero(m.ApplicationTemplate) { // not required
			return nil
		}

		if err := m.ApplicationTemplate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("application_template")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("application_template")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudWaypointWaypointServiceUpdateApplicationTemplateBody) contextValidateExistingApplicationTemplate(ctx context.Context, formats strfmt.Registry) error {

	if m.ExistingApplicationTemplate != nil {

		if swag.IsZero(m.ExistingApplicationTemplate) { // not required
			return nil
		}

		if err := m.ExistingApplicationTemplate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("existing_application_template")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("existing_application_template")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudWaypointWaypointServiceUpdateApplicationTemplateBody) contextValidateNamespace(ctx context.Context, formats strfmt.Registry) error {

	if m.Namespace != nil {

		if swag.IsZero(m.Namespace) { // not required
			return nil
		}

		if err := m.Namespace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("namespace")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("namespace")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudWaypointWaypointServiceUpdateApplicationTemplateBody) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudWaypointWaypointServiceUpdateApplicationTemplateBody) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudWaypointWaypointServiceUpdateApplicationTemplateBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// HashicorpCloudWaypointWaypointServiceUpdateApplicationTemplateBodyExistingApplicationTemplate Template Ref Without ID
//
// existing_application_template refers to the application template being updated.
//
// swagger:model HashicorpCloudWaypointWaypointServiceUpdateApplicationTemplateBodyExistingApplicationTemplate
type HashicorpCloudWaypointWaypointServiceUpdateApplicationTemplateBodyExistingApplicationTemplate struct {

	// ID of the ApplicationTemplate
	ID string `json:"id,omitempty"`
}

// Validate validates this hashicorp cloud waypoint waypoint service update application template body existing application template
func (m *HashicorpCloudWaypointWaypointServiceUpdateApplicationTemplateBodyExistingApplicationTemplate) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this hashicorp cloud waypoint waypoint service update application template body existing application template based on context it is used
func (m *HashicorpCloudWaypointWaypointServiceUpdateApplicationTemplateBodyExistingApplicationTemplate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudWaypointWaypointServiceUpdateApplicationTemplateBodyExistingApplicationTemplate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudWaypointWaypointServiceUpdateApplicationTemplateBodyExistingApplicationTemplate) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudWaypointWaypointServiceUpdateApplicationTemplateBodyExistingApplicationTemplate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// HashicorpCloudWaypointWaypointServiceUpdateApplicationTemplateBodyNamespace Global references the entire server. This is used in some APIs
// as a way to read/write values that are server-global.
//
// swagger:model HashicorpCloudWaypointWaypointServiceUpdateApplicationTemplateBodyNamespace
type HashicorpCloudWaypointWaypointServiceUpdateApplicationTemplateBodyNamespace struct {

	// When used via an API request, this is populated and used to populate id.
	Location *cloud.HashicorpCloudLocationLocation `json:"location,omitempty"`
}

// Validate validates this hashicorp cloud waypoint waypoint service update application template body namespace
func (m *HashicorpCloudWaypointWaypointServiceUpdateApplicationTemplateBodyNamespace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudWaypointWaypointServiceUpdateApplicationTemplateBodyNamespace) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(m.Location) { // not required
		return nil
	}

	if m.Location != nil {
		if err := m.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("namespace" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("namespace" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp cloud waypoint waypoint service update application template body namespace based on the context it is used
func (m *HashicorpCloudWaypointWaypointServiceUpdateApplicationTemplateBodyNamespace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudWaypointWaypointServiceUpdateApplicationTemplateBodyNamespace) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if m.Location != nil {

		if swag.IsZero(m.Location) { // not required
			return nil
		}

		if err := m.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("namespace" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("namespace" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudWaypointWaypointServiceUpdateApplicationTemplateBodyNamespace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudWaypointWaypointServiceUpdateApplicationTemplateBodyNamespace) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudWaypointWaypointServiceUpdateApplicationTemplateBodyNamespace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
