// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2024-11-22/models"
)

// WaypointServiceDeleteApplicationTemplateReader is a Reader for the WaypointServiceDeleteApplicationTemplate structure.
type WaypointServiceDeleteApplicationTemplateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceDeleteApplicationTemplateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceDeleteApplicationTemplateOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceDeleteApplicationTemplateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceDeleteApplicationTemplateOK creates a WaypointServiceDeleteApplicationTemplateOK with default headers values
func NewWaypointServiceDeleteApplicationTemplateOK() *WaypointServiceDeleteApplicationTemplateOK {
	return &WaypointServiceDeleteApplicationTemplateOK{}
}

/*
WaypointServiceDeleteApplicationTemplateOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceDeleteApplicationTemplateOK struct {
	Payload models.HashicorpCloudWaypointDeleteApplicationTemplateResponse
}

// IsSuccess returns true when this waypoint service delete application template o k response has a 2xx status code
func (o *WaypointServiceDeleteApplicationTemplateOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service delete application template o k response has a 3xx status code
func (o *WaypointServiceDeleteApplicationTemplateOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service delete application template o k response has a 4xx status code
func (o *WaypointServiceDeleteApplicationTemplateOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service delete application template o k response has a 5xx status code
func (o *WaypointServiceDeleteApplicationTemplateOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service delete application template o k response a status code equal to that given
func (o *WaypointServiceDeleteApplicationTemplateOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service delete application template o k response
func (o *WaypointServiceDeleteApplicationTemplateOK) Code() int {
	return 200
}

func (o *WaypointServiceDeleteApplicationTemplateOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/application-templates/{application_template.id}][%d] waypointServiceDeleteApplicationTemplateOK %s", 200, payload)
}

func (o *WaypointServiceDeleteApplicationTemplateOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/application-templates/{application_template.id}][%d] waypointServiceDeleteApplicationTemplateOK %s", 200, payload)
}

func (o *WaypointServiceDeleteApplicationTemplateOK) GetPayload() models.HashicorpCloudWaypointDeleteApplicationTemplateResponse {
	return o.Payload
}

func (o *WaypointServiceDeleteApplicationTemplateOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceDeleteApplicationTemplateDefault creates a WaypointServiceDeleteApplicationTemplateDefault with default headers values
func NewWaypointServiceDeleteApplicationTemplateDefault(code int) *WaypointServiceDeleteApplicationTemplateDefault {
	return &WaypointServiceDeleteApplicationTemplateDefault{
		_statusCode: code,
	}
}

/*
WaypointServiceDeleteApplicationTemplateDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceDeleteApplicationTemplateDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service delete application template default response has a 2xx status code
func (o *WaypointServiceDeleteApplicationTemplateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service delete application template default response has a 3xx status code
func (o *WaypointServiceDeleteApplicationTemplateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service delete application template default response has a 4xx status code
func (o *WaypointServiceDeleteApplicationTemplateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service delete application template default response has a 5xx status code
func (o *WaypointServiceDeleteApplicationTemplateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service delete application template default response a status code equal to that given
func (o *WaypointServiceDeleteApplicationTemplateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service delete application template default response
func (o *WaypointServiceDeleteApplicationTemplateDefault) Code() int {
	return o._statusCode
}

func (o *WaypointServiceDeleteApplicationTemplateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/application-templates/{application_template.id}][%d] WaypointService_DeleteApplicationTemplate default %s", o._statusCode, payload)
}

func (o *WaypointServiceDeleteApplicationTemplateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/application-templates/{application_template.id}][%d] WaypointService_DeleteApplicationTemplate default %s", o._statusCode, payload)
}

func (o *WaypointServiceDeleteApplicationTemplateDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceDeleteApplicationTemplateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
