// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewWaypointServiceGetAgentGroupParams creates a new WaypointServiceGetAgentGroupParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointServiceGetAgentGroupParams() *WaypointServiceGetAgentGroupParams {
	return &WaypointServiceGetAgentGroupParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointServiceGetAgentGroupParamsWithTimeout creates a new WaypointServiceGetAgentGroupParams object
// with the ability to set a timeout on a request.
func NewWaypointServiceGetAgentGroupParamsWithTimeout(timeout time.Duration) *WaypointServiceGetAgentGroupParams {
	return &WaypointServiceGetAgentGroupParams{
		timeout: timeout,
	}
}

// NewWaypointServiceGetAgentGroupParamsWithContext creates a new WaypointServiceGetAgentGroupParams object
// with the ability to set a context for a request.
func NewWaypointServiceGetAgentGroupParamsWithContext(ctx context.Context) *WaypointServiceGetAgentGroupParams {
	return &WaypointServiceGetAgentGroupParams{
		Context: ctx,
	}
}

// NewWaypointServiceGetAgentGroupParamsWithHTTPClient creates a new WaypointServiceGetAgentGroupParams object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointServiceGetAgentGroupParamsWithHTTPClient(client *http.Client) *WaypointServiceGetAgentGroupParams {
	return &WaypointServiceGetAgentGroupParams{
		HTTPClient: client,
	}
}

/*
WaypointServiceGetAgentGroupParams contains all the parameters to send to the API endpoint

	for the waypoint service get agent group operation.

	Typically these are written to a http.Request.
*/
type WaypointServiceGetAgentGroupParams struct {

	/* Name.

	   The name of the group to retrieve the information about
	*/
	Name string

	// NamespaceID.
	NamespaceID *string

	/* NamespaceLocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	NamespaceLocationOrganizationID string

	/* NamespaceLocationProjectID.

	   project_id is the projects id.
	*/
	NamespaceLocationProjectID string

	/* NamespaceLocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	NamespaceLocationRegionProvider *string

	/* NamespaceLocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	NamespaceLocationRegionRegion *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint service get agent group params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceGetAgentGroupParams) WithDefaults() *WaypointServiceGetAgentGroupParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint service get agent group params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceGetAgentGroupParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint service get agent group params
func (o *WaypointServiceGetAgentGroupParams) WithTimeout(timeout time.Duration) *WaypointServiceGetAgentGroupParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint service get agent group params
func (o *WaypointServiceGetAgentGroupParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint service get agent group params
func (o *WaypointServiceGetAgentGroupParams) WithContext(ctx context.Context) *WaypointServiceGetAgentGroupParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint service get agent group params
func (o *WaypointServiceGetAgentGroupParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint service get agent group params
func (o *WaypointServiceGetAgentGroupParams) WithHTTPClient(client *http.Client) *WaypointServiceGetAgentGroupParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint service get agent group params
func (o *WaypointServiceGetAgentGroupParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithName adds the name to the waypoint service get agent group params
func (o *WaypointServiceGetAgentGroupParams) WithName(name string) *WaypointServiceGetAgentGroupParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the waypoint service get agent group params
func (o *WaypointServiceGetAgentGroupParams) SetName(name string) {
	o.Name = name
}

// WithNamespaceID adds the namespaceID to the waypoint service get agent group params
func (o *WaypointServiceGetAgentGroupParams) WithNamespaceID(namespaceID *string) *WaypointServiceGetAgentGroupParams {
	o.SetNamespaceID(namespaceID)
	return o
}

// SetNamespaceID adds the namespaceId to the waypoint service get agent group params
func (o *WaypointServiceGetAgentGroupParams) SetNamespaceID(namespaceID *string) {
	o.NamespaceID = namespaceID
}

// WithNamespaceLocationOrganizationID adds the namespaceLocationOrganizationID to the waypoint service get agent group params
func (o *WaypointServiceGetAgentGroupParams) WithNamespaceLocationOrganizationID(namespaceLocationOrganizationID string) *WaypointServiceGetAgentGroupParams {
	o.SetNamespaceLocationOrganizationID(namespaceLocationOrganizationID)
	return o
}

// SetNamespaceLocationOrganizationID adds the namespaceLocationOrganizationId to the waypoint service get agent group params
func (o *WaypointServiceGetAgentGroupParams) SetNamespaceLocationOrganizationID(namespaceLocationOrganizationID string) {
	o.NamespaceLocationOrganizationID = namespaceLocationOrganizationID
}

// WithNamespaceLocationProjectID adds the namespaceLocationProjectID to the waypoint service get agent group params
func (o *WaypointServiceGetAgentGroupParams) WithNamespaceLocationProjectID(namespaceLocationProjectID string) *WaypointServiceGetAgentGroupParams {
	o.SetNamespaceLocationProjectID(namespaceLocationProjectID)
	return o
}

// SetNamespaceLocationProjectID adds the namespaceLocationProjectId to the waypoint service get agent group params
func (o *WaypointServiceGetAgentGroupParams) SetNamespaceLocationProjectID(namespaceLocationProjectID string) {
	o.NamespaceLocationProjectID = namespaceLocationProjectID
}

// WithNamespaceLocationRegionProvider adds the namespaceLocationRegionProvider to the waypoint service get agent group params
func (o *WaypointServiceGetAgentGroupParams) WithNamespaceLocationRegionProvider(namespaceLocationRegionProvider *string) *WaypointServiceGetAgentGroupParams {
	o.SetNamespaceLocationRegionProvider(namespaceLocationRegionProvider)
	return o
}

// SetNamespaceLocationRegionProvider adds the namespaceLocationRegionProvider to the waypoint service get agent group params
func (o *WaypointServiceGetAgentGroupParams) SetNamespaceLocationRegionProvider(namespaceLocationRegionProvider *string) {
	o.NamespaceLocationRegionProvider = namespaceLocationRegionProvider
}

// WithNamespaceLocationRegionRegion adds the namespaceLocationRegionRegion to the waypoint service get agent group params
func (o *WaypointServiceGetAgentGroupParams) WithNamespaceLocationRegionRegion(namespaceLocationRegionRegion *string) *WaypointServiceGetAgentGroupParams {
	o.SetNamespaceLocationRegionRegion(namespaceLocationRegionRegion)
	return o
}

// SetNamespaceLocationRegionRegion adds the namespaceLocationRegionRegion to the waypoint service get agent group params
func (o *WaypointServiceGetAgentGroupParams) SetNamespaceLocationRegionRegion(namespaceLocationRegionRegion *string) {
	o.NamespaceLocationRegionRegion = namespaceLocationRegionRegion
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointServiceGetAgentGroupParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if o.NamespaceID != nil {

		// query param namespace.id
		var qrNamespaceID string

		if o.NamespaceID != nil {
			qrNamespaceID = *o.NamespaceID
		}
		qNamespaceID := qrNamespaceID
		if qNamespaceID != "" {

			if err := r.SetQueryParam("namespace.id", qNamespaceID); err != nil {
				return err
			}
		}
	}

	// path param namespace.location.organization_id
	if err := r.SetPathParam("namespace.location.organization_id", o.NamespaceLocationOrganizationID); err != nil {
		return err
	}

	// path param namespace.location.project_id
	if err := r.SetPathParam("namespace.location.project_id", o.NamespaceLocationProjectID); err != nil {
		return err
	}

	if o.NamespaceLocationRegionProvider != nil {

		// query param namespace.location.region.provider
		var qrNamespaceLocationRegionProvider string

		if o.NamespaceLocationRegionProvider != nil {
			qrNamespaceLocationRegionProvider = *o.NamespaceLocationRegionProvider
		}
		qNamespaceLocationRegionProvider := qrNamespaceLocationRegionProvider
		if qNamespaceLocationRegionProvider != "" {

			if err := r.SetQueryParam("namespace.location.region.provider", qNamespaceLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.NamespaceLocationRegionRegion != nil {

		// query param namespace.location.region.region
		var qrNamespaceLocationRegionRegion string

		if o.NamespaceLocationRegionRegion != nil {
			qrNamespaceLocationRegionRegion = *o.NamespaceLocationRegionRegion
		}
		qNamespaceLocationRegionRegion := qrNamespaceLocationRegionRegion
		if qNamespaceLocationRegionRegion != "" {

			if err := r.SetQueryParam("namespace.location.region.region", qNamespaceLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
