/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.postprocessing.filter;

import com.intellij.ml.inline.completion.features.correctness.SuggestionEnricher;
import com.intellij.ml.inline.completion.impl.AnalyzedMLCompletionProposal;
import com.intellij.ml.inline.completion.impl.MLCompletionParameters;
import com.intellij.ml.inline.completion.impl.kit.MLCompletionLanguageKit;
import com.intellij.ml.inline.completion.impl.postprocessing.analyzer.CorrectnessAnalysisState;
import com.intellij.ml.inline.completion.impl.postprocessing.filter.ProposalFilter;
import com.intellij.ml.inline.completion.impl.postprocessing.util.MLCompletionCommentsUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/inline/completion/impl/postprocessing/filter/CompletionContainsCommentFilter;", "Lcom/intellij/ml/inline/completion/impl/postprocessing/filter/ProposalFilter$Adapter;", "kit", "Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionLanguageKit;", "parameters", "Lcom/intellij/ml/inline/completion/impl/MLCompletionParameters;", "<init>", "(Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionLanguageKit;Lcom/intellij/ml/inline/completion/impl/MLCompletionParameters;)V", "checkAnalyzed", "", "proposal", "Lcom/intellij/ml/inline/completion/impl/AnalyzedMLCompletionProposal;", "intellij.fullLine.core.completion"})
public final class CompletionContainsCommentFilter
extends ProposalFilter.Adapter {
    @NotNull
    private final MLCompletionLanguageKit kit;
    @NotNull
    private final MLCompletionParameters parameters;

    public CompletionContainsCommentFilter(@NotNull MLCompletionLanguageKit kit, @NotNull MLCompletionParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)kit, (String)"kit");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        super("contains comment");
        this.kit = kit;
        this.parameters = parameters;
    }

    @Override
    public boolean checkAnalyzed(@NotNull AnalyzedMLCompletionProposal proposal) {
        Intrinsics.checkNotNullParameter((Object)proposal, (String)"proposal");
        if (!this.parameters.isComment()) {
            CorrectnessAnalysisState correctnessState = proposal.getCorrectnessState();
            if (!(correctnessState instanceof CorrectnessAnalysisState.Analyzed)) {
                if (Intrinsics.areEqual((Object)correctnessState, (Object)CorrectnessAnalysisState.Unknown.INSTANCE)) {
                    return true;
                }
                throw new NoWhenBranchMatchedException();
            }
            SuggestionEnricher.Enrichment enrichment = ((CorrectnessAnalysisState.Analyzed)correctnessState).getEnrichment();
            PsiFile file = enrichment.component2();
            TextRange range = enrichment.component3();
            if (file == null) {
                return true;
            }
            return MLCompletionCommentsUtil.INSTANCE.findComments(this.kit, file, range, 1).isEmpty();
        }
        return true;
    }
}

