package dts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePreCheckStatus invokes the dts.DescribePreCheckStatus API synchronously
func (client *Client) DescribePreCheckStatus(request *DescribePreCheckStatusRequest) (response *DescribePreCheckStatusResponse, err error) {
	response = CreateDescribePreCheckStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePreCheckStatusWithChan invokes the dts.DescribePreCheckStatus API asynchronously
func (client *Client) DescribePreCheckStatusWithChan(request *DescribePreCheckStatusRequest) (<-chan *DescribePreCheckStatusResponse, <-chan error) {
	responseChan := make(chan *DescribePreCheckStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePreCheckStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePreCheckStatusWithCallback invokes the dts.DescribePreCheckStatus API asynchronously
func (client *Client) DescribePreCheckStatusWithCallback(request *DescribePreCheckStatusRequest, callback func(response *DescribePreCheckStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePreCheckStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribePreCheckStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePreCheckStatusRequest is the request struct for api DescribePreCheckStatus
type DescribePreCheckStatusRequest struct {
	*requests.RpcRequest
	StructType  string `position:"Query" name:"StructType"`
	PageNo      string `position:"Query" name:"PageNo"`
	PageSize    string `position:"Query" name:"PageSize"`
	JobCode     string `position:"Query" name:"JobCode"`
	Name        string `position:"Query" name:"Name"`
	DtsJobId    string `position:"Query" name:"DtsJobId"`
	StructPhase string `position:"Query" name:"StructPhase"`
}

// DescribePreCheckStatusResponse is the response struct for api DescribePreCheckStatus
type DescribePreCheckStatusResponse struct {
	*responses.BaseResponse
	State                   string                        `json:"State" xml:"State"`
	Success                 bool                          `json:"Success" xml:"Success"`
	PageRecordCount         int64                         `json:"PageRecordCount" xml:"PageRecordCount"`
	Total                   int                           `json:"Total" xml:"Total"`
	HttpStatusCode          int                           `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId               string                        `json:"RequestId" xml:"RequestId"`
	JobName                 string                        `json:"JobName" xml:"JobName"`
	JobId                   string                        `json:"JobId" xml:"JobId"`
	ErrorItem               int                           `json:"ErrorItem" xml:"ErrorItem"`
	TotalRecordCount        int64                         `json:"TotalRecordCount" xml:"TotalRecordCount"`
	Code                    string                        `json:"Code" xml:"Code"`
	PageNumber              int64                         `json:"PageNumber" xml:"PageNumber"`
	JobProgress             []ProgressInfo                `json:"JobProgress" xml:"JobProgress"`
	SubDistributedJobStatus []SubDistributedJobStatusItem `json:"SubDistributedJobStatus" xml:"SubDistributedJobStatus"`
}

// CreateDescribePreCheckStatusRequest creates a request to invoke DescribePreCheckStatus API
func CreateDescribePreCheckStatusRequest() (request *DescribePreCheckStatusRequest) {
	request = &DescribePreCheckStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2020-01-01", "DescribePreCheckStatus", "dts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribePreCheckStatusResponse creates a response to parse from DescribePreCheckStatus response
func CreateDescribePreCheckStatusResponse() (response *DescribePreCheckStatusResponse) {
	response = &DescribePreCheckStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
