//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

// Created by Z. Francis

#ifndef G4DNAMeltonAttachmentModel_h
#define G4DNAMeltonAttachmentModel_h 1

#include "G4VEmModel.hh"
#include "G4ParticleChangeForGamma.hh"
#include "G4DNAGenericIonsManager.hh"
#include "G4DNACrossSectionDataSet.hh"
#include "G4Electron.hh"
#include "G4LogLogInterpolation.hh"
#include "G4NistManager.hh"

class G4DNAMeltonAttachmentModel : public G4VEmModel
{
public:
  G4DNAMeltonAttachmentModel(const G4ParticleDefinition* p = nullptr, 
		             const G4String& nam = "DNAMeltonAttachmentModel");

  ~G4DNAMeltonAttachmentModel() override;

  G4DNAMeltonAttachmentModel & operator=(const  G4DNAMeltonAttachmentModel &right) = delete;
  G4DNAMeltonAttachmentModel(const  G4DNAMeltonAttachmentModel&) = delete;

  void Initialise(const G4ParticleDefinition*, const G4DataVector&) override;

  G4double CrossSectionPerVolume(const G4Material* material,
					 const G4ParticleDefinition* p,
					 G4double ekin,
					 G4double emin,
					 G4double emax) override;

  void SampleSecondaries(std::vector<G4DynamicParticle*>*,
				 const G4MaterialCutsCouple*,
				 const G4DynamicParticle*,
				 G4double tmin,
				 G4double maxEnergy) override;

  inline void SetDissociationFlag(G4bool);
  inline G4bool GetDissociationFlag();

  inline void SelectStationary(G4bool input); 

protected:
  G4ParticleChangeForGamma* fParticleChangeForGamma;

private:
  G4bool statCode;

  // Water density table
  const std::vector<G4double>* fpWaterDensity;

  G4bool isInitialised{false};
  G4int verboseLevel;
  G4bool fDissociationFlag;
  
  // Cross section
  G4DNACrossSectionDataSet* fData;
  
};

inline void G4DNAMeltonAttachmentModel::SetDissociationFlag(G4bool flag)
{
  fDissociationFlag = flag;
}

inline G4bool G4DNAMeltonAttachmentModel::GetDissociationFlag()
{
  return fDissociationFlag;
}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo....

inline void G4DNAMeltonAttachmentModel::SelectStationary (G4bool input)
{ 
    statCode = input; 
}		 

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo....

#endif
