/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.model.DataStub;
import com.intellij.database.model.ModelEntityStorage;
import com.intellij.database.model.ModelEntityStoragePersistentBackendKt;
import com.intellij.database.model.NameValueGetter;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDataObject;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.CorruptedException;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.IntInlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.PersistentMapBuilder;
import com.intellij.util.io.StorageLockContext;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u00012\u00020\u0002:\u0001=B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u0011\u001a\u00020\u0012J,\u0010\u0013\u001a\u00020\u00142\"\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e0\fj\u0002`\u0010H\u0002J$\u0010\u0016\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e0\fj\u0002`\u0010H\u0002J\u001e\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\r2\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0016J\"\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\r2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0018H\u0016J\u0011\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\rH\u0096\u0002J\n\u0010 \u001a\u0004\u0018\u00010!H\u0016J\u0012\u0010\"\u001a\u00020\u00142\b\u0010#\u001a\u0004\u0018\u00010!H\u0016J\b\u0010$\u001a\u00020\u0012H\u0016J3\u0010%\u001a\u00020\u0012\"\u0004\b\u0000\u0010&2\u0006\u0010'\u001a\u00020\r2\b\u0010(\u001a\u0004\u0018\u0001H&2\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H&0*H\u0016\u00a2\u0006\u0002\u0010+JM\u0010,\u001a\u00020\u0012\"\u0004\b\u0000\u0010&2\u0018\u0010-\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H&000/0.2\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H&0*2\u0006\u00101\u001a\u00020\r2\b\u00102\u001a\u0004\u0018\u0001H&H\u0002\u00a2\u0006\u0002\u00103J\u0010\u00104\u001a\u00020\u00142\u0006\u00105\u001a\u00020\u0001H\u0016J\b\u00106\u001a\u00020\u0014H\u0016J\u0006\u00107\u001a\u00020\u0014J\u0006\u00108\u001a\u00020\u0014J\u0010\u00108\u001a\u00020\u00142\u0006\u00109\u001a\u00020\u0012H\u0002J\b\u0010:\u001a\u00020\u0014H\u0016J\b\u0010;\u001a\u00020\u0014H\u0016J\b\u0010<\u001a\u00020\u0014H\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u000b\u001a\"\u0012\u0004\u0012\u00020\r\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e\u0018\u00010\fj\u0004\u0018\u0001`\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/intellij/database/model/ModelEntityStoragePersistentBackend;", "Lcom/intellij/database/model/ModelEntityStorage$Backend;", "Lcom/intellij/openapi/Disposable;", "path", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "getPath", "()Ljava/nio/file/Path;", "lock", "", "dataObjectStore", "Lcom/intellij/util/io/PersistentHashMap;", "", "", "", "Lcom/intellij/database/model/DataObjectStore;", "isClosed", "", "validate", "", "phm", "opened", "getDataObject", "Lcom/intellij/database/model/basic/BasicDataObject;", "entityId", "meta", "Lcom/intellij/database/model/meta/BasicMetaObject;", "setDataObject", "parentEntityId", "entity", "contains", "loadInfo", "Lcom/intellij/database/model/ModelEntityStorage$Info;", "storeInfo", "info", "isPersistent", "processHierarchy", "V", "rootEntityId", "root", "processor", "Lcom/intellij/database/model/ModelEntityStorage$HProcessor;", "(ILjava/lang/Object;Lcom/intellij/database/model/ModelEntityStorage$HProcessor;)Z", "process", "hierarchy", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "", "Lcom/intellij/database/model/ModelEntityStoragePersistentBackend$Obj;", "parentId", "parent", "(Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;Lcom/intellij/database/model/ModelEntityStorage$HProcessor;ILjava/lang/Object;)Z", "moveEntities", "backend", "clear", "force", "close", "clean", "shelve", "dispose", "finalize", "Obj", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nModelEntityStoragePersistentBackend.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelEntityStoragePersistentBackend.kt\ncom/intellij/database/model/ModelEntityStoragePersistentBackend\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,334:1\n1#2:335\n1869#3,2:336\n*S KotlinDebug\n*F\n+ 1 ModelEntityStoragePersistentBackend.kt\ncom/intellij/database/model/ModelEntityStoragePersistentBackend\n*L\n235#1:336,2\n*E\n"})
public final class ModelEntityStoragePersistentBackend
implements ModelEntityStorage.Backend,
Disposable {
    @NotNull
    private final Path path;
    @NotNull
    private final Object lock;
    @Nullable
    private PersistentHashMap<Integer, Map<String, String>> dataObjectStore;

    public ModelEntityStoragePersistentBackend(@NotNull Path path) throws IOException {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
        this.lock = new Object();
        try {
            this.validate(this.opened());
        }
        catch (Throwable th) {
            this.close(true);
            throw th;
        }
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    public final boolean isClosed() {
        PersistentHashMap<Integer, Map<String, String>> persistentHashMap = this.dataObjectStore;
        return !(persistentHashMap != null ? !persistentHashMap.isClosed() : false);
    }

    private final void validate(PersistentHashMap<Integer, Map<String, String>> phm) throws IOException {
        phm.processKeysWithExistingMapping(arg_0 -> ModelEntityStoragePersistentBackend.validate$lambda$1(arg_0 -> ModelEntityStoragePersistentBackend.validate$lambda$0(phm, arg_0), arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final PersistentHashMap<Integer, Map<String, String>> opened() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            PersistentHashMap<Integer, Map<String, String>> persistentHashMap = this.dataObjectStore;
            if (persistentHashMap != null) {
                PersistentHashMap<Integer, Map<String, String>> it = persistentHashMap;
                boolean bl2 = false;
                return it;
            }
            try {
                PersistentHashMap persistentHashMap2;
                PersistentHashMap it = persistentHashMap2 = PersistentMapBuilder.newBuilder((Path)this.path, (KeyDescriptor)((KeyDescriptor)new IntInlineKeyDescriptor()), (DataExternalizer)((DataExternalizer)new DataExternalizer<Map<String, ? extends String>>(){

                    public void save(DataOutput out, Map<String, String> value) {
                        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                        Intrinsics.checkNotNullParameter(value, (String)"value");
                        this.writeProperties(out, value);
                    }

                    private final void writeProperties(DataOutput out, Map<String, String> value) {
                        Map<String, String> $this$forEach$iv = value;
                        boolean $i$f$forEach = false;
                        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry<String, String> element$iv;
                            Map.Entry<String, String> entry = element$iv = iterator.next();
                            boolean bl = false;
                            String n = entry.getKey();
                            String v = entry.getValue();
                            IOUtil.writeUTF((DataOutput)out, (String)n);
                            IOUtil.writeUTF((DataOutput)out, (String)v);
                        }
                        IOUtil.writeUTF((DataOutput)out, (String)"");
                    }

                    public Map<String, String> read(DataInput input) {
                        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                        return this.readProperties(input);
                    }

                    private final Map<String, String> readProperties(DataInput input) {
                        HashMap<K, V> props = new HashMap<K, V>();
                        while (true) {
                            String n = IOUtil.readUTF((DataInput)input);
                            Intrinsics.checkNotNull((Object)n);
                            if (((CharSequence)n).length() == 0) break;
                            String v = IOUtil.readUTF((DataInput)input);
                            ((Map)props).put(n, v);
                        }
                        return props;
                    }
                })).withStorageLockContext(new StorageLockContext()).build();
                boolean bl3 = false;
                this.dataObjectStore = it;
                PersistentHashMap persistentHashMap3 = persistentHashMap2;
                Intrinsics.checkNotNullExpressionValue((Object)persistentHashMap3, (String)"also(...)");
                return persistentHashMap3;
            }
            catch (Throwable th) {
                this.close(th instanceof CorruptedException);
                throw th;
            }
        }
    }

    @Override
    @Nullable
    public BasicDataObject getDataObject(int entityId, @NotNull BasicMetaObject<?> meta) {
        Intrinsics.checkNotNullParameter(meta, (String)"meta");
        Map props = (Map)this.opened().get((Object)entityId);
        if (props == null) {
            return null;
        }
        Object obj2 = meta.newDataObject();
        Intrinsics.checkNotNull(obj2, (String)"null cannot be cast to non-null type com.intellij.database.model.basic.BasicDataObject");
        BasicDataObject data = (BasicDataObject)obj2;
        data.importProperties(new NameValueGetter.FromMap(props));
        return data;
    }

    @Override
    public void setDataObject(int entityId, int parentEntityId, @Nullable BasicDataObject entity) {
        if (entity == null) {
            this.opened().remove((Object)entityId);
        } else if (entity.isFrozen()) {
            LinkedHashMap props = new LinkedHashMap();
            entity.exportProperties((arg_0, arg_1) -> ModelEntityStoragePersistentBackend.setDataObject$lambda$5(props, arg_0, arg_1));
            if (parentEntityId != Integer.MIN_VALUE) {
                ((Map)props).put("_parent_id", String.valueOf(parentEntityId));
            }
            ((Map)props).put("_kind", entity.getMetaObject().kind.code());
            this.opened().put((Object)entityId, props);
        }
        ModelEntityStoragePersistentBackendKt.access$getOurFlusher$p().modified();
    }

    @Override
    public boolean contains(int entityId) {
        return this.opened().containsMapping((Object)entityId);
    }

    @Override
    @Nullable
    public ModelEntityStorage.Info loadInfo() {
        ModelEntityStorage.Info info;
        Map infoProps = (Map)this.opened().get((Object)Integer.MIN_VALUE);
        if (infoProps == null) {
            return null;
        }
        ModelEntityStorage.Info $this$loadInfo_u24lambda_u246 = info = new ModelEntityStorage.Info();
        boolean bl = false;
        Object object = (String)infoProps.get("version");
        $this$loadInfo_u24lambda_u246.version = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 0;
        Object object2 = (String)infoProps.get("idCurrentValue");
        $this$loadInfo_u24lambda_u246.idCurrentValue = object2 != null && (object2 = StringsKt.toIntOrNull((String)object2)) != null ? (Integer)object2 : 0;
        $this$loadInfo_u24lambda_u246.dbms = (String)infoProps.get("dbms");
        return info;
    }

    @Override
    public void storeInfo(@Nullable ModelEntityStorage.Info info) {
        if (info == null) {
            this.opened().remove((Object)Integer.MIN_VALUE);
        } else {
            LinkedHashMap props = new LinkedHashMap();
            ((Map)props).put("version", String.valueOf(info.version));
            ((Map)props).put("idCurrentValue", String.valueOf(info.idCurrentValue));
            if (info.dbms != null) {
                ((Map)props).put("dbms", info.dbms);
            }
            this.opened().put((Object)Integer.MIN_VALUE, props);
        }
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    @Override
    public <V> boolean processHierarchy(int rootEntityId, @Nullable V root, @NotNull ModelEntityStorage.HProcessor<V> processor) {
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        Int2ObjectOpenHashMap hierarchy = new Int2ObjectOpenHashMap();
        PersistentHashMap<Integer, Map<String, String>> store = this.opened();
        store.processKeysWithExistingMapping(arg_0 -> ModelEntityStoragePersistentBackend.processHierarchy$lambda$9(arg_0 -> ModelEntityStoragePersistentBackend.processHierarchy$lambda$8(store, hierarchy, arg_0), arg_0));
        return this.process((Int2ObjectMap)hierarchy, processor, rootEntityId, root);
    }

    private final <V> boolean process(Int2ObjectMap<List<Obj<V>>> hierarchy, ModelEntityStorage.HProcessor<V> processor, int parentId, V parent) {
        List list = (List)hierarchy.remove(parentId);
        if (list == null) {
            return false;
        }
        List children2 = list;
        processor.process(children2, parent, ModelEntityStoragePersistentBackend::process$lambda$10);
        Iterable $this$forEach$iv = children2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object processed;
            Obj it = (Obj)element$iv;
            boolean bl = false;
            if (it.getProcessed() == null) continue;
            it.setProcessed(null);
            this.process(hierarchy, processor, it.getEntityId(), processed);
        }
        return true;
    }

    @Override
    public void moveEntities(@NotNull ModelEntityStorage.Backend backend) {
        Intrinsics.checkNotNullParameter((Object)backend, (String)"backend");
        if (!(backend instanceof ModelEntityStoragePersistentBackend)) {
            return;
        }
        PersistentHashMap<Integer, Map<String, String>> source = this.opened();
        PersistentHashMap<Integer, Map<String, String>> target2 = ((ModelEntityStoragePersistentBackend)backend).opened();
        source.processKeysWithExistingMapping(arg_0 -> ModelEntityStoragePersistentBackend.moveEntities$lambda$13(arg_0 -> ModelEntityStoragePersistentBackend.moveEntities$lambda$12(target2, source, arg_0), arg_0));
        ModelEntityStoragePersistentBackendKt.access$getOurFlusher$p().modified();
    }

    @Override
    public void clear() {
        this.opened();
        this.close(true);
        this.opened();
    }

    public final void force() {
        block0: {
            PersistentHashMap<Integer, Map<String, String>> persistentHashMap = this.dataObjectStore;
            if (persistentHashMap == null) break block0;
            persistentHashMap.force();
        }
    }

    public final void close() {
        this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void close(boolean clean) {
        Object object = this.lock;
        synchronized (object) {
            Unit unit;
            boolean bl = false;
            PersistentHashMap<Integer, Map<String, String>> store = this.dataObjectStore;
            this.dataObjectStore = null;
            try {
                Unit unit2;
                if (clean) {
                    try {
                        Unit unit3;
                        PersistentHashMap<Integer, Map<String, String>> persistentHashMap = store;
                        if (persistentHashMap != null) {
                            persistentHashMap.closeAndClean();
                            unit3 = Unit.INSTANCE;
                        } else {
                            unit3 = null;
                        }
                        unit = unit3;
                    }
                    finally {
                        FileUtil.delete((Path)this.path.getParent());
                    }
                    unit2 = unit;
                } else {
                    PersistentHashMap<Integer, Map<String, String>> persistentHashMap = store;
                    if (persistentHashMap != null) {
                        persistentHashMap.close();
                        unit2 = Unit.INSTANCE;
                    } else {
                        unit2 = null;
                    }
                }
                unit = unit2;
            }
            catch (IOException e) {
                ModelEntityStoragePersistentBackendKt.access$getLogger$p().warn((Throwable)e);
                unit = Unit.INSTANCE;
            }
            Unit unit4 = unit;
        }
    }

    @Override
    public void shelve() {
        this.close();
    }

    public void dispose() {
        this.close();
    }

    protected final void finalize() {
        if (this.dataObjectStore != null) {
            Disposer.dispose((Disposable)this);
        }
    }

    private static final boolean validate$lambda$0(PersistentHashMap $phm, Integer key2) {
        $phm.get((Object)key2);
        return true;
    }

    private static final boolean validate$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void setDataObject$lambda$5(LinkedHashMap $props, String n, String v) {
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        ((Map)$props).put(n, v);
    }

    private static final boolean processHierarchy$lambda$8(PersistentHashMap $store, Int2ObjectOpenHashMap $hierarchy, Integer entityId) {
        Map props = (Map)$store.get((Object)entityId);
        if (props != null) {
            ObjectKind kind;
            String string = (String)props.get("_kind");
            if (string != null) {
                String it = string;
                boolean bl = false;
                v1 = ObjectKind.getKind(it);
            } else {
                v1 = kind = null;
            }
            if (kind != null) {
                List list;
                long objectId;
                Object object = (String)props.get("_parent_id");
                int parentId = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : Integer.MIN_VALUE;
                Object object2 = DataStub.create(props);
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"create(...)");
                Object stub = object2;
                Object object3 = (String)props.get(BasicModIdentifiedElement.OBJECT_ID.name);
                long l = objectId = object3 != null && (object3 = StringsKt.toLongOrNull((String)object3)) != null ? (Long)object3 : Long.MIN_VALUE;
                List list2 = (List)$hierarchy.get(parentId);
                if (list2 == null) {
                    list2 = new ArrayList();
                }
                if ((list = list2).isEmpty()) {
                    $hierarchy.put(parentId, (Object)list);
                }
                Collection collection = list;
                Intrinsics.checkNotNull((Object)entityId);
                collection.add(new Obj<Object>(entityId, kind, stub, objectId, null));
            }
        }
        return true;
    }

    private static final boolean processHierarchy$lambda$9(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void process$lambda$10(ModelEntityStorage.HProcessor.Child obj2, Object res) {
        Intrinsics.checkNotNull((Object)obj2, (String)"null cannot be cast to non-null type com.intellij.database.model.ModelEntityStoragePersistentBackend.Obj<V of com.intellij.database.model.ModelEntityStoragePersistentBackend.process>");
        ((Obj)obj2).setProcessed(res);
    }

    private static final boolean moveEntities$lambda$12(PersistentHashMap $target, PersistentHashMap $source, Integer k) {
        $target.put((Object)k, $source.get((Object)k));
        return true;
    }

    private static final boolean moveEntities$lambda$13(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0017\u001a\u00020\u0004H\u0016J\b\u0010\u0018\u001a\u00020\u0006H\u0016J\b\u0010\u0019\u001a\u00020\bH\u0016J\b\u0010\u001a\u001a\u00020\nH\u0016J\t\u0010\u001b\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\bH\u00c2\u0003J\t\u0010\u001e\u001a\u00020\nH\u00c2\u0003J\u0010\u0010\u001f\u001a\u0004\u0018\u00018\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0013JH\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00018\u0000H\u00c6\u0001\u00a2\u0006\u0002\u0010!J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\bH\u00d6\u0003J\t\u0010%\u001a\u00020\u0004H\u00d6\u0001J\t\u0010&\u001a\u00020'H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0004\u0018\u00018\u0000X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0016\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006("}, d2={"Lcom/intellij/database/model/ModelEntityStoragePersistentBackend$Obj;", "V", "Lcom/intellij/database/model/ModelEntityStorage$HProcessor$Child;", "id", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "stub", "", "objectId", "", "processed", "<init>", "(ILcom/intellij/database/model/ObjectKind;Ljava/lang/Object;JLjava/lang/Object;)V", "getId", "()I", "getKind", "()Lcom/intellij/database/model/ObjectKind;", "getProcessed", "()Ljava/lang/Object;", "setProcessed", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "getEntityId", "getObjectKind", "getStub", "getObjectId", "component1", "component2", "component3", "component4", "component5", "copy", "(ILcom/intellij/database/model/ObjectKind;Ljava/lang/Object;JLjava/lang/Object;)Lcom/intellij/database/model/ModelEntityStoragePersistentBackend$Obj;", "equals", "", "other", "hashCode", "toString", "", "intellij.database.core.impl"})
    public static final class Obj<V>
    implements ModelEntityStorage.HProcessor.Child {
        private final int id;
        @NotNull
        private final ObjectKind kind;
        @NotNull
        private final Object stub;
        private final long objectId;
        @Nullable
        private V processed;

        public Obj(int id, @NotNull ObjectKind kind, @NotNull Object stub, long objectId, @Nullable V processed) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
            this.id = id;
            this.kind = kind;
            this.stub = stub;
            this.objectId = objectId;
            this.processed = processed;
        }

        public final int getId() {
            return this.id;
        }

        @NotNull
        public final ObjectKind getKind() {
            return this.kind;
        }

        @Nullable
        public final V getProcessed() {
            return this.processed;
        }

        public final void setProcessed(@Nullable V v) {
            this.processed = v;
        }

        @Override
        public int getEntityId() {
            return this.id;
        }

        @Override
        @NotNull
        public ObjectKind getObjectKind() {
            return this.kind;
        }

        @Override
        @NotNull
        public Object getStub() {
            return this.stub;
        }

        @Override
        public long getObjectId() {
            return this.objectId;
        }

        public final int component1() {
            return this.id;
        }

        @NotNull
        public final ObjectKind component2() {
            return this.kind;
        }

        private final Object component3() {
            return this.stub;
        }

        private final long component4() {
            return this.objectId;
        }

        @Nullable
        public final V component5() {
            return this.processed;
        }

        @NotNull
        public final Obj<V> copy(int id, @NotNull ObjectKind kind, @NotNull Object stub, long objectId, @Nullable V processed) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
            return new Obj<V>(id, kind, stub, objectId, processed);
        }

        public static /* synthetic */ Obj copy$default(Obj obj2, int n, ObjectKind objectKind, Object object, long l, Object object2, int n2, Object object3) {
            if ((n2 & 1) != 0) {
                n = obj2.id;
            }
            if ((n2 & 2) != 0) {
                objectKind = obj2.kind;
            }
            if ((n2 & 4) != 0) {
                object = obj2.stub;
            }
            if ((n2 & 8) != 0) {
                l = obj2.objectId;
            }
            if ((n2 & 0x10) != 0) {
                object2 = obj2.processed;
            }
            return obj2.copy(n, objectKind, object, l, object2);
        }

        @NotNull
        public String toString() {
            return "Obj(id=" + this.id + ", kind=" + this.kind + ", stub=" + this.stub + ", objectId=" + this.objectId + ", processed=" + this.processed + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.id);
            result2 = result2 * 31 + this.kind.hashCode();
            result2 = result2 * 31 + this.stub.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.objectId);
            result2 = result2 * 31 + (this.processed == null ? 0 : this.processed.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Obj)) {
                return false;
            }
            Obj obj2 = (Obj)other;
            if (this.id != obj2.id) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.kind, (Object)obj2.kind)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.stub, (Object)obj2.stub)) {
                return false;
            }
            if (this.objectId != obj2.objectId) {
                return false;
            }
            return Intrinsics.areEqual(this.processed, obj2.processed);
        }
    }
}

