/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.script.generator;

import com.intellij.database.Dbms;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.script.generator.DefaultScriptingOptions;
import com.intellij.database.script.generator.ScriptingAlterTask;
import com.intellij.database.script.generator.ScriptingInternalTask;
import com.intellij.database.script.generator.ScriptingNativeDefinitionTask;
import com.intellij.database.script.generator.ScriptingSingleModelTask;
import com.intellij.database.script.generator.ScriptingTask;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\"\u0017\u0010\u0006\u001a\u0004\u0018\u00010\u0003*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0017\u0010\n\u001a\u0004\u0018\u00010\u0003*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\"\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u0017\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\"\u0017\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"defaultScriptingOptions", "Lcom/intellij/database/script/generator/DefaultScriptingOptions;", "model", "Lcom/intellij/database/model/basic/BasicModel;", "dbms", "Lcom/intellij/database/Dbms;", "anyModel", "Lcom/intellij/database/script/generator/ScriptingTask;", "getAnyModel", "(Lcom/intellij/database/script/generator/ScriptingTask;)Lcom/intellij/database/model/basic/BasicModel;", "newModel", "getNewModel", "getDbms", "(Lcom/intellij/database/script/generator/ScriptingTask;)Lcom/intellij/database/Dbms;", "anyCurrentDatabase", "Lcom/intellij/database/model/basic/BasicDatabase;", "getAnyCurrentDatabase", "(Lcom/intellij/database/script/generator/ScriptingTask;)Lcom/intellij/database/model/basic/BasicDatabase;", "anyCurrentSchema", "Lcom/intellij/database/model/basic/BasicSchema;", "getAnyCurrentSchema", "(Lcom/intellij/database/script/generator/ScriptingTask;)Lcom/intellij/database/model/basic/BasicSchema;", "intellij.database.core.impl"})
public final class ScriptingTaskKt {
    @NotNull
    public static final DefaultScriptingOptions defaultScriptingOptions(@NotNull BasicModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Dbms dbms = model.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        return ScriptingTaskKt.defaultScriptingOptions(dbms);
    }

    @NotNull
    public static final DefaultScriptingOptions defaultScriptingOptions(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        return DefaultScriptingOptions.INSTANCE;
    }

    @Nullable
    public static final BasicModel getAnyModel(@NotNull ScriptingTask $this$anyModel) {
        BasicModel basicModel;
        Intrinsics.checkNotNullParameter((Object)$this$anyModel, (String)"<this>");
        ScriptingTask scriptingTask = $this$anyModel;
        if (scriptingTask instanceof ScriptingSingleModelTask) {
            basicModel = ((ScriptingSingleModelTask)$this$anyModel).getModel();
        } else if (scriptingTask instanceof ScriptingNativeDefinitionTask) {
            basicModel = ((ScriptingNativeDefinitionTask)$this$anyModel).getModel();
        } else if (scriptingTask instanceof ScriptingAlterTask) {
            basicModel = ((ScriptingAlterTask)$this$anyModel).getSourceModel();
        } else if (scriptingTask instanceof ScriptingInternalTask) {
            basicModel = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return basicModel;
    }

    @Nullable
    public static final BasicModel getNewModel(@NotNull ScriptingTask $this$newModel) {
        BasicModel basicModel;
        Intrinsics.checkNotNullParameter((Object)$this$newModel, (String)"<this>");
        ScriptingTask scriptingTask = $this$newModel;
        if (scriptingTask instanceof ScriptingSingleModelTask) {
            basicModel = ((ScriptingSingleModelTask)$this$newModel).getModel();
        } else if (scriptingTask instanceof ScriptingNativeDefinitionTask) {
            basicModel = ((ScriptingNativeDefinitionTask)$this$newModel).getModel();
        } else if (scriptingTask instanceof ScriptingAlterTask) {
            basicModel = ((ScriptingAlterTask)$this$newModel).getTargetModel();
        } else if (scriptingTask instanceof ScriptingInternalTask) {
            basicModel = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return basicModel;
    }

    @NotNull
    public static final Dbms getDbms(@NotNull ScriptingTask $this$dbms) {
        Dbms dbms;
        Intrinsics.checkNotNullParameter((Object)$this$dbms, (String)"<this>");
        if ($this$dbms instanceof ScriptingInternalTask) {
            dbms = ((ScriptingInternalTask)$this$dbms).getDbms();
        } else {
            BasicModel basicModel = ScriptingTaskKt.getAnyModel($this$dbms);
            Intrinsics.checkNotNull((Object)basicModel);
            Dbms dbms2 = basicModel.getDbms();
            dbms = dbms2;
            Intrinsics.checkNotNullExpressionValue((Object)dbms2, (String)"getDbms(...)");
        }
        return dbms;
    }

    @Nullable
    public static final BasicDatabase getAnyCurrentDatabase(@NotNull ScriptingTask $this$anyCurrentDatabase) {
        Intrinsics.checkNotNullParameter((Object)$this$anyCurrentDatabase, (String)"<this>");
        BasicDatabase basicDatabase = $this$anyCurrentDatabase.getCurrentDatabase();
        if (basicDatabase == null) {
            CasingProvider casingProvider = ScriptingTaskKt.getAnyModel($this$anyCurrentDatabase);
            basicDatabase = casingProvider != null && (casingProvider = casingProvider.getRoot()) != null ? casingProvider.getCurrentDatabase() : null;
        }
        return basicDatabase;
    }

    @Nullable
    public static final BasicSchema getAnyCurrentSchema(@NotNull ScriptingTask $this$anyCurrentSchema) {
        Intrinsics.checkNotNullParameter((Object)$this$anyCurrentSchema, (String)"<this>");
        BasicSchema basicSchema = $this$anyCurrentSchema.getCurrentSchema();
        if (basicSchema == null) {
            BasicDatabase basicDatabase = ScriptingTaskKt.getAnyCurrentDatabase($this$anyCurrentSchema);
            basicSchema = basicDatabase != null ? ModelFun.getCurrentSchema(basicDatabase) : null;
        }
        return basicSchema;
    }
}

