/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.lang.template;

import com.intellij.codeInsight.template.impl.TemplatePreprocessor;
import com.intellij.jinja.template.psi.impl.DjangoTemplateFileImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public final class DjangoTemplatePreprocessor
implements TemplatePreprocessor {
    private static final Logger LOG = Logger.getInstance(DjangoTemplatePreprocessor.class);

    public void preprocessTemplate(Editor editor, PsiFile file, int caretOffset, String textToInsert, String templateText) {
        if (file instanceof DjangoTemplateFileImpl && templateText != null && !templateText.isEmpty()) {
            try {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    DjangoTemplatePreprocessor.removeEnd(editor, caretOffset);
                    DjangoTemplatePreprocessor.removeStart(editor, caretOffset);
                });
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private static void removeStart(@NotNull Editor editor, int caretOffset) {
        int lineNumber;
        int lineStartOffset;
        Document document;
        String lineText;
        int lastOccurenceOfOpenTag;
        if (editor == null) {
            DjangoTemplatePreprocessor.$$$reportNull$$$0(0);
        }
        if ((lastOccurenceOfOpenTag = (lineText = (document = editor.getDocument()).getText(TextRange.create((int)(lineStartOffset = document.getLineStartOffset(lineNumber = document.getLineNumber(caretOffset))), (int)caretOffset))).lastIndexOf("{%")) == -1) {
            return;
        }
        if (lineText.substring(lastOccurenceOfOpenTag).contains("%}")) {
            return;
        }
        int lastOccurenceOpenTagOffset = lineStartOffset + lastOccurenceOfOpenTag;
        document.deleteString(lastOccurenceOpenTagOffset, caretOffset);
    }

    private static void removeEnd(Editor editor, int caretOffset) {
        int end = CharArrayUtil.shiftForward((CharSequence)editor.getDocument().getCharsSequence(), (int)caretOffset, (String)" \t");
        String s = "%}";
        if (CharArrayUtil.regionMatches((CharSequence)editor.getDocument().getCharsSequence(), (int)end, (CharSequence)s)) {
            editor.getDocument().deleteString(end - 1, end + s.length());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/python/django/lang/template/DjangoTemplatePreprocessor", "removeStart"));
    }
}

