/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.resolve.JSResolveStatus;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSResolveResult
implements ResolveResult {
    public static final ProblemKind[] INSUFFICIENT_VISIBILITY_PROBLEM_KEYS = new ProblemKind[]{ProblemKind.ELEMENT_IS_NOT_ACCESSIBLE, ProblemKind.PRIVATE_MEMBER_IS_NOT_ACCESSIBLE, ProblemKind.PRIVATE_CONSTRUCTOR_IS_NOT_ACCESSIBLE, ProblemKind.PROTECTED_MEMBER_IS_NOT_ACCESSIBLE, ProblemKind.PROTECTED_CONSTRUCTOR_IS_NOT_ACCESSIBLE, ProblemKind.JS_PRIVATE_MEMBER_IS_NOT_ACCESSIBLE, ProblemKind.JS_PROTECTED_MEMBER_IS_NOT_ACCESSIBLE};
    @NonNls
    public static final String ARGUMENT_TYPES_MISMATCH = "javascript.argument.types.mismatch";
    public static final Key<JSElement> IMPORT_KEY = Key.create((String)"import.key");
    public static final Key<JSTypeSubstitutor> GENERICS = Key.create((String)"ts.generics.resolve.state");
    @Nullable
    private final PsiElement myElement;
    @Nullable
    private final JSResolveStatus myStatus;
    private static final ResolveResult TOO_MANY_CANDIDATES = new JSResolveResult(null);
    private static final ResolveResult[] TOO_MANY_CANDIDATES_ARRAY = new ResolveResult[]{TOO_MANY_CANDIDATES};

    public JSResolveResult(@Nullable PsiElement element2) {
        this(element2, null, null);
    }

    public JSResolveResult(@Nullable PsiElement element2, @Nullable JSElement importUsed, @Nullable ProblemKind problemKind) {
        this(element2, (JSResolveStatus)(importUsed == null && problemKind == null ? null : new JSResolveStatus(importUsed, problemKind, null)));
    }

    public JSResolveResult(@Nullable PsiElement element2, @Nullable JSResolveStatus resolveStatus) {
        this.myElement = element2;
        this.myStatus = resolveStatus;
    }

    @Nullable
    public PsiElement getElement() {
        return this.myElement;
    }

    @Nullable
    public JSTypeSubstitutor getTypeSubstitutor() {
        return this.myStatus != null ? this.myStatus.getSubstitutor() : null;
    }

    public boolean isValidResult() {
        return this.myStatus == null || this.myStatus.myResolveProblem == null;
    }

    @Nullable
    public JSImportStatement getActionScriptImport() {
        JSElement element2 = this.getImportElement();
        return element2 instanceof JSImportStatement ? (JSImportStatement)element2 : null;
    }

    @NotNull
    public JSResolveStatus getStatus() {
        JSResolveStatus emptyStatus;
        if (this.myStatus != null) {
            JSResolveStatus jSResolveStatus = this.myStatus;
            if (jSResolveStatus == null) {
                JSResolveResult.$$$reportNull$$$0(0);
            }
            return jSResolveStatus;
        }
        JSResolveStatus jSResolveStatus = emptyStatus = new JSResolveStatus(null, null, null, false);
        if (jSResolveStatus == null) {
            JSResolveResult.$$$reportNull$$$0(1);
        }
        return jSResolveStatus;
    }

    @Nullable
    private JSElement getImportElement() {
        return this.myStatus == null ? null : this.myStatus.usedImportOrExport;
    }

    @Nullable
    public ES6ImportExportDeclarationPart getES6Import() {
        JSElement element2 = this.getImportElement();
        return element2 instanceof ES6ImportExportDeclarationPart ? (ES6ImportExportDeclarationPart)element2 : null;
    }

    @Nullable
    public ProblemKind getResolveProblemKind() {
        return this.myStatus != null ? this.myStatus.myResolveProblem : null;
    }

    @Nullable
    public static PsiElement resolveAny(ResolveResult @NotNull [] results) {
        if (results == null) {
            JSResolveResult.$$$reportNull$$$0(2);
        }
        for (ResolveResult result2 : results) {
            PsiElement element2 = result2.getElement();
            if (!result2.isValidResult() || element2 == null) continue;
            return element2;
        }
        return results.length > 0 ? results[0].getElement() : null;
    }

    @Nullable
    public static PsiElement resolve(ResolveResult @NotNull [] results) {
        if (results == null) {
            JSResolveResult.$$$reportNull$$$0(3);
        }
        return results.length == 1 && results[0].isValidResult() ? results[0].getElement() : null;
    }

    @NotNull
    public static List<PsiElement> toElements(ResolveResult @Nullable [] results, boolean ignoreInvalid) {
        if (results == null || results.length == 0) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSResolveResult.$$$reportNull$$$0(4);
            }
            return list;
        }
        ArrayList<PsiElement> psiElements = new ArrayList<PsiElement>(results.length);
        for (ResolveResult result2 : results) {
            PsiElement element2;
            if (ignoreInvalid && !result2.isValidResult() || (element2 = result2.getElement()) == null) continue;
            psiElements.add(element2);
        }
        ArrayList<PsiElement> arrayList = psiElements;
        if (arrayList == null) {
            JSResolveResult.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    public static Collection<PsiElement> resolveReference(@NotNull PsiPolyVariantReference reference) {
        if (reference == null) {
            JSResolveResult.$$$reportNull$$$0(6);
        }
        ResolveResult[] results = reference.multiResolve(false);
        return JSResolveResult.toElements(results);
    }

    @NotNull
    public static List<PsiElement> toElements(ResolveResult @Nullable [] results) {
        return JSResolveResult.toElements(results, true);
    }

    public static ResolveResult[] toResolveResults(@NotNull Collection<? extends PsiElement> elements) {
        if (elements == null) {
            JSResolveResult.$$$reportNull$$$0(7);
        }
        return (ResolveResult[])elements.stream().map(el -> new JSResolveResult((PsiElement)el)).toArray(ResolveResult[]::new);
    }

    public static ResolveResult @NotNull [] transformElements(ResolveResult @NotNull [] results, @NotNull Function<? super PsiElement, ? extends PsiElement> transform) {
        if (transform == null) {
            JSResolveResult.$$$reportNull$$$0(8);
        }
        if (results == null) {
            JSResolveResult.$$$reportNull$$$0(9);
        }
        ResolveResult[] newResults = new ResolveResult[results.length];
        for (int i = 0; i < results.length; ++i) {
            ResolveResult result2 = results[i];
            newResults[i] = JSResolveResult.transformElement(transform, result2);
        }
        if (newResults == null) {
            JSResolveResult.$$$reportNull$$$0(10);
        }
        return newResults;
    }

    @Contract(value="_,!null->!null")
    public static ResolveResult transformElement(@NotNull Function<? super PsiElement, ? extends PsiElement> transform, @Nullable ResolveResult result2) {
        if (transform == null) {
            JSResolveResult.$$$reportNull$$$0(11);
        }
        return result2 instanceof JSResolveResult ? new JSResolveResult(transform.apply((PsiElement)result2.getElement()), ((JSResolveResult)result2).getStatus()) : result2;
    }

    public String toString() {
        ProblemKind problemKind = this.getResolveProblemKind();
        return "JSResolveResult{myElement=" + String.valueOf(this.myElement) + ", myImportUsed=" + String.valueOf(this.getImportElement()) + ", myResolveProblemKey='" + (problemKind != null ? problemKind.getMessageKey() : null) + "'}";
    }

    public static ResolveResult @NotNull [] tooManyCandidatesResult() {
        if (TOO_MANY_CANDIDATES_ARRAY == null) {
            JSResolveResult.$$$reportNull$$$0(12);
        }
        return TOO_MANY_CANDIDATES_ARRAY;
    }

    public static boolean isTooManyCandidatesResult(ResolveResult @Nullable [] results) {
        return results != null && results.length == 1 && results[0] == TOO_MANY_CANDIDATES;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSResolveResult result2 = (JSResolveResult)o;
        return Objects.equals(this.myElement, result2.myElement) && Objects.equals(this.myStatus, result2.myStatus);
    }

    public int hashCode() {
        return Objects.hash(this.myElement, this.myStatus);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 6, 7, 8, 9, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSResolveResult";
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSResolveResult";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toElements";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "transformElements";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "tooManyCandidatesResult";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveAny";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveReference";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "toResolveResults";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "transformElements";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "transformElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 6, 7, 8, 9, 11 -> new IllegalArgumentException(string);
        };
    }

    public static enum ProblemKind {
        QUALIFIED_NAME_IS_NOT_IMPORTED("javascript.qualified.name.is.not.imported.message"),
        ELEMENT_IS_NOT_ACCESSIBLE("javascript.element.is.not.accessible.message"),
        PROTECTED_MEMBER_IS_NOT_ACCESSIBLE("javascript.protected.member.is.not.accessible.message"),
        PROTECTED_CONSTRUCTOR_IS_NOT_ACCESSIBLE("javascript.protected.constructor.is.not.accessible.message"),
        MEMBER_FROM_UNOPENED_NAMESPACE("javascript.member.from.unopened.namespace.message"),
        PROPERTY_IS_READ_ONLY("javascript.property.is.read.only.message"),
        PROPERTY_IS_WRITE_ONLY("javascript.property.is.write.only.message"),
        PRIVATE_MEMBER_IS_NOT_ACCESSIBLE("javascript.private.member.is.not.accessible.message"),
        PRIVATE_CONSTRUCTOR_IS_NOT_ACCESSIBLE("javascript.private.constructor.is.not.accessible.message"),
        JS_PRIVATE_MEMBER_IS_NOT_ACCESSIBLE("javascript.jsdoc.private.member.is.not.accessible.message"),
        JS_PROTECTED_MEMBER_IS_NOT_ACCESSIBLE("javascript.jsdoc.protected.member.is.not.accessible.message"),
        JS_NEED_TO_BE_EXPORTED("javascript.element.need.to.be.exported"),
        JS_DEFAULT_INSTEAD_NAMED("javascript.element.default.instead.named"),
        JS_NEED_TO_BE_IMPORTED("javascript.element.need.to.be.imported"),
        TS_NEED_TO_BE_INCLUDED_TO_CONFIG("javascript.element.need.to.be.included.to.config"),
        ES6_EXPORT_ONLY_MEMBER("javascript.export.only.member"),
        STATIC_MEMBER_INACCESSIBLE("javascript.static.member.is.not.accessible.message"),
        INSTANCE_MEMBER_INACCESSIBLE("javascript.instance.member.is.not.accessible.message"),
        ARGUMENT_TYPES_MISMATCH("javascript.argument.types.mismatch"),
        UNRESOLVED_CIRCLE_DEFINITION("javascript.unresolved.circle.definition"),
        UNRESOLVED_SYMBOL("javascript.unresolved.symbol.message");

        private final String myMessageKey;

        private ProblemKind(String messageKey) {
            if (messageKey == null) {
                ProblemKind.$$$reportNull$$$0(0);
            }
            this.myMessageKey = messageKey;
        }

        @NotNull
        public String getMessageKey() {
            String string = this.myMessageKey;
            if (string == null) {
                ProblemKind.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "messageKey";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSResolveResult$ProblemKind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSResolveResult$ProblemKind";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessageKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

