/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.quickFix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.platform.lsp.api.customization.LspCodeActionsCustomizer;
import com.intellij.platform.lsp.api.customization.LspCodeActionsSupport;
import com.intellij.platform.lsp.api.customization.LspIntentionAction;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.platform.lsp.impl.intention.LspIntentionActionServiceKt;
import com.intellij.platform.lsp.impl.quickFix.LspQuickFixWrapper;
import com.intellij.psi.PsiManager;
import com.intellij.util.ApplicationKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeActionTriggerKind;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016J\u0016\u0010\u0017\u001a\u00020\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/platform/lsp/impl/quickFix/LspQuickFixSet;", "", "lspServer", "Lcom/intellij/platform/lsp/impl/LspServerImpl;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "diagnostic", "Lorg/eclipse/lsp4j/Diagnostic;", "LspQuickFixSet", "(Lcom/intellij/platform/lsp/impl/LspServerImpl;Lcom/intellij/openapi/vfs/VirtualFile;Lorg/eclipse/lsp4j/Diagnostic;)V", "MAX_QUICK_FIXES", "", "quickFixes", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "getQuickFixes", "()Ljava/util/List;", "psiModCountWhenRequestSent", "", "vfsModCountWhenRequestSent", "ensureInitialized", "", "ensureInitialized$intellij_platform_lsp_impl", "A", "codeActions", "Lorg/eclipse/lsp4j/CodeAction;", "intellij.platform.lsp.impl"})
@SourceDebugExtension(value={"SMAP\nLspQuickFixSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspQuickFixSet.kt\ncom/intellij/platform/lsp/impl/quickFix/LspQuickFixSet\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n1869#2,2:106\n1563#2:110\n1634#2,3:111\n24#3:108\n1#4:109\n*S KotlinDebug\n*F\n+ 1 LspQuickFixSet.kt\ncom/intellij/platform/lsp/impl/quickFix/LspQuickFixSet\n*L\n53#1:106,2\n69#1:110\n69#1:111,3\n84#1:108\n*E\n"})
public final class LspQuickFixSet {
    @NotNull
    private final LspServerImpl lspServer;
    @NotNull
    private final VirtualFile file;
    @NotNull
    private final Diagnostic diagnostic;
    private final int MAX_QUICK_FIXES;
    @NotNull
    private final List<IntentionAction> quickFixes;
    private long psiModCountWhenRequestSent;
    private long vfsModCountWhenRequestSent;

    public LspQuickFixSet(@NotNull LspServerImpl lspServer, @NotNull VirtualFile file, @NotNull Diagnostic diagnostic) {
        List list;
        Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        this.lspServer = lspServer;
        this.file = file;
        this.diagnostic = diagnostic;
        this.MAX_QUICK_FIXES = 8;
        List list2 = list = CollectionsKt.createListBuilder();
        LspQuickFixSet lspQuickFixSet = this;
        boolean bl = false;
        int n2 = this.MAX_QUICK_FIXES;
        for (int i2 = 0; i2 < n2; ++i2) {
            list2.add(new LspQuickFixWrapper(this, i2));
        }
        lspQuickFixSet.quickFixes = CollectionsKt.build((List)list);
    }

    @NotNull
    public final List<IntentionAction> getQuickFixes() {
        return this.quickFixes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void ensureInitialized$intellij_platform_lsp_impl() {
        if (ApplicationKt.getApplication().isDispatchThread()) {
            return;
        }
        LspQuickFixSet lspQuickFixSet = this;
        synchronized (lspQuickFixSet) {
            CodeActionContext codeActionContext;
            boolean bl = false;
            ProgressManager.checkCanceled();
            long l10 = PsiManager.getInstance((Project)this.lspServer.getProject()).getModificationTracker().getModificationCount();
            long l11 = VirtualFileManager.getInstance().getModificationCount();
            if (this.psiModCountWhenRequestSent == l10 && this.vfsModCountWhenRequestSent == l11) {
                return;
            }
            Iterable iterable = this.quickFixes;
            boolean bl2 = false;
            for (Object t2 : iterable) {
                IntentionAction intentionAction = (IntentionAction)t2;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)intentionAction, (String)"null cannot be cast to non-null type com.intellij.platform.lsp.impl.quickFix.LspQuickFixWrapper");
                ((LspQuickFixWrapper)intentionAction).setLspIntentionAction(null);
            }
            CodeActionContext codeActionContext2 = codeActionContext = new CodeActionContext();
            Range range = this.diagnostic.getRange();
            TextDocumentIdentifier textDocumentIdentifier = this.lspServer.getDocumentIdentifier(this.file);
            boolean bl4 = false;
            codeActionContext2.setOnly(CollectionsKt.listOf((Object)"quickfix"));
            codeActionContext2.setDiagnostics(CollectionsKt.listOf((Object)this.diagnostic));
            codeActionContext2.setTriggerKind(CodeActionTriggerKind.Automatic);
            Unit unit = Unit.INSTANCE;
            CodeActionContext codeActionContext3 = codeActionContext;
            Range range2 = range;
            TextDocumentIdentifier textDocumentIdentifier2 = textDocumentIdentifier;
            iterable = new CodeActionParams(textDocumentIdentifier2, range2, codeActionContext3);
            this.lspServer.getRequestExecutor().sendRequestAsyncButWaitForResponseWithCheckCanceled$intellij_platform_lsp_impl(arg_0 -> LspQuickFixSet.A((CodeActionParams)iterable, arg_0), arg_0 -> LspQuickFixSet.A(l10, this, l11, arg_0));
            Unit unit2 = Unit.INSTANCE;
        }
    }

    private final void A(List<? extends CodeAction> list) {
        LspCodeActionsCustomizer lspCodeActionsCustomizer = this.lspServer.getDescriptor().getLspCustomization().getCodeActionsCustomizer();
        LspCodeActionsSupport lspCodeActionsSupport = lspCodeActionsCustomizer instanceof LspCodeActionsSupport ? (LspCodeActionsSupport)lspCodeActionsCustomizer : null;
        if (lspCodeActionsSupport == null) {
            return;
        }
        LspCodeActionsSupport lspCodeActionsSupport2 = lspCodeActionsSupport;
        int n2 = 0;
        for (CodeAction codeAction : list) {
            LspIntentionAction lspIntentionAction;
            if (n2 == this.quickFixes.size()) {
                LspQuickFixSet lspQuickFixSet = this;
                boolean bl = false;
                Logger logger = Logger.getInstance(LspQuickFixSet.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.info("Received " + list.size() + " quick fixes from server, only " + this.quickFixes.size() + " will be handled");
                break;
            }
            if (lspCodeActionsSupport2.createQuickFix(this.lspServer, codeAction) == null) continue;
            boolean bl = false;
            int n3 = n2;
            n2 = n3 + 1;
            IntentionAction intentionAction = this.quickFixes.get(n3);
            Intrinsics.checkNotNull((Object)intentionAction, (String)"null cannot be cast to non-null type com.intellij.platform.lsp.impl.quickFix.LspQuickFixWrapper");
            ((LspQuickFixWrapper)intentionAction).setLspIntentionAction(lspIntentionAction);
        }
    }

    private static final CompletableFuture A(CodeActionParams codeActionParams, LanguageServer languageServer) {
        Intrinsics.checkNotNullParameter((Object)languageServer, (String)"it");
        CompletableFuture completableFuture = languageServer.getTextDocumentService().codeAction(codeActionParams);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"codeAction(...)");
        return completableFuture;
    }

    private static final Unit A(long l10, LspQuickFixSet lspQuickFixSet, long l11, List list) {
        block2: {
            if (l10 != PsiManager.getInstance((Project)lspQuickFixSet.lspServer.getProject()).getModificationTracker().getModificationCount() || l11 != VirtualFileManager.getInstance().getModificationCount()) break block2;
            lspQuickFixSet.psiModCountWhenRequestSent = l10;
            lspQuickFixSet.vfsModCountWhenRequestSent = l11;
            List list2 = list;
            if (list2 != null) {
                List list3 = list2;
                boolean bl = false;
                Iterable iterable = list3;
                LspQuickFixSet lspQuickFixSet2 = lspQuickFixSet;
                boolean bl2 = false;
                Iterable iterable2 = iterable;
                Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
                boolean bl3 = false;
                for (Object t2 : iterable2) {
                    Either either = (Either)t2;
                    Collection collection2 = collection;
                    boolean bl4 = false;
                    Intrinsics.checkNotNull((Object)either);
                    collection2.add(LspIntentionActionServiceKt.asCodeAction((Either<Command, CodeAction>)either));
                }
                lspQuickFixSet2.A((List)collection);
            }
        }
        return Unit.INSTANCE;
    }
}

