/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.dataSource.validation.FixWithProgress;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceQuickFixAction
extends ActionGroup {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            DataSourceQuickFixAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        PsiElement psiElement = e == null ? null : (PsiElement)e.getData(CommonDataKeys.PSI_ELEMENT);
        DbDataSource dataSource = (DbDataSource)ObjectUtils.tryCast((Object)psiElement, DbDataSource.class);
        if (dataSource == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                DataSourceQuickFixAction.$$$reportNull$$$0(1);
            }
            return AnAction.EMPTY_ARRAY;
        }
        Set<DataSourceProblem> problems = DatabaseConfigValidator.getProblems(dataSource.getProject(), dataSource.getName(), dataSource.getDelegate(), null);
        AnAction[] anActionArray = ContainerUtil.mapNotNull(problems, p2 -> {
            FixWithProgress fix = p2.getFix();
            if (fix == null || !fix.canBeExecutedWithoutUI()) {
                return null;
            }
            return new MyFixAction(fix, dataSource, p2.getLevel());
        }).toArray(AnAction.EMPTY_ARRAY);
        if (anActionArray == null) {
            DataSourceQuickFixAction.$$$reportNull$$$0(2);
        }
        return anActionArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/database/actions/DataSourceQuickFixAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class MyFixAction
    extends AnAction {
        private final FixWithProgress myFix;
        private final DbDataSource myDataSource;

        MyFixAction(FixWithProgress fix, DbDataSource dataSource, @NotNull DataSourceProblem.Level level) {
            if (level == null) {
                MyFixAction.$$$reportNull$$$0(0);
            }
            super(fix::getName, MyFixAction.getIcon(level));
            this.myFix = fix;
            this.myDataSource = dataSource;
        }

        @Nullable
        private static Icon getIcon(@NotNull DataSourceProblem.Level level) {
            if (level == null) {
                MyFixAction.$$$reportNull$$$0(1);
            }
            if (level == DataSourceProblem.Level.ERROR) {
                return AllIcons.General.Error;
            }
            if (level == DataSourceProblem.Level.WARNING) {
                return AllIcons.General.Warning;
            }
            return null;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyFixAction.$$$reportNull$$$0(2);
            }
            new Task.Backgroundable(this.myDataSource.getProject(), this.myFix.getName()){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    myFix.run(indicator, null);
                    ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> DbPsiFacade.getInstance((Project)myDataSource.getProject()).clearCaches());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/actions/DataSourceQuickFixAction$MyFixAction$1", "run"));
                }
            }.queue();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "level";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/DataSourceQuickFixAction$MyFixAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getIcon";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

