/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.access.DatabaseCredentialsUi;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.connectivity.dataSource.BasicDataSourceManager;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceFun;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.DataSourceScopeEditor;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.SyncQueue;
import com.intellij.database.introspection.IntrospectionTask;
import com.intellij.database.introspection.IntrospectionTasks;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.statistic.DatabaseAndSchemaSelectionCollector;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.database.view.ui.DataSourceManagerDialog;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.database.view.ui.DatabaseDriverConfigurable;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDEventImpl;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.InputEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class DataSourceUiUtil {
    private DataSourceUiUtil() {
    }

    public static ActionCallback navigate(@NotNull DatabaseConfigEditor editor2, @NotNull LocalDataSource dataSource, @NotNull Consumer<? super DataSourceConfigurable> modifier) {
        if (editor2 == null) {
            DataSourceUiUtil.$$$reportNull$$$0(0);
        }
        if (dataSource == null) {
            DataSourceUiUtil.$$$reportNull$$$0(1);
        }
        if (modifier == null) {
            DataSourceUiUtil.$$$reportNull$$$0(2);
        }
        return editor2.navigateTo(dataSource, false).doWhenDone(() -> {
            DataSourceConfigurable configurable = editor2.getConfigurable(dataSource, false, DataSourceConfigurable.class);
            if (configurable == null) {
                return;
            }
            modifier.consume((Object)configurable);
        });
    }

    public static ActionCallback modify(@NotNull DatabaseConfigEditor editor2, @NotNull LocalDataSource dataSource, @NotNull Consumer<? super LocalDataSource> modifier) {
        if (editor2 == null) {
            DataSourceUiUtil.$$$reportNull$$$0(3);
        }
        if (dataSource == null) {
            DataSourceUiUtil.$$$reportNull$$$0(4);
        }
        if (modifier == null) {
            DataSourceUiUtil.$$$reportNull$$$0(5);
        }
        return DataSourceUiUtil.navigate(editor2, dataSource, (Consumer<? super DataSourceConfigurable>)((Consumer)configurable -> DataSourceUiUtil.modify(configurable, modifier)));
    }

    public static void modify(DataSourceConfigurable configurable, @NotNull Consumer<? super LocalDataSource> modifier) {
        if (modifier == null) {
            DataSourceUiUtil.$$$reportNull$$$0(6);
        }
        LocalDataSource ds = configurable.getTempDataSource().copy(true);
        modifier.consume((Object)ds);
        configurable.reset(ds, false);
    }

    public static ActionCallback navigate(@NotNull DatabaseConfigEditor editor2, @NotNull DatabaseDriver driver, @NotNull Consumer<? super DatabaseDriverConfigurable> modifier) {
        if (editor2 == null) {
            DataSourceUiUtil.$$$reportNull$$$0(7);
        }
        if (driver == null) {
            DataSourceUiUtil.$$$reportNull$$$0(8);
        }
        if (modifier == null) {
            DataSourceUiUtil.$$$reportNull$$$0(9);
        }
        return editor2.navigateTo(driver, false).doWhenDone(() -> {
            DatabaseDriverConfigurable configurable = editor2.getConfigurable(driver, false, DatabaseDriverConfigurable.class);
            if (configurable == null) {
                return;
            }
            modifier.consume((Object)configurable);
        });
    }

    public static void modify(@NotNull Consumer<? super DatabaseDriverImpl> modifier, DatabaseDriverConfigurable configurable) {
        if (modifier == null) {
            DataSourceUiUtil.$$$reportNull$$$0(10);
        }
        DatabaseDriverImpl dr = configurable.getTempDriver().copy(null, true);
        modifier.consume((Object)dr);
        configurable.reset(dr);
    }

    @NotNull
    public static LoaderContext preparePathBasedLoaderContext(@NotNull Project project, @NotNull DatabaseConnectionPoint connectionPoint, @Nullable ObjectPath path) {
        if (project == null) {
            DataSourceUiUtil.$$$reportNull$$$0(11);
        }
        if (connectionPoint == null) {
            DataSourceUiUtil.$$$reportNull$$$0(12);
        }
        IntrospectionTask task = DataSourceFun.preparePathBasedIntrospectionTask((DatabaseConnectionPoint)connectionPoint, (ObjectPath)path);
        LocalDataSource dataSource = connectionPoint.getDataSource();
        LoaderContext loaderContext = LoaderContext.selectTask((Project)project, (LocalDataSource)dataSource, (IntrospectionTask)task);
        if (loaderContext == null) {
            DataSourceUiUtil.$$$reportNull$$$0(13);
        }
        return loaderContext;
    }

    public static void runAsyncWithCorrectModality(@NotNull Task.Backgroundable task) {
        if (task == null) {
            DataSourceUiUtil.$$$reportNull$$$0(14);
        }
        ((CoreProgressManager)ProgressManager.getInstance()).runProcessWithProgressAsynchronously(task, (ProgressIndicator)new BackgroundableProcessIndicator(task), null, ModalityState.current());
    }

    public static void runSynchronously(@NotNull Task task) {
        ProgressIndicator indicator;
        if (task == null) {
            DataSourceUiUtil.$$$reportNull$$$0(15);
        }
        if ((indicator = ProgressManager.getInstance().getProgressIndicator()) == null) {
            indicator = new EmptyProgressIndicator();
        }
        try {
            task.run(indicator);
        }
        catch (ProcessCanceledException processCanceledException) {
        }
        finally {
            if (indicator.isCanceled()) {
                task.onCancel();
            } else {
                task.onSuccess();
            }
        }
    }

    @NotNull
    public static JBPopup buildHiddenNamespacesPopup(@NotNull Project project, final @NotNull LocalDataSource dataSource, @Nullable BasicElement selection) {
        if (project == null) {
            DataSourceUiUtil.$$$reportNull$$$0(16);
        }
        if (dataSource == null) {
            DataSourceUiUtil.$$$reportNull$$$0(17);
        }
        final DataSourceScopeEditor editor2 = new DataSourceScopeEditor(project){

            @Override
            protected LocalDataSource getDataSource(boolean withCredentials) {
                return dataSource;
            }

            @Override
            @NotNull
            protected Dbms getDbms() {
                Dbms dbms = dataSource.getDbms();
                if (dbms == null) {
                    1.$$$reportNull$$$0(0);
                }
                return dbms;
            }

            @Override
            @NotNull
            public DataSourceSchemaMapping getSchemaMapping() {
                TreePattern scope2 = this.getEditorState();
                this.mySchemaMapping.setIntrospectionScope(scope2);
                DataSourceSchemaMapping dataSourceSchemaMapping = this.mySchemaMapping;
                if (dataSourceSchemaMapping == null) {
                    1.$$$reportNull$$$0(1);
                }
                return dataSourceSchemaMapping;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/database/dataSource/DataSourceUiUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDbms";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSchemaMapping";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        editor2.setInitialModel(dataSource, (BasicModel)ObjectUtils.tryCast((Object)dataSource.getModel(), BasicModel.class));
        TreePattern pattern = dataSource.getIntrospectionScope();
        editor2.setScopes(pattern, pattern);
        editor2.setFakeCurrentSchema((Couple<String>)dataSource.getFakeCurrentSchema());
        editor2.setSchemaMapping(dataSource.getSchemaMapping());
        editor2.select(selection);
        Ref notApply = Ref.create();
        final Ref popupRef = Ref.create();
        JBPopup popup2 = JBPopupFactory.getInstance().createComponentPopupBuilder(editor2.getComponent(), (JComponent)((Object)editor2.getTree())).setMovable(true).setResizable(true).setRequestFocus(true).setMinSize((Dimension)JBUI.size((int)250)).setDimensionServiceKey(project, "HiddenNamespacesPopup", false).setAdText(DatabaseBundle.message((String)"manage.data.sources.ad", (Object[])new Object[0])).setKeyEventHandler(event -> {
            if (editor2.getTree().isEditing()) {
                return false;
            }
            if (event.getID() == 401) {
                if (event.getKeyCode() == 10) {
                    ((JBPopup)popupRef.get()).closeOk((InputEvent)event);
                    return true;
                }
                if (event.getKeyCode() == 27 && !editor2.hasSpeedSearchActive()) {
                    notApply.set((Object)Boolean.TRUE);
                    ((JBPopup)popupRef.get()).cancel();
                    return true;
                }
            }
            return false;
        }).addListener(new JBPopupListener(){

            public void beforeShown(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                ((AbstractPopup)popupRef.get()).setShowHints(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/dataSource/DataSourceUiUtil$2", "beforeShown"));
            }
        }).createPopup();
        popupRef.set((Object)popup2);
        popup2.setFinalRunnable(() -> {
            if (notApply.get() == Boolean.TRUE) {
                return;
            }
            Couple<String> fcs = editor2.getFakeCurrentSchema();
            DataSourceSchemaMapping mapping = editor2.getSchemaMapping();
            if (Comparing.equal(fcs, (Object)dataSource.getFakeCurrentSchema()) && Comparing.equal((Object)mapping, (Object)dataSource.getSchemaMapping())) {
                return;
            }
            @NotNull TreePattern oldScope = dataSource.getIntrospectionScope();
            dataSource.setFakeCurrentSchema(fcs);
            dataSource.setSchemaMapping(mapping);
            DataSourceStorage.getProjectStorage((Project)project).updateDataSource(dataSource);
            DataSourceUtil.applyMappings(project, dataSource);
            @NotNull TreePattern newScope = dataSource.getIntrospectionScope();
            DatabaseAndSchemaSelectionCollector.record(dataSource, oldScope, newScope);
            LoaderContext loaderContext = DataSourceUiUtil.prepareScopeIntrospectionLoaderContext(project, dataSource, oldScope, newScope);
            if (loaderContext != null) {
                DataSourceUtil.performAutoSyncTask(loaderContext);
            }
        });
        UiNotifyConnector.Once.installOn((Component)editor2.getComponent(), (Activatable)new Activatable(){

            public void showNotify() {
                editor2.introspectIfEmpty();
            }
        });
        JBPopup jBPopup = popup2;
        if (jBPopup == null) {
            DataSourceUiUtil.$$$reportNull$$$0(18);
        }
        return jBPopup;
    }

    @Nullable
    public static LoaderContext prepareScopeIntrospectionLoaderContext(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull TreePattern oldScope, @NotNull TreePattern newScope) {
        TreePattern diff;
        if (project == null) {
            DataSourceUiUtil.$$$reportNull$$$0(19);
        }
        if (dataSource == null) {
            DataSourceUiUtil.$$$reportNull$$$0(20);
        }
        if (oldScope == null) {
            DataSourceUiUtil.$$$reportNull$$$0(21);
        }
        if (newScope == null) {
            DataSourceUiUtil.$$$reportNull$$$0(22);
        }
        if ((diff = TreePatternUtils.minus((TreePattern[])new TreePattern[]{newScope, oldScope})).isEmpty()) {
            return null;
        }
        IntrospectionTask task = IntrospectionTasks.prepareScopeTask((String)dataSource.getUniqueId(), (TreePattern)diff);
        return task != null ? LoaderContext.selectTask((Project)project, (LocalDataSource)dataSource, (IntrospectionTask)task) : null;
    }

    public static boolean createDataSourceFromFiles(@NotNull Project project, @NotNull List<VirtualFile> files2) {
        if (project == null) {
            DataSourceUiUtil.$$$reportNull$$$0(23);
        }
        if (files2 == null) {
            DataSourceUiUtil.$$$reportNull$$$0(24);
        }
        ArrayList<VirtualFile> extraFiles = new ArrayList<VirtualFile>(files2);
        LinkedHashSet<DbDataSource> dataSources = new LinkedHashSet<DbDataSource>();
        Iterator it = extraFiles.iterator();
        while (it.hasNext()) {
            VirtualFile file = (VirtualFile)it.next();
            DbDataSource dataSource = DbImplUtil.findDataSourceByFile(project, file);
            if (dataSource == null) continue;
            dataSources.add(dataSource);
            it.remove();
        }
        int existingSize = dataSources.size();
        DbPsiFacade facade = DbPsiFacade.getInstance((Project)project);
        if (!extraFiles.isEmpty()) {
            DatabaseCredentials credentials = DatabaseCredentialsUi.newUIInstance();
            ArrayList fromManagers = new ArrayList();
            for (DataSourceManager manager : DataSourceManager.getManagers((Project)project)) {
                if (!(manager instanceof BasicDataSourceManager)) continue;
                fromManagers.addAll(((BasicDataSourceManager)manager).createDataSourceByFiles(credentials, files2));
            }
            List newDs = ContainerUtil.filter(fromManagers, ds -> facade.findDataSource(ds.getUniqueId()) == null);
            if (!newDs.isEmpty()) {
                List<DbDataSource> created = DataSourceManagerDialog.showDialog(facade, (Object)newDs, credentials);
                dataSources.addAll(created);
            }
            for (DasDataSource ds2 : newDs) {
                ContainerUtil.addIfNotNull(dataSources, (Object)facade.findDataSource(ds2.getUniqueId()));
            }
        }
        if (!dataSources.isEmpty()) {
            Promise<?> prepare2 = existingSize != dataSources.size() ? DataSourceUtil.promiseFacadeUpdate(facade, null) : Promises.resolvedPromise();
            prepare2.thenAsync(o -> DatabaseView.select(project, dataSources, true)).onProcessed(o -> ApplicationManager.getApplication().invokeLater(() -> DbNavigationUtils.navigateToDataSourceFile((DbElement)ContainerUtil.getFirstItem((Collection)dataSources), true)));
            return true;
        }
        return false;
    }

    public static DatabaseDriver createDefaultDatabaseDriver(@NotNull Collection<? extends DatabaseDriver> existing2) {
        if (existing2 == null) {
            DataSourceUiUtil.$$$reportNull$$$0(25);
        }
        Set names = (Set)JBIterable.from(existing2).map(DatabaseDriver::getName).addAllTo((Collection)CollectionFactory.createCaseInsensitiveStringSet());
        return DatabaseDriverManager.getInstance().createDriver(DbUtil.generateUniqueName((String)"User Driver", (Set)names), "java.sql.Driver", null);
    }

    public static void applyFix(@NotNull Project project, @NotNull ErrorInfo.Fix fix, @Nullable DatabaseConfigEditor editor2) {
        if (project == null) {
            DataSourceUiUtil.$$$reportNull$$$0(26);
        }
        if (fix == null) {
            DataSourceUiUtil.$$$reportNull$$$0(27);
        }
        DataContext context = SimpleDataContext.builder().add(CommonDataKeys.PROJECT, (Object)project).add(DatabaseConfigEditor.CONFIG_EDITOR, (Object)editor2).build();
        DataSourceUiUtil.applyFix(fix, context);
    }

    public static void applyFix(@NotNull ErrorInfo.Fix fix, @NotNull DataContext context) {
        Project project;
        if (fix == null) {
            DataSourceUiUtil.$$$reportNull$$$0(28);
        }
        if (context == null) {
            DataSourceUiUtil.$$$reportNull$$$0(29);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(context)) == null) {
            return;
        }
        DatabaseConfigEditor editor2 = (DatabaseConfigEditor)DatabaseConfigEditor.CONFIG_EDITOR.getData(context);
        if (!fix.isSilent() && editor2 == null) {
            DbPsiFacade facade = DbPsiFacade.getInstance((Project)project);
            DataContext newContext = SimpleDataContext.builder().setParent(context).add(DatabaseConfigEditor.CONFIG_EDITOR, (Object)editor2).build();
            DataSourceManagerDialog.showDialog(facade, null, null, (Consumer<? super DatabaseConfigEditor>)((Consumer)e -> fix.apply(newContext)));
        } else {
            fix.apply(context);
        }
    }

    public static void showTroubleshooting() {
        HelpManager.getInstance().invokeHelp("Connectivity_problems");
    }

    @Deprecated(forRemoval=true)
    public static void performAutoSyncTask(@NotNull Project project, @NotNull LocalDataSource dataSource) {
        if (project == null) {
            DataSourceUiUtil.$$$reportNull$$$0(30);
        }
        if (dataSource == null) {
            DataSourceUiUtil.$$$reportNull$$$0(31);
        }
        DataSourceUtil.performAutoSyncTask(LoaderContext.selectGeneralTask((Project)project, (LocalDataSource)dataSource), false);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static AsyncTask<SyncQueue.SyncResult> performManualSyncTask(@NotNull LoaderContext context) {
        if (context == null) {
            DataSourceUiUtil.$$$reportNull$$$0(32);
        }
        AsyncTask<SyncQueue.SyncResult> asyncTask = DataSourceUtil.performManualSyncTask(context);
        if (asyncTask == null) {
            DataSourceUiUtil.$$$reportNull$$$0(33);
        }
        return asyncTask;
    }

    public static <K, V> V putOrRemove(Map<K, V> m, K k, V v) {
        return (V)DbImplUtilCore.putOrRemove(m, k, v);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 18, 33 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 4: 
            case 17: 
            case 20: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 11: 
            case 16: 
            case 19: 
            case 23: 
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionPoint";
                break;
            }
            case 13: 
            case 18: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DataSourceUiUtil";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldScope";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newScope";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existing";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fix";
                break;
            }
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceUiUtil";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "preparePathBasedLoaderContext";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "buildHiddenNamespacesPopup";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "performManualSyncTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "navigate";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "modify";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "preparePathBasedLoaderContext";
                break;
            }
            case 13: 
            case 18: 
            case 33: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "runAsyncWithCorrectModality";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "runSynchronously";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "buildHiddenNamespacesPopup";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "prepareScopeIntrospectionLoaderContext";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createDataSourceFromFiles";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultDatabaseDriver";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "performAutoSyncTask";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "performManualSyncTask";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13, 18, 33 -> new IllegalStateException(string);
        };
    }

    public static class DbGroupDropTarget
    implements DnDTarget {
        private final String myGroupName;
        private final Project myProject;

        public DbGroupDropTarget(@NotNull String groupName, @NotNull Project project) {
            if (groupName == null) {
                DbGroupDropTarget.$$$reportNull$$$0(0);
            }
            if (project == null) {
                DbGroupDropTarget.$$$reportNull$$$0(1);
            }
            this.myGroupName = groupName;
            this.myProject = project;
        }

        public void drop(DnDEvent event) {
            List dsns = DbGroupDropTarget.getDataSources(event).toList();
            for (DataSourceNode dsn : dsns) {
                this.setDataSourceGroupName(dsn, this.myGroupName);
            }
            DatabaseView.refreshViewAndSelect(this.myProject, dsns);
        }

        private void setDataSourceGroupName(@NotNull DataSourceNode dsn, @NotNull String groupName) {
            DataSourceManager dataSourceManager;
            if (dsn == null) {
                DbGroupDropTarget.$$$reportNull$$$0(2);
            }
            if (groupName == null) {
                DbGroupDropTarget.$$$reportNull$$$0(3);
            }
            if ((dataSourceManager = DataSourceManager.byDataSource((Project)this.myProject, (RawDataSource)dsn.dataSource)) == null) {
                return;
            }
            dataSourceManager.setGroupName(dsn.dataSource, groupName);
        }

        public boolean update(DnDEvent event) {
            return DbGroupDropTarget.getDataSources(event).isNotEmpty();
        }

        @NotNull
        private static JBIterable<DataSourceNode> getDataSources(DnDEvent event) {
            block4: {
                JBIterable jBIterable;
                try {
                    Object data = event.getTransferData(DnDEventImpl.ourDataFlavor);
                    if (!(data instanceof Object[])) break block4;
                    Object[] objects = (Object[])data;
                    jBIterable = JBIterable.of((Object[])objects).filter(DataSourceNode.class);
                }
                catch (UnsupportedFlavorException | IOException exception) {
                    // empty catch block
                }
                if (jBIterable == null) {
                    DbGroupDropTarget.$$$reportNull$$$0(4);
                }
                return jBIterable;
            }
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DbGroupDropTarget.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "groupName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dsn";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DataSourceUiUtil$DbGroupDropTarget";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DataSourceUiUtil$DbGroupDropTarget";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataSources";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setDataSourceGroupName";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

