/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mlapi.bundle.component;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\bH\u0014R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/mlapi/bundle/component/InMemoryClassLoader;", "Ljava/lang/ClassLoader;", "jarBytes", "", "parent", "([BLjava/lang/ClassLoader;)V", "classes", "", "", "findClass", "Ljava/lang/Class;", "name", "mlapi-core"})
final class InMemoryClassLoader
extends ClassLoader {
    @NotNull
    private final Map<String, byte[]> classes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InMemoryClassLoader(@NotNull byte[] jarBytes, @NotNull ClassLoader parent) {
        Intrinsics.checkNotNullParameter((Object)jarBytes, (String)"jarBytes");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(parent);
        this.classes = new LinkedHashMap();
        Closeable closeable = new JarInputStream(new ByteArrayInputStream(jarBytes));
        Throwable throwable = null;
        try {
            JarInputStream jarStream = (JarInputStream)closeable;
            boolean bl = false;
            JarEntry entry = jarStream.getNextJarEntry();
            while (entry != null) {
                String string = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (StringsKt.endsWith$default((String)string, (String)".class", (boolean)false, (int)2, null)) {
                    String string2 = entry.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                    String className = StringsKt.replace$default((String)StringsKt.removeSuffix((String)string2, (CharSequence)".class"), (char)'/', (char)'.', (boolean)false, (int)4, null);
                    byte[] classBytes = ByteStreamsKt.readBytes((InputStream)jarStream);
                    this.classes.put(className, classBytes);
                }
                entry = jarStream.getNextJarEntry();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Override
    @NotNull
    protected Class<?> findClass(@NotNull String name) throws ClassNotFoundException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        byte[] byArray = this.classes.get(name);
        if (byArray == null) {
            throw new ClassNotFoundException(StringsKt.trimIndent((String)("\n        Feature preprocessor not found: " + name + "\n        Available classes: " + this.classes.keySet() + "\n      ")));
        }
        byte[] classBytes = byArray;
        Class<?> clazz = this.defineClass(name, classBytes, 0, classBytes.length);
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"defineClass(...)");
        return clazz;
    }
}

