﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/config/model/DeleteConformancePackRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::ConfigService::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String DeleteConformancePackRequest::SerializePayload() const {
  JsonValue payload;

  if (m_conformancePackNameHasBeenSet) {
    payload.WithString("ConformancePackName", m_conformancePackName);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection DeleteConformancePackRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "StarlingDoveService.DeleteConformancePack"));
  return headers;
}
