import { Token } from '@lumino/coreutils';
import { IDisposable } from '@lumino/disposable';
/**
 * The main menu token.
 */
export declare const ISplashScreen: Token<ISplashScreen>;
/**
 * The interface for an application splash screen.
 */
export interface ISplashScreen {
    /**
     * Show the application splash screen.
     *
     * @param light - Whether to show the light splash screen or the dark one.
     *
     * @returns A disposable used to clear the splash screen.
     */
    show(light?: boolean): IDisposable;
}
