/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.spelling;

import com.swabunga.spell.engine.Configuration;
import com.swabunga.spell.engine.SpellDictionary;
import com.swabunga.spell.engine.SpellDictionaryHashMap;
import com.swabunga.spell.event.SpellChecker;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.Bundle;
import org.xmind.ui.internal.spelling.ISpellCheckerDescriptor;
import org.xmind.ui.internal.spelling.ISpellCheckerVisitor;
import org.xmind.ui.internal.spelling.Messages;
import org.xmind.ui.internal.spelling.SpellCheckerRegistry;
import org.xmind.ui.internal.spelling.SpellingPlugin;

public class SpellCheckerAgent {
    private static final SpellCheckerAgent instance = new SpellCheckerAgent();
    private SpellChecker spellChecker;
    private Configuration configuration;
    private List<ISpellCheckerVisitor> listeners = new ArrayList<ISpellCheckerVisitor>();

    public static void resetSpellChecker() {
        SpellCheckerAgent.getInstance().spellChecker = null;
    }

    public static void visitSpellChecker(ISpellCheckerVisitor visitor) {
        SpellCheckerAgent.getInstance().doVisitSpellChecker(visitor);
    }

    public static void setConfigurations(IPreferenceStore prefStore) {
        SpellCheckerAgent.getInstance().doSetConfigurations(prefStore);
    }

    public static void migrateUserDictFile() {
        SpellCheckerAgent.getInstance().doMigrateUserDictFile();
    }

    public static void addListener(ISpellCheckerVisitor listener) {
        SpellCheckerAgent.getInstance().listeners.add(listener);
    }

    public static void removeListener(ISpellCheckerVisitor listener) {
        SpellCheckerAgent.getInstance().listeners.remove(listener);
    }

    private synchronized void doVisitSpellChecker(final ISpellCheckerVisitor visitor) {
        if (this.spellChecker != null) {
            visitor.handleWith(this.spellChecker);
            return;
        }
        new Job(Messages.loadingSpellChecker){

            protected IStatus run(IProgressMonitor monitor) {
                return SpellCheckerAgent.this.loadSpellChecker(monitor, visitor);
            }
        }.schedule();
    }

    public static void updateSpellChecker() {
        SpellCheckerAgent.getInstance().doUpdateSpellChecker();
    }

    private synchronized void doUpdateSpellChecker() {
        new Job(Messages.loadingSpellChecker){

            protected IStatus run(IProgressMonitor monitor) {
                return SpellCheckerAgent.this.loadSpellChecker(monitor, null);
            }
        }.schedule();
    }

    private IStatus loadSpellChecker(IProgressMonitor monitor, ISpellCheckerVisitor visitor) {
        monitor.beginTask(null, 4);
        monitor.subTask(Messages.creatingSpellCheckerInstance);
        SpellChecker spellChecker = new SpellChecker();
        monitor.worked(1);
        monitor.subTask(Messages.addingSystemDictionary);
        this.addSystemDictionaries(spellChecker);
        monitor.worked(1);
        monitor.subTask(Messages.addingUserDictionary);
        this.addUserDictionaries(spellChecker);
        monitor.worked(1);
        monitor.subTask(Messages.initializingSpellingSettings);
        this.setConfigurations(spellChecker);
        monitor.worked(1);
        this.spellChecker = spellChecker;
        monitor.subTask(Messages.notifyingSpellingVisitors);
        this.notifyVisitor(visitor);
        this.notifyListeners();
        monitor.done();
        return new Status(0, "org.xmind.ui.spelling", "Finish loading spell checker");
    }

    private void notifyVisitor(ISpellCheckerVisitor visitor) {
        if (visitor != null) {
            visitor.handleWith(this.spellChecker);
        }
    }

    private void notifyListeners() {
        if (this.listeners != null) {
            for (ISpellCheckerVisitor listener : this.listeners) {
                if (listener == null) continue;
                listener.handleWith(this.spellChecker);
            }
        }
    }

    private void setConfigurations(SpellChecker spellChecker) {
        this.configuration = spellChecker.getConfiguration();
        this.doSetConfigurations(SpellingPlugin.getDefault().getPreferenceStore());
    }

    private void addUserDictionaries(SpellChecker spellChecker) {
        for (ISpellCheckerDescriptor descriptor : SpellCheckerRegistry.getInstance().getDescriptors()) {
            try {
                if (!descriptor.isEnabled()) continue;
                spellChecker.addDictionary((SpellDictionary)new SpellDictionaryHashMap((Reader)new InputStreamReader(descriptor.openStream(), "utf-16le")));
            }
            catch (IOException e) {
                SpellingPlugin.log(e);
            }
        }
        File userDictFile = SpellCheckerAgent.getUserDictFile();
        if (!userDictFile.exists()) {
            if (userDictFile.getParentFile() != null) {
                userDictFile.getParentFile().mkdirs();
            }
            try {
                new FileOutputStream(userDictFile).close();
            }
            catch (IOException iOException) {}
        }
        try {
            spellChecker.setUserDictionary((SpellDictionary)new SpellDictionaryHashMap(userDictFile));
        }
        catch (IOException e) {
            SpellingPlugin.log(e);
        }
    }

    private void addSystemDictionaries(SpellChecker spellChecker) {
        if (!SpellingPlugin.getDefault().getPreferenceStore().getBoolean("DEFAULT_SPELLING_CHECKER_INVISIBLE") && !SpellingPlugin.getDefault().getPreferenceStore().getBoolean("DEFAULT_SPELLING_CHECKER_DISABLED")) {
            this.loadDictionariesFromBundle(spellChecker, "net.sourceforge.jazzy", "dict/");
        }
        this.loadDictionariesFromBundle(spellChecker, "org.xmind.ui.spelling", "dict/");
    }

    private void loadDictionariesFromBundle(SpellChecker spellChecker, String pluginId, String dirPath) {
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle != null) {
            Enumeration dicts = bundle.getEntryPaths(dirPath);
            while (dicts.hasMoreElements()) {
                String path = (String)dicts.nextElement();
                if (path.endsWith(".dic") || path.endsWith(".dict")) {
                    URL uri = bundle.getEntry(path);
                    if (uri == null) continue;
                    try {
                        this.loadDictionaryFromURL(spellChecker, uri);
                    }
                    catch (IOException e) {
                        SpellingPlugin.log(e, "Failed to load dictionary from platform://" + bundle.getSymbolicName() + "/" + path);
                    }
                    continue;
                }
                if (!path.endsWith("/")) continue;
                this.loadDictionariesFromBundle(spellChecker, pluginId, path);
            }
        }
    }

    private void loadDictionaryFromURL(SpellChecker spellChecker, URL uri) throws IOException {
        InputStream dictStream = uri.openStream();
        try {
            InputStreamReader dictReader = new InputStreamReader(dictStream, "utf-8");
            try {
                SpellDictionaryHashMap dict = new SpellDictionaryHashMap((Reader)dictReader);
                spellChecker.addDictionary((SpellDictionary)dict);
            }
            finally {
                dictReader.close();
            }
        }
        finally {
            dictStream.close();
        }
    }

    private void doSetConfigurations(IPreferenceStore ps) {
        if (this.configuration == null) {
            return;
        }
        this.configuration.setBoolean("SPELL_IGNOREDIGITWORDS", ps.getBoolean("SPELL_IGNOREDIGITWORDS"));
        this.configuration.setBoolean("SPELL_IGNOREINTERNETADDRESS", ps.getBoolean("SPELL_IGNOREINTERNETADDRESS"));
        this.configuration.setBoolean("SPELL_IGNOREMIXEDCASE", ps.getBoolean("SPELL_IGNOREMIXEDCASE"));
        this.configuration.setBoolean("SPELL_IGNORESENTENCECAPTILIZATION", ps.getBoolean("SPELL_IGNORESENTENCECAPTILIZATION"));
        this.configuration.setBoolean("SPELL_IGNOREUPPERCASE", ps.getBoolean("SPELL_IGNOREUPPERCASE"));
    }

    private void doMigrateUserDictFile() {
        File newFile = SpellCheckerAgent.getUserDictFile();
        if (newFile.exists()) {
            return;
        }
        Location instanceLocation = Platform.getInstanceLocation();
        if (instanceLocation == null) {
            return;
        }
        URL instanceURL = instanceLocation.getURL();
        if (instanceURL == null) {
            return;
        }
        try {
            instanceURL = FileLocator.toFileURL((URL)instanceURL);
        }
        catch (IOException iOException) {}
        File instanceDir = new File(instanceURL.getFile());
        if (!instanceDir.exists()) {
            return;
        }
        File oldFile = new File(new File(instanceDir, ".xmind"), "spelling/user.dict");
        if (oldFile.exists()) {
            SpellCheckerAgent.moveUserDictFile(oldFile, newFile);
            return;
        }
        oldFile = new File(instanceDir, "spelling/user.dict");
        if (oldFile.exists()) {
            SpellCheckerAgent.moveUserDictFile(oldFile, newFile);
            return;
        }
    }

    private static void moveUserDictFile(File oldFile, File newFile) {
        boolean moved;
        if (newFile.getParentFile() != null) {
            newFile.getParentFile().mkdirs();
        }
        if (!(moved = oldFile.renameTo(newFile))) {
            SpellingPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.xmind.ui.spelling", "Failed to migrate old user dict file: " + oldFile.getAbsolutePath()));
        }
    }

    private static File getUserDictFile() {
        return new File(SpellingPlugin.getBundleDataPath("user.dict"));
    }

    private static SpellCheckerAgent getInstance() {
        return instance;
    }
}

