/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.search.web;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.xmind.ui.internal.search.SearchPlugin;
import org.xmind.ui.internal.search.web.SearchEnginePref;
import org.xmind.ui.internal.search.web.SearchEngineRegistry;
import org.xmind.ui.internal.search.workbooks.SearchMessages;
import org.xmind.ui.search.ISearchEngineDescriptor;

public class SearchEnginesPrefPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final int TABLE_STYLE = 67588;
    public static final String ID = "cn.brainy.standard.prefs.searchEngines";
    private TableViewer searchTable;
    private LocalResourceManager localResourceManager;

    public boolean performOk() {
        String engine = ((ISearchEngineDescriptor)((IStructuredSelection)this.searchTable.getSelection()).getFirstElement()).getId();
        if (engine != null || "".equals(engine)) {
            this.getPreferenceStore().setValue("defaultEngine", engine);
            SearchEngineRegistry.getInstance().refreshDefaultEngine();
        }
        return super.performOk();
    }

    public void performDefaults() {
        this.getPreferenceStore().setToDefault("defaultEngine");
        SearchEngineRegistry.getInstance().refreshDefaultEngine();
        this.updateTableViewer();
        super.performDefaults();
    }

    private void updateTableViewer() {
        this.searchTable.setInput(this.getRegistry().getVisibleEngines());
        String defaultEngineId = SearchEnginePref.getDefaultEngineId();
        this.searchTable.setSelection((ISelection)new StructuredSelection((Object)this.getRegistry().getEngine(defaultEngineId)));
    }

    private SearchEngineRegistry getRegistry() {
        return SearchEngineRegistry.getInstance();
    }

    protected Control createContents(Composite parent) {
        Composite body = new Composite(parent, 0);
        this.localResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)body);
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(5, 5).applyTo(body);
        Composite searchGroup = new Composite(body, 0);
        searchGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(5, 5).applyTo(searchGroup);
        Label label = new Label(searchGroup, 0);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        label.setText(SearchMessages.SearchEnginesPrefPage_ChooseSearchEngine_label);
        this.searchTable = new TableViewer(searchGroup, 67588);
        this.searchTable.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.searchTable.setLabelProvider((IBaseLabelProvider)new SearchEnginesProvider());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.searchTable.getTable());
        this.updateTableViewer();
        return body;
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(SearchPlugin.getDefault().getPreferenceStore());
    }

    public class SearchEnginesProvider
    extends LabelProvider {
        public Image getImage(Object element) {
            if (element instanceof ISearchEngineDescriptor) {
                ISearchEngineDescriptor ele = (ISearchEngineDescriptor)element;
                return SearchEnginesPrefPage.this.localResourceManager.createImage(ele.getIcon());
            }
            return null;
        }

        public String getText(Object element) {
            ISearchEngineDescriptor ele = (ISearchEngineDescriptor)element;
            return ele.getShortName();
        }
    }
}

