/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.xmind.core.IMeta;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.ui.internal.MindMapMessages;

public class SaveActionUpdater
implements IPartListener,
IPropertyListener,
ICoreEventListener {
    private IWorkbenchWindow window;
    private ActionFactory.IWorkbenchAction action;
    private IEditorPart editor = null;
    private IWorkbook workbook = null;
    private ICoreEventRegistration eventReg = null;

    public SaveActionUpdater(IWorkbenchWindow window, ActionFactory.IWorkbenchAction action) {
        this.window = window;
        this.action = action;
        window.getPartService().addPartListener((IPartListener)this);
    }

    public void dispose() {
        this.handleEditorChange(null);
        if (this.window != null) {
            this.window.getPartService().removePartListener((IPartListener)this);
            this.window = null;
        }
    }

    private void handleEditorChange(IEditorPart newEditor) {
        IEditorPart oldEditor = this.editor;
        this.editor = newEditor;
        if (oldEditor != null) {
            oldEditor.removePropertyListener((IPropertyListener)this);
        }
        if (newEditor != null) {
            newEditor.addPropertyListener((IPropertyListener)this);
        }
        this.handleWorkbookChange(newEditor == null ? null : (IWorkbook)newEditor.getAdapter(IWorkbook.class));
    }

    private void handleWorkbookChange(IWorkbook newWorkbook) {
        IMeta meta;
        this.workbook = newWorkbook;
        if (this.eventReg != null) {
            this.eventReg.unregister();
            this.eventReg = null;
        }
        if (newWorkbook != null && (meta = newWorkbook.getMeta()) instanceof ICoreEventSource) {
            this.eventReg = ((ICoreEventSource)meta).registerCoreEventListener("metadata", (ICoreEventListener)this);
        }
        this.updateText();
    }

    private void updateText() {
        if (this.workbook != null && SaveActionUpdater.isAutoSave(this.workbook)) {
            this.action.setText(MindMapMessages.SaveNewRevision_text);
        } else {
            this.action.setText(WorkbenchMessages.SaveAction_text);
        }
    }

    private static final boolean isAutoSave(IWorkbook workbook) {
        String value = workbook.getMeta().getValue("Configurations/AutoRevisionGeneration");
        return value == null || "Yes".equalsIgnoreCase(value);
    }

    public void partActivated(IWorkbenchPart part) {
        if (!(part instanceof IEditorPart)) {
            return;
        }
        this.handleEditorChange((IEditorPart)part);
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void propertyChanged(Object source, int propId) {
        if (propId == 258) {
            this.handleWorkbookChange(this.editor == null ? null : (IWorkbook)this.editor.getAdapter(IWorkbook.class));
        }
    }

    public void handleCoreEvent(final CoreEvent event) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if ("Configurations/AutoRevisionGeneration".equals(event.getTarget())) {
                    SaveActionUpdater.this.updateText();
                }
            }
        });
    }
}

