/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editpolicies;

import org.eclipse.draw2d.geometry.Point;
import org.xmind.core.ILegend;
import org.xmind.core.IPositioned;
import org.xmind.core.ISheet;
import org.xmind.gef.Request;
import org.xmind.gef.command.Command;
import org.xmind.gef.part.IPart;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.commands.ModifyPositionCommand;
import org.xmind.ui.internal.editpolicies.MindMapPolicyBase;
import org.xmind.ui.util.MindMapUtils;

public class LegendMovablePolicy
extends MindMapPolicyBase {
    public boolean understands(String requestType) {
        return super.understands(requestType) || "move to".equals(requestType);
    }

    public void handle(Request request) {
        String type = request.getType();
        if ("move to".equals(type)) {
            this.moveLegend(request);
        }
    }

    private void moveLegend(Request request) {
        ILegend legend = this.getLegend(request);
        if (legend == null) {
            return;
        }
        if (!request.hasParameter("position")) {
            return;
        }
        Object param = request.getParameter("position");
        if (param != null && !(param instanceof Point)) {
            return;
        }
        Point position = (Point)param;
        ModifyPositionCommand cmd = new ModifyPositionCommand((IPositioned)legend, MindMapUtils.toModelPosition(position));
        cmd.setLabel(CommandMessages.Command_MoveLegend);
        this.saveAndRun((Command)cmd, request.getTargetDomain());
    }

    private ILegend getLegend(Request request) {
        IPart target = request.getPrimaryTarget();
        if (target != null) {
            Object m = MindMapUtils.getRealModel(target);
            if (m instanceof ILegend) {
                return (ILegend)m;
            }
            if (m instanceof ISheet) {
                return ((ISheet)m).getLegend();
            }
        }
        return null;
    }
}

