/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.xmind.core.IBoundary;
import org.xmind.core.ISheet;
import org.xmind.core.ISummary;
import org.xmind.core.ITopic;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.util.Point;
import org.xmind.gef.draw2d.IAnchor;
import org.xmind.gef.draw2d.IDecoratedFigure;
import org.xmind.gef.draw2d.decoration.IConnectionDecoration;
import org.xmind.gef.draw2d.decoration.ICorneredDecoration;
import org.xmind.gef.draw2d.decoration.IDecoration;
import org.xmind.gef.draw2d.decoration.ILineDecoration;
import org.xmind.gef.draw2d.decoration.IShapeDecoration;
import org.xmind.gef.graphicalpolicy.IGraphicalPolicy;
import org.xmind.gef.graphicalpolicy.IStructure;
import org.xmind.gef.graphicalpolicy.IStyleSelector;
import org.xmind.gef.part.IGraphicalEditPart;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IRequestHandler;
import org.xmind.ui.branch.IBranchPolicy;
import org.xmind.ui.branch.IBranchStructureExtension;
import org.xmind.ui.branch.IBranchStyleSelector;
import org.xmind.ui.decorations.IBranchConnectionDecoration;
import org.xmind.ui.decorations.IBranchConnections;
import org.xmind.ui.decorations.IBranchConnections2;
import org.xmind.ui.decorations.ICalloutTopicDecoration;
import org.xmind.ui.internal.InfoItemContributorManager;
import org.xmind.ui.internal.ModelCacheManager;
import org.xmind.ui.internal.decorations.BranchConnections;
import org.xmind.ui.internal.decorations.CalloutBranchConnections;
import org.xmind.ui.internal.figures.BranchFigure;
import org.xmind.ui.internal.layouts.BranchLayout;
import org.xmind.ui.internal.mindmap.BoundaryPart;
import org.xmind.ui.internal.mindmap.ChildSorter;
import org.xmind.ui.internal.mindmap.InfoPart;
import org.xmind.ui.internal.mindmap.MindMapPartBase;
import org.xmind.ui.internal.mindmap.PlusMinusPart;
import org.xmind.ui.internal.mindmap.SheetPart;
import org.xmind.ui.internal.mindmap.SummaryPart;
import org.xmind.ui.internal.mindmap.SummaryViewerModel;
import org.xmind.ui.internal.mindmap.TopicPart;
import org.xmind.ui.internal.mindmap.ViewerModel;
import org.xmind.ui.mindmap.IBoundaryPart;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.IInfoPart;
import org.xmind.ui.mindmap.ILabelPart;
import org.xmind.ui.mindmap.INodePart;
import org.xmind.ui.mindmap.IPlusMinusPart;
import org.xmind.ui.mindmap.ISheetPart;
import org.xmind.ui.mindmap.ISummaryPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.style.StyleUtils;
import org.xmind.ui.util.MindMapUtils;

public class BranchPart
extends MindMapPartBase
implements IBranchPart {
    private ITopicPart topicPart = null;
    private List<IBranchPart> subBranches = null;
    private IPlusMinusPart plusMinus = null;
    private List<IBoundaryPart> boundaries = null;
    private List<ISummaryPart> summaries = null;
    private List<IBranchPart> summaryBranches = null;
    private List<IBranchPart> calloutBranches = null;
    private ILabelPart label = null;
    private IInfoPart infoPart = null;
    private boolean central = false;
    private ChildSorter sorter = new ChildSorter((IPart)this);
    private BranchConnections connections = null;
    private String branchPolicyId = null;
    private int level = -1;
    private CalloutBranchConnections calloutConnections;
    private String overrideBranchType = null;

    @Override
    public ITopic getTopic() {
        return (ITopic)this.getRealModel();
    }

    @Override
    public IBranchPart getParentBranch() {
        if (this.getParent() instanceof IBranchPart) {
            return (IBranchPart)this.getParent();
        }
        return null;
    }

    @Override
    public ITopicPart getTopicPart() {
        return this.topicPart;
    }

    public void setTopicPart(ITopicPart topicPart) {
        this.topicPart = topicPart;
    }

    @Override
    public IPlusMinusPart getPlusMinus() {
        return this.plusMinus;
    }

    public void setPlusMinus(IPlusMinusPart plusMinus) {
        this.plusMinus = plusMinus;
    }

    @Override
    public List<IBranchPart> getSubBranches() {
        if (this.subBranches == null) {
            this.subBranches = new ArrayList<IBranchPart>();
        }
        return this.subBranches;
    }

    public void addSubBranch(IBranchPart subBranch) {
        this.getSubBranches().add(subBranch);
        this.sorter.sort(this.getSubBranches());
        int index = this.getSubBranches().indexOf(subBranch);
        this.getConnections().add(this.getFigure(), index, null);
    }

    public void removeSubBranch(IBranchPart subBranch) {
        int index = this.getSubBranches().indexOf(subBranch);
        this.getConnections().remove(this.getFigure(), index);
        this.getSubBranches().remove(subBranch);
    }

    @Override
    public List<IBranchPart> getCalloutBranches() {
        if (this.calloutBranches == null) {
            this.calloutBranches = new ArrayList<IBranchPart>();
        }
        return this.calloutBranches;
    }

    public void addCalloutBranch(IBranchPart calloutBranch) {
        this.getCalloutBranches().add(calloutBranch);
        this.sorter.sort(this.getCalloutBranches());
        int index = this.getCalloutBranches().indexOf(calloutBranch);
        this.getCalloutConnections().add(this.getFigure(), index, null);
    }

    public void removeCalloutBranch(IBranchPart calloutBranch) {
        int index = this.getCalloutBranches().indexOf(calloutBranch);
        this.getCalloutConnections().remove(this.getFigure(), index);
        this.getCalloutBranches().remove(calloutBranch);
    }

    @Override
    public List<ISummaryPart> getSummaries() {
        if (this.summaries == null) {
            this.summaries = new ArrayList<ISummaryPart>();
        }
        return this.summaries;
    }

    public void addSummary(ISummaryPart summary) {
        this.getSummaries().add(summary);
        this.sorter.sort(this.getSummaries());
    }

    public void removeSummary(ISummaryPart summary) {
        this.getSummaries().remove(summary);
    }

    @Override
    public List<IBranchPart> getSummaryBranches() {
        if (this.summaryBranches == null) {
            this.summaryBranches = new ArrayList<IBranchPart>();
        }
        return this.summaryBranches;
    }

    public void addSummaryBranch(IBranchPart summaryBranch) {
        this.getSummaryBranches().add(summaryBranch);
        this.sorter.sort(this.getSummaryBranches());
    }

    public void removeSummaryBranch(IBranchPart summaryBranch) {
        this.getSummaryBranches().remove(summaryBranch);
    }

    @Override
    public ILabelPart getLabel() {
        return this.label;
    }

    public void setLabel(ILabelPart label) {
        this.label = label;
    }

    @Override
    public IInfoPart getInfoPart() {
        return this.infoPart;
    }

    public void setinfoPart(IInfoPart information) {
        this.infoPart = information;
    }

    protected IFigure createFigure() {
        BranchFigure branchFigure = new BranchFigure();
        branchFigure.setConnections((IDecoration)this.getConnections());
        branchFigure.setCalloutConnections(this.getCalloutConnections());
        return branchFigure;
    }

    public void setParent(IPart parent) {
        SheetPart sheet;
        BranchPart parentBranch;
        if (this.getParent() instanceof BranchPart) {
            parentBranch = (BranchPart)this.getParent();
            parentBranch.removeSubBranch(this);
            parentBranch.removeCalloutBranch(this);
            parentBranch.removeSummaryBranch(this);
        } else if (this.getParent() instanceof SheetPart) {
            sheet = (SheetPart)this.getParent();
            sheet.removeFloatingBranch(this);
            if (sheet.getCentralBranch() == this) {
                sheet.setCentralBranch(null);
            }
        }
        super.setParent(parent);
        this.central = this.getTopic().equals(this.getSite().getViewer().getAdapter(ITopic.class));
        if (this.getParent() instanceof BranchPart) {
            parentBranch = (BranchPart)this.getParent();
            this.level = parentBranch.getLevel() + 1;
            if ("attached".equals(this.getTopic().getType())) {
                parentBranch.addSubBranch(this);
            } else if ("summary".equals(this.getTopic().getType())) {
                parentBranch.addSummaryBranch(this);
            } else if ("callout".equals(this.getTopic().getType())) {
                parentBranch.addCalloutBranch(this);
            }
        } else if (this.getParent() instanceof SheetPart) {
            sheet = (SheetPart)this.getParent();
            if (this.getTopic().equals(sheet.getCentralTopic())) {
                this.level = 0;
                sheet.setCentralBranch(this);
            } else if ("detached".equals(this.getTopic().getType())) {
                this.level = 1;
                sheet.addFloatingBranch(this);
            }
        }
        this.setBranchPolicyId(this.findNewBranchPolicyId());
    }

    @Override
    public int getBranchIndex() {
        IBranchPart parentBranch = this.getParentBranch();
        if (parentBranch != null) {
            if ("calloutBranch".equals(this.getBranchType())) {
                return parentBranch.getCalloutBranches().indexOf(this);
            }
            return parentBranch.getSubBranches().indexOf(this);
        }
        return 0;
    }

    public int getLevel() {
        return this.level;
    }

    @Override
    public List<IBoundaryPart> getBoundaries() {
        if (this.boundaries == null) {
            this.boundaries = new ArrayList<IBoundaryPart>();
        }
        return this.boundaries;
    }

    public void addBoundary(IBoundaryPart boundary) {
        this.getBoundaries().add(boundary);
        this.sorter.sort(this.getBoundaries());
    }

    public void removeBoundary(IBoundaryPart boundary) {
        this.getBoundaries().remove(boundary);
    }

    @Override
    public boolean isCentral() {
        return this.central;
    }

    @Override
    public boolean isFolded() {
        return ((BranchFigure)this.getFigure()).isFolded();
    }

    @Override
    public String getBranchType() {
        if (this.overrideBranchType != null) {
            return this.overrideBranchType;
        }
        if (this.isCentral()) {
            return "centralBranch";
        }
        IPart p = this.getParent();
        if (p instanceof IBranchPart) {
            IBranchPart parentBranch = (IBranchPart)p;
            if (parentBranch.isCentral() && parentBranch.getSubBranches().contains(this)) {
                return "mainBranch";
            }
            if (parentBranch.getSummaryBranches().contains(this)) {
                return "summaryBranch";
            }
            if (parentBranch.getCalloutBranches().contains(this)) {
                return "calloutBranch";
            }
        }
        if (p instanceof ISheetPart && ((ISheetPart)p).getFloatingBranches().contains(this)) {
            return "floatingBranch";
        }
        return "subBranch";
    }

    public void setOverrideBranchType(String overrideBranchType) {
        this.overrideBranchType = overrideBranchType;
    }

    protected LayoutManager createLayoutManager() {
        return new BranchLayout(this);
    }

    protected Object[] getModelChildren(Object model) {
        ArrayList<ViewerModel> list = new ArrayList<ViewerModel>();
        ITopic topic = this.getTopic();
        boolean showsSubTopics = this.showsSubTopics();
        if (showsSubTopics) {
            for (IBoundary b : MindMapUtils.getSortedBoundaries(topic)) {
                list.add(new ViewerModel(BoundaryPart.class, b));
            }
        } else {
            for (IBoundary b : topic.getBoundaries()) {
                if (!b.isMasterBoundary()) continue;
                list.add(new ViewerModel(BoundaryPart.class, b));
                break;
            }
        }
        list.add(new ViewerModel(TopicPart.class, topic));
        if (!InfoItemContributorManager.getInstance().getContributors().isEmpty()) {
            list.add(new ViewerModel(InfoPart.class, topic));
        }
        if (showsSubTopics) {
            List children = topic.getChildren("attached");
            if (!children.isEmpty()) {
                list.add(new ViewerModel(PlusMinusPart.class, topic));
            }
            for (ITopic subtopic : children) {
                list.add(new ViewerModel(BranchPart.class, subtopic));
            }
            List calloutTopics = topic.getChildren("callout");
            for (ITopic calloutTopic : calloutTopics) {
                list.add(new ViewerModel(BranchPart.class, calloutTopic));
            }
            for (ISummary summary : topic.getSummaries()) {
                ITopic summaryTopic = summary.getTopic();
                if (summaryTopic == null) continue;
                list.add(new SummaryViewerModel(SummaryPart.class, summary, summaryTopic));
            }
            for (ITopic summaryTopic : topic.getChildren("summary")) {
                list.add(new ViewerModel(BranchPart.class, summaryTopic));
            }
        }
        return list.toArray();
    }

    private boolean showsSubTopics() {
        int maxLevel = this.getSite().getViewer().getProperties().getInteger("maxTopicLevel", -1);
        return maxLevel < 0 || this.level < maxLevel;
    }

    protected void addChild(IPart child, int index) {
        super.addChild(child, index);
        if (this.getStatus().isActive()) {
            this.update();
            if (child instanceof IBranchPart && child.getStatus().isActive()) {
                child.update();
            }
        }
    }

    protected void removeChild(IPart child) {
        super.removeChild(child);
        if (this.getStatus().isActive()) {
            this.update();
        }
    }

    protected void reorderChild(IPart child, int index) {
        int oldBranchIndex = this.getSubBranches().indexOf(child);
        int oldCallloutBranchIndex = this.getCalloutBranches().indexOf(child);
        super.reorderChild(child, index);
        if (oldCallloutBranchIndex >= 0) {
            this.sorter.sort(this.getCalloutBranches());
            int newCalloutBranchIndex = this.getCalloutBranches().indexOf(child);
            this.getCalloutConnections().move(this.getFigure(), oldCallloutBranchIndex, newCalloutBranchIndex);
        }
        if (oldBranchIndex >= 0) {
            this.sorter.sort(this.getSubBranches());
            int newBranchIndex = this.getSubBranches().indexOf(child);
            this.getConnections().move(this.getFigure(), oldBranchIndex, newBranchIndex);
        } else if (this.getBoundaries().contains(child)) {
            this.sorter.sort(this.getBoundaries());
        } else if (this.getSummaries().contains(child)) {
            this.sorter.sort(this.getSummaries());
        } else if (this.getSummaryBranches().contains(child)) {
            this.sorter.sort(this.getSummaryBranches());
        }
        this.update();
    }

    @Override
    protected void registerCoreEvents(Object source, ICoreEventRegister register) {
        super.registerCoreEvents(source, register);
        register.register("topicFolded");
        register.register("topicAdd");
        register.register("topicRemove");
        register.register("position");
        register.register("boundaryAdd");
        register.register("boundaryRemove");
        register.register("summaryAdd");
        register.register("summaryRemove");
        register.register("style");
        register.register("structureClass");
        register.register("labels");
        register.register("topicNotes");
        ISheet sheet = this.getTopic().getOwnedSheet();
        register.setNextSourceFrom((Object)sheet);
        register.register("visibility");
        register.register("sheetSettings");
    }

    @Override
    public void handleCoreEvent(CoreEvent event) {
        Object modelcacheForLayout = ModelCacheManager.getInstance().getCache(this.getTopic(), "org.xmind.ui.delayLayout");
        if (Boolean.TRUE.equals(modelcacheForLayout)) {
            return;
        }
        String type = event.getType();
        if ("topicFolded".equals(type)) {
            this.treeUpdate(true);
        } else if ("topicAdd".equals(type) || "topicRemove".equals(type)) {
            Object topicType = event.getData();
            if ("attached".equals(topicType) || "callout".equals(topicType)) {
                this.refresh();
            } else if ("summary".equals(topicType)) {
                this.refresh();
            }
        } else if ("position".equals(type)) {
            Point newPosition = (Point)event.getNewValue();
            org.eclipse.draw2d.geometry.Point p = MindMapUtils.toGraphicalPosition(newPosition);
            this.getCacheManager().setCache("org.xmind.ui.cache.preferredPosition", p);
            this.getFigure().revalidate();
        } else if ("boundaryAdd".equals(type) || "boundaryRemove".equals(type) || "summaryAdd".equals(type) || "summaryRemove".equals(type)) {
            this.refresh();
        } else if ("style".equals(type)) {
            this.refreshStyles();
        } else if ("structureClass".equals(type)) {
            this.treeUpdateBranchPolicy();
            this.sendFakeStyleEvent();
        } else if ("labels".equals(type) || "topicNotes".equals(type) || "topicHyperlink".equals(type) || "visibility".equals(type) || "sheetSettings".equals(type)) {
            this.refresh();
            if (this.getInfoPart() != null) {
                this.getInfoPart().refresh();
            }
            if (this.getTopicPart() != null) {
                this.getTopicPart().refresh();
            }
        } else {
            super.handleCoreEvent(event);
        }
    }

    private void sendFakeStyleEvent() {
        ICoreEventSupport coreEventSupport = (ICoreEventSupport)this.getTopic().getOwnedWorkbook().getAdapter(ICoreEventSupport.class);
        if (coreEventSupport != null) {
            ICoreEventSource source = (ICoreEventSource)this.getTopic();
            String styleId = this.getTopic().getStyleId();
            CoreEvent event = new CoreEvent(source, "style", (Object)styleId, (Object)styleId);
            coreEventSupport.dispatch(source, event);
        }
    }

    public void refreshStyles() {
        this.treeFlushStyleCaches();
        this.treeUpdate(true);
        this.treeRefresh();
        this.floatingRefresh();
    }

    private void treeFlushStyleCaches() {
        IStyleSelector ss = this.getGraphicalPolicy().getStyleSelector((IGraphicalPart)this);
        if (ss instanceof IBranchStyleSelector) {
            ((IBranchStyleSelector)ss).flushStyleCaches(this);
        }
        for (IBranchPart subBranch : this.getSubBranches()) {
            ((BranchPart)subBranch).treeFlushStyleCaches();
        }
        for (IBranchPart calloutBranch : this.getCalloutBranches()) {
            ((BranchPart)calloutBranch).treeFlushStyleCaches();
        }
        for (IBranchPart summaryBranch : this.getSummaryBranches()) {
            ((BranchPart)summaryBranch).treeFlushStyleCaches();
        }
    }

    protected void treeUpdateBranchPolicy() {
        this.updateBranchPolicy();
        this.updateView();
        this.refreshChildren();
        for (IBranchPart subBranch : this.getSubBranches()) {
            ((BranchPart)subBranch).treeUpdateBranchPolicy();
        }
        for (IBranchPart calloutBranch : this.getCalloutBranches()) {
            ((BranchPart)calloutBranch).treeUpdateBranchPolicy();
        }
        for (IBranchPart summaryBranch : this.getSummaryBranches()) {
            ((BranchPart)summaryBranch).treeUpdateBranchPolicy();
        }
        this.updateChildren();
    }

    private void updateBranchPolicy() {
        String newId = this.findNewBranchPolicyId();
        this.setBranchPolicyId(newId);
    }

    private void setBranchPolicyId(String newId) {
        if (this.branchPolicyId == null && newId == null || this.branchPolicyId != null && this.branchPolicyId.equals(newId)) {
            return;
        }
        IBranchPolicy newPolicy = MindMapUI.getBranchPolicyManager().getBranchPolicy(newId);
        this.branchPolicyId = newId;
        this.setGraphicalPolicy(newPolicy);
        this.getFigure().revalidate();
    }

    @Override
    public void setGraphicalPolicy(IGraphicalPolicy graphicalPolicy) {
        IGraphicalPolicy oldPolicy = this.getGraphicalPolicy();
        super.setGraphicalPolicy(graphicalPolicy);
        if (oldPolicy instanceof IBranchPolicy) {
            ((IBranchPolicy)oldPolicy).postDeactivate(this);
        }
    }

    @Override
    public String getBranchPolicyId() {
        if (this.branchPolicyId == null) {
            this.branchPolicyId = this.findNewBranchPolicyId();
        }
        return this.branchPolicyId;
    }

    private String findNewBranchPolicyId() {
        return MindMapUI.getBranchPolicyManager().calculateBranchPolicyId(this, this.getTopic().getStructureClass());
    }

    @Override
    public IBranchPolicy getBranchPolicy() {
        IGraphicalPolicy gp = this.getGraphicalPolicy();
        if (gp instanceof IBranchPolicy) {
            return (IBranchPolicy)gp;
        }
        return MindMapUI.getBranchPolicyManager().getDefaultBranchPolicy();
    }

    public void setModel(Object model) {
        super.setModel(model);
        org.eclipse.draw2d.geometry.Point p = MindMapUtils.toGraphicalPosition(this.getTopic().getPosition());
        this.getCacheManager().setCache("org.xmind.ui.cache.preferredPosition", p);
    }

    @Override
    protected void onActivated() {
        super.onActivated();
    }

    @Override
    protected void onDeactivated() {
        super.onDeactivated();
    }

    @Override
    protected void updateView() {
        String newDescId;
        super.updateView();
        BranchFigure branchFigure = (BranchFigure)this.getFigure();
        branchFigure.setFolded(this.shouldBeFolded());
        boolean animating = this.isFigureAnimating();
        IBranchPart parent = this.getParentBranch();
        if (parent != null) {
            branchFigure.setMinimized(this.isUnusedSummaryBranch(parent));
            IFigure parentFigure = parent.getFigure();
            if (parentFigure instanceof BranchFigure) {
                BranchFigure parentBranchFigure = (BranchFigure)parentFigure;
                if (!animating) {
                    branchFigure.setVisible(!parentBranchFigure.isFolded() && parentBranchFigure.isVisible());
                }
            }
        }
        IStyleSelector ss = StyleUtils.getStyleSelector(this);
        IDecoration decoration = branchFigure.getDecoration();
        if (!StyleUtils.isSameDecoration(decoration, newDescId = StyleUtils.getString(this, ss, "branch-decoration-class", "org.xmind.branchDecoration.default"))) {
            decoration = StyleUtils.createBranchDecoration(this, newDescId);
            branchFigure.setDecoration(decoration);
        }
        if (decoration != null) {
            decoration.setAlpha((IFigure)branchFigure, 255);
            if (!animating) {
                decoration.setVisible((IFigure)branchFigure, branchFigure.isVisible());
            }
        }
    }

    private boolean isUnusedSummaryBranch(IBranchPart parent) {
        if (parent.getSummaryBranches().contains(this)) {
            String topicId = this.getTopic().getId();
            for (ISummary s : parent.getTopic().getSummaries()) {
                if (!topicId.equals(s.getTopicId())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean shouldBeFolded() {
        if (!this.isPropertyModifiable("topicFolded")) {
            return false;
        }
        Object cache = MindMapUtils.getCache((IPart)this, "org.xmind.ui.cache.folded");
        if (cache != null) {
            return Boolean.TRUE.equals(cache);
        }
        return this.getTopic().isFolded();
    }

    protected void updateChildren() {
        IFigure parentFigure;
        super.updateChildren();
        BranchFigure branchFigure = (BranchFigure)this.getFigure();
        branchFigure.setFolded(this.shouldBeFolded());
        boolean animating = this.isFigureAnimating();
        IBranchPart parent = this.getParentBranch();
        if (parent != null && (parentFigure = parent.getFigure()) instanceof BranchFigure) {
            BranchFigure parentBranchFigure = (BranchFigure)parentFigure;
            if (!animating) {
                branchFigure.setVisible(!parentBranchFigure.isFolded() && parentBranchFigure.isVisible());
            }
            if ("calloutBranch".equals(this.getBranchType())) {
                this.decorateCalloutConnections(parent, parentBranchFigure, parent.getCalloutConnections(), animating);
            }
        }
        if (this.getTopicPart() != null) {
            this.getTopicPart().update();
            this.getTopicPart().refresh();
        }
        if (this.getPlusMinus() != null) {
            this.getPlusMinus().update();
        }
        if (this.getLabel() != null) {
            this.getLabel().update();
        }
        if (this.getInfoPart() != null) {
            this.getInfoPart().update();
            this.getInfoPart().refresh();
        }
        for (IBoundaryPart b : this.getBoundaries()) {
            b.update();
        }
        for (ISummaryPart s : this.getSummaries()) {
            s.update();
        }
        IStyleSelector ss = StyleUtils.getStyleSelector(this);
        this.decorateConnections(ss, branchFigure, this.getConnections(), animating);
        this.decorateCalloutConnections(this, (BranchFigure)this.getFigure(), this.getCalloutConnections(), animating);
    }

    private void decorateCalloutConnections(IBranchPart parent, BranchFigure parentFigure, IBranchConnections2 connections, boolean ignoreVisibility) {
        connections.setId("org.xmind.ui.calloutbranchconnections");
        List<IBranchPart> calloutBranches = parent.getCalloutBranches();
        int i = 0;
        while (i < calloutBranches.size()) {
            this.decorateCalloutConnection(parent, parentFigure, connections, i, ignoreVisibility);
            ++i;
        }
    }

    private void decorateCalloutConnection(IBranchPart parent, BranchFigure parentFigure, IBranchConnections2 connections, int index, boolean ignoreVisibility) {
        IBranchPart calloutBranch = parent.getCalloutBranches().get(index);
        Object connection = connections.getDecoration(index);
        BranchFigure calloutBranchFigure = (BranchFigure)calloutBranch.getFigure();
        IDecoratedFigure topicFigure = (IDecoratedFigure)calloutBranch.getTopicPart().getFigure();
        IDecoration topicDecoration = topicFigure.getDecoration();
        if (topicDecoration instanceof ICalloutTopicDecoration) {
            ICalloutTopicDecoration ctd = (ICalloutTopicDecoration)topicDecoration;
            String connectionId = ctd.getFromLineClass();
            if (!StyleUtils.isSameDecoration(connection, connectionId)) {
                connection = StyleUtils.createBranchConnection(calloutBranch, connectionId);
                ((CalloutBranchConnections)connections).putFigureToDecoration((IFigure)calloutBranchFigure, (IDecoration)connection);
                connections.setDecoration((IFigure)parentFigure, index, (IDecoration)connection);
            }
            if (connection instanceof IShapeDecoration) {
                IShapeDecoration shapedConnection = (IShapeDecoration)connection;
                shapedConnection.setFillColor((IFigure)parentFigure, ctd.getFromFillColor());
                shapedConnection.setAlpha((IFigure)parentFigure, 255);
            }
            if (connection instanceof ICorneredDecoration) {
                ((ICorneredDecoration)connection).setCornerSize((IFigure)parentFigure, ctd.getFromLineCorner());
            }
            if (connection instanceof IConnectionDecoration) {
                IConnectionDecoration connectedConnection = (IConnectionDecoration)connection;
                IAnchor sourceAnchor = null;
                ITopicPart topic = parent.getTopicPart();
                if (topic instanceof INodePart) {
                    sourceAnchor = ((INodePart)((Object)topic)).getSourceAnchor(parent);
                }
                connectedConnection.setSourceAnchor((IFigure)parentFigure, sourceAnchor);
                IAnchor targetAnchor = null;
                ITopicPart subTopic = calloutBranch.getTopicPart();
                if (subTopic instanceof INodePart) {
                    targetAnchor = ((INodePart)((Object)subTopic)).getTargetAnchor(parent);
                }
                connectedConnection.setTargetAnchor((IFigure)calloutBranchFigure, targetAnchor);
            }
            if (connection instanceof ILineDecoration) {
                ILineDecoration linedConnection = (ILineDecoration)connection;
                linedConnection.setLineColor((IFigure)parentFigure, ctd.getFromLineColor());
                linedConnection.setLineStyle((IFigure)parentFigure, ctd.getFromLineStyle());
                linedConnection.setLineWidth((IFigure)parentFigure, ctd.getFromLineWidth());
            }
            if (connection instanceof IBranchConnectionDecoration) {
                IBranchConnectionDecoration branchConnection = (IBranchConnectionDecoration)connection;
                branchConnection.setSourceExpansion((IFigure)parentFigure, 0);
                branchConnection.setSourceOrientation((IFigure)parentFigure, 0);
                branchConnection.setTargetOrientation((IFigure)calloutBranchFigure, 0);
                branchConnection.setTargetExpansion((IFigure)calloutBranchFigure, 0);
                if (!ignoreVisibility) {
                    branchConnection.setVisible((IFigure)calloutBranchFigure, branchConnection.getSourceAnchor() != null && branchConnection.getTargetAnchor() != null && calloutBranchFigure.isVisible());
                }
            }
        }
    }

    private void decorateConnections(IStyleSelector ss, BranchFigure figure, IBranchConnections connections, boolean ignoreVisibility) {
        String newConnectionId = StyleUtils.getString(this, ss, "line-class", "org.xmind.branchConnection.straight");
        connections.setId(newConnectionId);
        IAnchor sourceAnchor = null;
        ITopicPart topic = this.getTopicPart();
        if (topic instanceof INodePart) {
            sourceAnchor = ((INodePart)((Object)topic)).getSourceAnchor(this);
        }
        connections.setSourceAnchor((IFigure)figure, sourceAnchor);
        connections.setAlpha((IFigure)figure, 255);
        connections.setLineColor((IFigure)figure, StyleUtils.getColor(this, ss, "line-color", newConnectionId, "#808080"));
        connections.setLineStyle((IFigure)figure, StyleUtils.getLineStyle(this, ss, newConnectionId, 1));
        connections.setLineWidth((IFigure)figure, StyleUtils.getInteger(this, ss, "line-width", newConnectionId, 1));
        int sourceOrientation = 0;
        IStructure structure = this.getBranchPolicy().getStructure(this);
        if (structure instanceof IBranchStructureExtension) {
            sourceOrientation = ((IBranchStructureExtension)structure).getSourceOrientation(this);
        }
        connections.setSourceOrientation((IFigure)figure, sourceOrientation);
        int sourceExpansion = this.getSourceExpansion(this, ss, sourceOrientation, connections.getLineWidth(), connections.getId());
        connections.setSourceExpansion((IFigure)figure, sourceExpansion);
        connections.setTapered((IFigure)figure, StyleUtils.isBranchLineTapered(this, ss));
        connections.setCornerSize((IFigure)figure, StyleUtils.getInteger(this, ss, "line-corner", newConnectionId, 5));
        List<IBranchPart> subBranches = this.getSubBranches();
        int i = 0;
        while (i < subBranches.size()) {
            IBranchPart subBranch = subBranches.get(i);
            Object connection = connections.getDecoration(i);
            if (!StyleUtils.isSameDecoration(connection, newConnectionId)) {
                connection = StyleUtils.createBranchConnection(this, newConnectionId);
                connections.setDecoration((IFigure)figure, i, (IDecoration)connection);
            }
            if (connection != null && connection instanceof IBranchConnectionDecoration) {
                this.decorateConnection(this, ss, figure, subBranch, (IBranchConnectionDecoration)connection, i, connections, ignoreVisibility);
            }
            ++i;
        }
    }

    private int getSourceExpansion(IBranchPart branch, IStyleSelector ss, int sourceOrientation, int lineWidth, String decorationId) {
        if (sourceOrientation == 0) {
            return 0;
        }
        IPlusMinusPart plusMinus = branch.getPlusMinus();
        if (plusMinus != null && plusMinus.getFigure().isVisible()) {
            Dimension size = plusMinus.getFigure().getPreferredSize();
            return Math.max(size.width, size.height) + lineWidth + 1;
        }
        int spacing = StyleUtils.getInteger(branch, ss, "spacing-major", decorationId, -1);
        if (spacing >= 0) {
            return spacing / 2;
        }
        return 7 + lineWidth;
    }

    private void decorateConnection(IBranchPart branch, IStyleSelector ss, BranchFigure figure, IBranchPart subBranch, IBranchConnectionDecoration connection, int subBranchIndex, IBranchConnections connections, boolean ignoreVisibility) {
        IAnchor targetAnchor = null;
        ITopicPart subTopic = subBranch.getTopicPart();
        if (subTopic instanceof INodePart) {
            targetAnchor = ((INodePart)((Object)subTopic)).getTargetAnchor(branch);
        }
        connection.setTargetAnchor((IFigure)figure, targetAnchor);
        int targetOrientation = 0;
        IStructure structure = branch.getBranchPolicy().getStructure(branch);
        if (structure instanceof IBranchStructureExtension) {
            targetOrientation = ((IBranchStructureExtension)structure).getChildTargetOrientation(branch, subBranch);
        }
        connection.setTargetOrientation((IFigure)figure, targetOrientation);
        connection.setTargetExpansion((IFigure)figure, 0);
        connection.setLineColor((IFigure)figure, StyleUtils.getBranchConnectionColor(branch, ss, subBranch, subBranchIndex, connections.getLineColor()));
        if (!ignoreVisibility) {
            connection.setVisible((IFigure)figure, connection.getSourceAnchor() != null && connection.getTargetAnchor() != null && figure.isVisible() && !figure.isFolded());
        }
    }

    @Override
    public void treeUpdate(boolean updateParent) {
        IBranchPart parentBranch;
        if (updateParent && (parentBranch = this.getParentBranch()) != null) {
            ((BranchPart)parentBranch).updateChildren();
        }
        this.updateView();
        for (IBranchPart subBranch : this.getSubBranches()) {
            subBranch.treeUpdate(false);
        }
        for (IBranchPart calloutBranch : this.getCalloutBranches()) {
            calloutBranch.treeUpdate(false);
        }
        for (IBranchPart summaryBranch : this.getSummaryBranches()) {
            summaryBranch.treeUpdate(false);
        }
        this.updateChildren();
    }

    @Override
    public void treeRefresh() {
        if (this.getInfoPart() != null) {
            this.getInfoPart().refresh();
        }
        if (this.getTopicPart() != null) {
            this.getTopicPart().refresh();
        }
        for (IBranchPart subBranch : this.getSubBranches()) {
            subBranch.treeRefresh();
        }
        for (IBranchPart calloutBranch : this.getCalloutBranches()) {
            calloutBranch.treeRefresh();
        }
        for (IBranchPart summaryBranch : this.getSummaryBranches()) {
            summaryBranch.treeRefresh();
        }
        this.updateChildren();
    }

    private void floatingRefresh() {
        IPart parent = this.getParent();
        if (parent != null && parent instanceof SheetPart) {
            List<IBranchPart> floatings = ((SheetPart)parent).getFloatingBranches();
            for (IBranchPart floating : floatings) {
                IInfoPart infoPart = floating.getInfoPart();
                if (infoPart != null) {
                    infoPart.refresh();
                }
                floating.treeRefresh();
            }
        }
    }

    protected void declareEditPolicies(IRequestHandler reqHandler) {
        super.declareEditPolicies(reqHandler);
        reqHandler.installEditPolicy("creatable role", "org.xmind.ui.editPolicy.topicCreatable");
        reqHandler.installEditPolicy("extendable role", "org.xmind.ui.editPolicy.extendable");
        reqHandler.installEditPolicy("deletable role", "org.xmind.ui.editPolicy.deletable");
    }

    @Override
    public boolean isPropertyModifiable(String propertyName) {
        return this.isPropertyModifiable(propertyName, null);
    }

    @Override
    public boolean isPropertyModifiable(String propertyName, String secondaryKey) {
        return this.getBranchPolicy().isPropertyModifiable(this, propertyName, secondaryKey);
    }

    public IPart findAt(org.eclipse.draw2d.geometry.Point position) {
        IPart ret;
        IPart focusedPart = this.getSite().getViewer().getFocusedPart();
        if (focusedPart instanceof IGraphicalEditPart && this.getBoundaries().contains(focusedPart) && (ret = ((IGraphicalEditPart)focusedPart).findAt(position)) != null) {
            return ret;
        }
        ret = super.findAt(position);
        if (ret == this) {
            return null;
        }
        return ret;
    }

    @Override
    public boolean canSearchChild() {
        BranchFigure figure = (BranchFigure)this.getFigure();
        return !figure.isFolded() && !figure.isMinimized() && figure.isVisible() && figure.isEnabled() && (!this.getSubBranches().isEmpty() || !this.getSummaryBranches().isEmpty() || !this.getCalloutBranches().isEmpty());
    }

    @Override
    protected boolean isFigureAnimatable() {
        return true;
    }

    @Override
    public IBranchConnections getConnections() {
        if (this.connections == null) {
            this.connections = new BranchConnections();
        }
        return this.connections;
    }

    @Override
    public IBranchConnections2 getCalloutConnections() {
        if (this.calloutConnections == null) {
            this.calloutConnections = new CalloutBranchConnections();
        }
        return this.calloutConnections;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(ITopic.class)) {
            return this.getTopic();
        }
        if (adapter == ITopicPart.class) {
            return this.getTopicPart();
        }
        if (adapter == IPlusMinusPart.class) {
            return this.getPlusMinus();
        }
        if (adapter == ILabelPart.class) {
            return this.getLabel();
        }
        if (adapter == IInfoPart.class) {
            return this.getInfoPart();
        }
        return super.getAdapter(adapter);
    }
}

