/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.draw2d.ReferencedFigure;
import org.xmind.gef.draw2d.geometry.IPrecisionTransformer;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.draw2d.geometry.PrecisionTransposer;
import org.xmind.gef.draw2d.geometry.PrecisionVerticalFlipper;
import org.xmind.ui.resources.ColorUtils;

class RangeMoveHandleFigure
extends ReferencedFigure {
    private static final int PREF_MIN_WIDTH = 16;
    private static final double RATIO = 0.7;
    private static final int HEIGHT = (4 + (int)Math.ceil(2.8)) * 2;
    private static final int LINE_WIDTH = 2;
    private static final double CORNER_WIDTH = 1.4;
    private static PrecisionPoint p1 = new PrecisionPoint();
    private static PrecisionPoint p2 = new PrecisionPoint();
    private static PrecisionPoint p3 = new PrecisionPoint();
    private static PrecisionPoint p4 = new PrecisionPoint();
    private static PrecisionPoint p5 = new PrecisionPoint();
    private static PrecisionPoint p6 = new PrecisionPoint();
    private static PrecisionPoint p7 = new PrecisionPoint();
    private static IPrecisionTransformer t = new PrecisionTransposer();
    private static IPrecisionTransformer v = new PrecisionVerticalFlipper();
    private int orientation;
    private int alpha = 255;

    public RangeMoveHandleFigure(int orientation) {
        this.orientation = orientation;
        this.setForegroundColor(ColorUtils.getColor((String)"#0033cc"));
        this.setBackgroundColor(ColorUtils.getColor((String)"#90c8f0"));
    }

    public void setClientSize(Dimension client) {
        if (this.isVertical()) {
            int w = Math.min(client.width, Math.max(client.width / 2, 16));
            this.setPreferredSize(w, HEIGHT);
            this.setSize(w, HEIGHT);
        } else {
            int h = Math.min(client.height, Math.max(client.height / 2, 16));
            this.setPreferredSize(HEIGHT, h);
            this.setSize(HEIGHT, h);
        }
    }

    private boolean isVertical() {
        return (this.orientation & 5) != 0;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
        this.repaint();
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        graphics.setAntialias(1);
        graphics.setAlpha(this.getAlpha());
        graphics.setLineWidth(1);
        graphics.setLineStyle(1);
        org.xmind.gef.draw2d.graphics.Path shape = new org.xmind.gef.draw2d.graphics.Path((Device)Display.getCurrent());
        this.createShape2(shape);
        graphics.fillPath((Path)shape);
        graphics.drawPath((Path)shape);
        shape.dispose();
    }

    protected void createShape2(org.xmind.gef.draw2d.graphics.Path shape) {
        double temp;
        Rectangle r = this.getBounds();
        p1.setLocation((double)r.x, (double)r.y);
        p6.setLocation((double)r.right(), (double)r.bottom());
        t.setEnabled((this.orientation & 0x18) != 0);
        v.setEnabled((this.orientation & 0x14) != 0);
        t.setOrigin((RangeMoveHandleFigure.p1.x + RangeMoveHandleFigure.p6.x) / 2.0, (RangeMoveHandleFigure.p1.y + RangeMoveHandleFigure.p6.y) / 2.0);
        v.setOrigin(t.getOrigin());
        v.t(t.t(p1));
        v.t(t.t(p6));
        if (RangeMoveHandleFigure.p6.x < RangeMoveHandleFigure.p1.x) {
            temp = RangeMoveHandleFigure.p1.x;
            RangeMoveHandleFigure.p1.x = RangeMoveHandleFigure.p6.x;
            RangeMoveHandleFigure.p6.x = temp;
        }
        if (RangeMoveHandleFigure.p6.y < RangeMoveHandleFigure.p1.y) {
            temp = RangeMoveHandleFigure.p1.y;
            RangeMoveHandleFigure.p1.y = RangeMoveHandleFigure.p6.y;
            RangeMoveHandleFigure.p6.y = temp;
        }
        RangeMoveHandleFigure.p6.y = (RangeMoveHandleFigure.p6.y + RangeMoveHandleFigure.p1.y) / 2.0;
        RangeMoveHandleFigure.p1.y = RangeMoveHandleFigure.p6.y - 2.0;
        double width = RangeMoveHandleFigure.p6.x - RangeMoveHandleFigure.p1.x;
        double a = width < 16.0 ? width / 4.0 : 4.0;
        double b = a * 0.7;
        double c = RangeMoveHandleFigure.p1.x + width / 2.0;
        p2.setLocation(c - a, RangeMoveHandleFigure.p1.y);
        p3.setLocation(c, RangeMoveHandleFigure.p1.y - b);
        p4.setLocation(c + a, RangeMoveHandleFigure.p1.y);
        p5.setLocation(RangeMoveHandleFigure.p6.x, RangeMoveHandleFigure.p1.y);
        p7.setLocation(RangeMoveHandleFigure.p1.x, RangeMoveHandleFigure.p6.y);
        double d = Math.min(1.4, (width - a * 2.0) / 2.0);
        RangeMoveHandleFigure.p1.x += d;
        RangeMoveHandleFigure.p5.x -= d;
        t.r(v.r(p1));
        t.r(v.r(p2));
        t.r(v.r(p3));
        t.r(v.r(p4));
        t.r(v.r(p5));
        t.r(v.r(p6));
        t.r(v.r(p7));
        shape.moveTo(p1);
        shape.lineTo(p2);
        shape.lineTo(p3);
        shape.lineTo(p4);
        shape.lineTo(p5);
        shape.lineTo(p6);
        shape.lineTo(p7);
        shape.close();
    }

    protected void createShape1(org.xmind.gef.draw2d.graphics.Path shape) {
        Rectangle r = this.getBounds().getResized(-1, -1);
        switch (this.orientation) {
            case 1: {
                shape.moveTo((float)r.x, (float)r.bottom());
                shape.lineTo((float)r.x + (float)r.width * 0.5f, (float)r.y);
                shape.lineTo((float)r.right(), (float)r.bottom());
                shape.close();
                break;
            }
            case 4: {
                shape.moveTo((float)r.x, (float)r.y);
                shape.lineTo((float)r.right(), (float)r.y);
                shape.lineTo((float)r.x + (float)r.width * 0.5f, (float)r.bottom());
                shape.close();
                break;
            }
            case 16: {
                shape.moveTo((float)r.x, (float)r.y);
                shape.lineTo((float)r.right(), (float)r.y + (float)r.height * 0.5f);
                shape.lineTo((float)r.x, (float)r.bottom());
                shape.close();
                break;
            }
            case 8: {
                shape.moveTo((float)r.right(), (float)r.y);
                shape.lineTo((float)r.right(), (float)r.bottom());
                shape.lineTo((float)r.x, (float)r.y + (float)r.height * 0.5f);
                shape.close();
            }
        }
    }
}

