/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.xmind.ui.internal.wizards.WizardMessages;
import org.xmind.ui.wizards.AbstractMindMapExportWizard;
import org.xmind.ui.wizards.IExporter;

public abstract class DocumentExportWizard
extends AbstractMindMapExportWizard {
    @Override
    protected void doExport(IProgressMonitor monitor, Display display, Shell parentShell) throws InvocationTargetException, InterruptedException {
        monitor.beginTask(null, 100);
        monitor.subTask(WizardMessages.Export_Initializing);
        IExporter exporter = this.createExporter();
        if (!exporter.canStart()) {
            throw new InterruptedException();
        }
        exporter.start(display, parentShell);
        monitor.worked(10);
        int total = exporter.getTotalWork();
        int worked = 0;
        int uiTotal = 88;
        int uiWorked = 0;
        while (exporter.hasNext()) {
            monitor.subTask(this.cleanFileName(exporter.getNextName()));
            exporter.writeNext(monitor);
            int newUIWorked = ++worked * uiTotal / total;
            if (newUIWorked <= uiWorked) continue;
            monitor.worked(newUIWorked - uiWorked);
            uiWorked = newUIWorked;
        }
        if (uiWorked < uiTotal) {
            monitor.worked(uiTotal - uiWorked);
        }
        monitor.subTask(WizardMessages.Export_Finishing);
        exporter.end();
        monitor.worked(1);
        this.launchTargetFile(true, monitor, display, parentShell);
        monitor.done();
    }

    protected abstract IExporter createExporter();
}

