/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.taskinfo.commands;

import org.eclipse.core.runtime.Assert;
import org.xmind.core.IExtensionElement;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtension;
import org.xmind.core.ITopicExtensionElement;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.gef.command.SourceCommand;
import org.xmind.ui.internal.taskinfo.Dependency;
import org.xmind.ui.internal.taskinfo.TaskMessages;

public class AddDependencyCommand
extends SourceCommand {
    private ITopic topic;
    private ITopic task;
    private String type;
    private Dependency predecessor;
    private int index;

    public AddDependencyCommand(ITopic topic, ITopic task, String type) {
        super((Object)topic);
        Assert.isNotNull((Object)task);
        Assert.isNotNull((Object)type);
        this.topic = topic;
        this.task = task;
        this.type = type;
        this.setLabel(TaskMessages.Command_AddDependency);
    }

    public void redo() {
        ITopicExtension ext = this.topic.createExtension("org.xmind.ui.taskInfo");
        ITopicExtensionElement content = ext.getContent();
        ITopicExtensionElement parentElement = (ITopicExtensionElement)content.getCreatedChild("predecessors");
        if (this.predecessor == null) {
            ITopicExtensionElement element = (ITopicExtensionElement)parentElement.createChild("predecessor");
            element.setAttribute("task-id", this.task.getId());
            element.setAttribute("type", this.type);
            this.index = parentElement.getChildren().size();
            this.predecessor = Dependency.getInstance(element);
        } else {
            parentElement.addChild((IExtensionElement)this.predecessor.getElement(), this.index);
        }
        this.fireCoreEvent(this.topic);
        super.redo();
    }

    public void undo() {
        ITopicExtensionElement element;
        ITopicExtensionElement parentElement;
        if (this.predecessor != null && (parentElement = (ITopicExtensionElement)(element = this.predecessor.getElement()).getParent()) != null) {
            parentElement.deleteChild((IExtensionElement)element);
            this.fireCoreEvent(this.topic);
        }
        super.undo();
    }

    private void fireCoreEvent(ITopic topic) {
        if (topic instanceof ICoreEventSource) {
            ((ICoreEventSource)topic).getCoreEventSupport().dispatchTargetChange((ICoreEventSource)topic, "taskInfoChange", (Object)"predecessors");
        }
    }
}

