/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.command;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Iterator;
import org.xmind.core.command.ICommand;
import org.xmind.core.command.arguments.Attributes;
import org.xmind.core.command.binary.IBinaryEntry;
import org.xmind.core.command.binary.IBinaryStore;
import org.xmind.core.internal.command.Logger;
import org.xmind.core.internal.command.XMindCommandPlugin;

public class Command
implements ICommand {
    private static boolean DEBUGGING = XMindCommandPlugin.isDebugging("/debug");
    public static final String XMIND_SCHEME = "xmind";
    public static final String XMIND_PROTOCOL = "xmind:";
    private String source;
    private String commandName;
    private Attributes arguments;
    private String target;
    private IBinaryStore files;

    public Command(String source, String commandName) {
        this(source, commandName, null, null, null);
    }

    public Command(String source, String commandName, Attributes arguments, String target, IBinaryStore files) {
        this.source = source;
        this.commandName = commandName;
        this.arguments = arguments == null ? new Attributes() : arguments;
        this.target = target;
        this.files = files;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public Attributes getArguments() {
        return this.arguments;
    }

    public String getArgument(String key) {
        return this.arguments.get(key);
    }

    public String getSource() {
        return this.source;
    }

    public String getTarget() {
        return this.target;
    }

    public IBinaryStore getBinaryStore() {
        return this.files;
    }

    public IBinaryEntry getBinaryEntry(String entryName) {
        return this.files == null ? null : this.files.getEntry(entryName);
    }

    public static Command parseURI(String uriString, IBinaryStore files) {
        URI uri;
        try {
            uri = new URI(uriString);
        }
        catch (URISyntaxException uRISyntaxException) {
            Logger.log("Malformed URI: " + uriString, null);
            return null;
        }
        if (!XMIND_SCHEME.equals(uri.getScheme())) {
            if (DEBUGGING) {
                System.out.println("Not a valid XMind command URI: " + uriString);
            }
            return null;
        }
        return new Command(uri.getHost(), Command.trimPath(uri.getPath()), Command.parseArguments(uri.getRawQuery()), uri.getFragment(), files);
    }

    public static Command parseURI(String uriString) {
        return Command.parseURI(uriString, null);
    }

    private static String trimPath(String path) {
        if (path == null) {
            return path;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    private static Attributes parseArguments(String query) {
        if (query == null || "".equals(query)) {
            return new Attributes();
        }
        Attributes args = new Attributes();
        String[] stringArray = query.split("&");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String kv = stringArray[n2];
            int sep = kv.indexOf(61);
            if (sep < 0) {
                args.with(Command.urlDecode(kv), "");
            } else {
                args.with(Command.urlDecode(kv.substring(0, sep)), Command.urlDecode(kv.substring(sep + 1)));
            }
            ++n2;
        }
        return args;
    }

    private static String urlDecode(String text) {
        try {
            return URLDecoder.decode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            if (DEBUGGING) {
                System.err.println("Failed to decode XMind command argument: " + text);
                e.printStackTrace();
            }
            return text;
        }
    }

    private static String urlEncode(String text) {
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            if (DEBUGGING) {
                System.err.println("Failed to encode XMind command argument: " + text);
                e.printStackTrace();
            }
            return text;
        }
    }

    public String toURI() {
        return Command.toURI(this);
    }

    public String toString() {
        return this.toURI();
    }

    public static String toURI(ICommand command) {
        String target;
        StringBuffer buf = new StringBuffer(32);
        buf.append(XMIND_PROTOCOL);
        buf.append('/');
        buf.append('/');
        buf.append(command.getSource());
        String commandName = command.getCommandName();
        if (commandName != null) {
            if (!commandName.startsWith("/")) {
                buf.append('/');
            }
            buf.append(commandName);
        } else {
            buf.append('/');
        }
        Attributes arguments = command.getArguments();
        if (arguments != null && !arguments.isEmpty()) {
            buf.append('?');
            Iterator<String> keys = arguments.keys();
            boolean firstArgument = true;
            while (keys.hasNext()) {
                String key = keys.next();
                String value = arguments.get(key);
                if (value == null) continue;
                if (!firstArgument) {
                    buf.append('&');
                } else {
                    firstArgument = false;
                }
                buf.append(Command.urlEncode(key));
                buf.append('=');
                buf.append(Command.urlEncode(value));
            }
        }
        if ((target = command.getTarget()) != null) {
            buf.append('#');
            buf.append(target);
        }
        return buf.toString();
    }
}

