/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.aspose.exports.cell;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import net.xmind.verify.ui.VerifyUI20141031;
import net.xmind.verify.ui.VerifyWizardPage20141031;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.xmind.ui.internal.aspose.AsposePlugin;
import org.xmind.ui.internal.aspose.exports.ExportMessages;
import org.xmind.ui.internal.aspose.exports.cell.ExcelExportPageBase;
import org.xmind.ui.internal.aspose.exports.cell.ExcelExporter;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.wizards.DocumentExportWizard;
import org.xmind.ui.wizards.IExporter;

public class ODSExportWizard
extends DocumentExportWizard {
    private static final String PAGE_NAME = "org.xmind.ui.export.ODSExportPage";
    private static final String SECTION_NAME = "org.xmind.ui.export.ods";
    private static final String FILE_EXT = ".ods";
    private ODSExportPage page;

    public ODSExportWizard() {
        this.setWindowTitle(ExportMessages.ODSWizard_WindowTitle);
        this.setDialogSettings(AsposePlugin.getDialogSettings(SECTION_NAME));
        this.setDefaultPageImageDescriptor(MindMapUI.getImages().getWizBan("export_wiz.png"));
    }

    protected IExporter createExporter() {
        IMindMap mindmap = this.getSourceMindMap();
        ExcelExporter exporter = new ExcelExporter(mindmap.getSheet(), mindmap.getCentralTopic(), this.getTargetPath(), 14);
        exporter.setDialogSettings(this.getDialogSettings());
        exporter.init();
        return exporter;
    }

    protected void addValidPages() {
        this.addPage((IWizardPage)new VerifyWizardPage20141031("ExportToODS", ExportMessages.ODSExportJob_Name));
        this.page = new ODSExportPage();
        this.addPage((IWizardPage)this.page);
    }

    protected String getFormatName() {
        return ExportMessages.ODSWizard_FormatName;
    }

    protected boolean isExtensionCompatible(String path, String extension) {
        return super.isExtensionCompatible(path, extension) && FILE_EXT.equalsIgnoreCase(extension);
    }

    protected void handleExportException(Throwable e) {
        super.handleExportException(e);
        this.page.setErrorMessage(e.getLocalizedMessage());
    }

    protected String getSuggestedFileName() {
        return String.valueOf(super.getSuggestedFileName()) + FILE_EXT;
    }

    protected void doExport(IProgressMonitor monitor, Display display, Shell parentShell) throws InvocationTargetException, InterruptedException {
        VerifyUI20141031.getUsageDataCollector().increase("ExportToODSCount");
        super.doExport(monitor, display, parentShell);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ODSExportPage
    extends ExcelExportPageBase {
        public ODSExportPage() {
            super(ODSExportWizard.PAGE_NAME, ExportMessages.ODSPage_Title);
            this.setDescription(ExportMessages.ODSPage_Description);
        }

        protected void setDialogFilters(FileDialog dialog, List<String> filterNames, List<String> filterExtensions) {
            filterNames.add(0, ExportMessages.ODSPage_FilterName);
            filterExtensions.add(0, "*.ods");
            super.setDialogFilters(dialog, filterNames, filterExtensions);
        }
    }
}

