/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.command.remote;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.xmind.core.command.remote.ICommandServiceInfo;
import org.xmind.core.command.remote.IIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandServiceInfo
implements ICommandServiceInfo {
    private IIdentifier id = null;
    private String name = "";
    private Map<String, String> metadata = new HashMap<String, String>();

    public CommandServiceInfo() {
        this.metadata.put("ver", "1");
        IProduct product = Platform.getProduct();
        if (product != null) {
            this.metadata.put("cli", product.getName());
            this.metadata.put("cliid", product.getId());
            Bundle bundle = product.getDefiningBundle();
            if (bundle != null) {
                Version version = bundle.getVersion();
                this.metadata.put("cliver", String.format("%s.%s.%s", version.getMajor(), version.getMinor(), version.getMicro()));
                this.metadata.put("clibid", version.toString());
            }
        }
    }

    public CommandServiceInfo(ICommandServiceInfo source) {
        this.id = source.getId();
        this.name = source.getName();
        Iterator<String> keys = source.metadataKeys();
        while (keys.hasNext()) {
            String key = keys.next();
            this.metadata.put(key, source.getMetadata(key));
        }
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    @Override
    public IIdentifier getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public synchronized String getMetadata(String key) {
        return this.metadata.get(key);
    }

    @Override
    public synchronized Iterator<String> metadataKeys() {
        return new ArrayList<String>(this.metadata.keySet()).iterator();
    }

    public void setId(IIdentifier id) {
        this.id = id;
    }

    public void setName(String name) {
        if (name == null) {
            name = "";
        }
        this.name = name;
    }

    public void setMetadata(String key, String value) {
        if (value == null) {
            this.metadata.remove(key);
        } else {
            this.metadata.put(key, value);
        }
    }

    protected Map<String, String> getMetadataImpl() {
        return this.metadata;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CommandServiceInfo{id=");
        sb.append(this.id);
        sb.append(",name=");
        sb.append(this.name);
        sb.append(",metadata=");
        sb.append(this.metadata);
        sb.append('}');
        return sb.toString();
    }
}

