/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.xmind.core.ITopic;
import org.xmind.gef.GEF;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.command.Command;
import org.xmind.gef.draw2d.ChopBoxAnchor;
import org.xmind.gef.draw2d.IAnchor;
import org.xmind.gef.event.MouseEvent;
import org.xmind.gef.part.IPart;
import org.xmind.ui.gantt.GanttMessages;
import org.xmind.ui.gantt2.gefext.AbstractDragTracker;
import org.xmind.ui.gantt2.gefext.HandleFigure;
import org.xmind.ui.gantt2.gefext.IBoundingPathProvider;
import org.xmind.ui.gantt2.gefext.IConnectionRouter;
import org.xmind.ui.gantt2.gefext.IEditPart;
import org.xmind.ui.gantt2.gefext.ITracker;
import org.xmind.ui.gantt2.gefext.PathDescriptor;
import org.xmind.ui.gantt2.gefext.SelectionFeedback;
import org.xmind.ui.gantt2.viewer.Colors;
import org.xmind.ui.gantt2.viewer.DependencyArrowDecoration;
import org.xmind.ui.gantt2.viewer.DependencyFigure;
import org.xmind.ui.gantt2.viewer.TargetSelectionFeedbackFigure;
import org.xmind.ui.gantt2.viewer.TaskBarPart;
import org.xmind.ui.internal.taskinfo.Dependency;
import org.xmind.ui.internal.taskinfo.TaskInfoUtils;

public class TaskBarDependencyAnchorsFeedback
extends SelectionFeedback {
    private static final String LOCATION = "location";
    private static final String CONNECTION = "connection";
    private static final String ANCHOR = "anchor";
    private static final String DUMMY_TARGET = "dummyTarget";
    private static final String DUMMY_ANCHOR = "dummyAnchor";
    private static final String TARGET_PART = "targetPart";
    private static final String SOURCE_ORIENTATION = "sourceOrientation";
    private static final String TARGET_ORIENTATION = "targetOrientation";
    private static final String SEARCH_CONDITION = "searchCondition";
    private static final String REQUEST = "request";
    private ITracker dependencyCreateTracker;
    private IFigure startAnchor;
    private IFigure finishAnchor;
    private TargetSelectionFeedbackFigure anchorSelectionFeedback;
    private boolean showingSourceFeedback = false;

    public TaskBarPart getHost() {
        return (TaskBarPart)super.getHost();
    }

    protected IFigure getMainFigure() {
        return this.getHost().getBarFigure();
    }

    public void activate() {
        super.activate();
        this.startAnchor = new TaskBarAnchorFigure(this.getMainFigure(), 8);
        this.registerHandle(this.startAnchor, GEF.LAYER_HANDLE);
        this.finishAnchor = new TaskBarAnchorFigure(this.getMainFigure(), 16);
        this.registerHandle(this.finishAnchor, GEF.LAYER_HANDLE);
        this.anchorSelectionFeedback = new TargetSelectionFeedbackFigure();
        this.registerHandle((IFigure)this.anchorSelectionFeedback, GEF.LAYER_FEEDBACK);
    }

    protected void onPreselected() {
        super.onPreselected();
        if (this.isMainFigureAvailable()) {
            this.activateHandles(this.startAnchor, this.finishAnchor);
        }
    }

    private boolean isMainFigureAvailable() {
        return this.getMainFigure().isVisible();
    }

    protected void onDepreselected() {
        if (!this.showingSourceFeedback) {
            this.deactivateHandles(this.startAnchor, this.finishAnchor);
        }
        super.onDepreselected();
    }

    public Cursor findCursor(Point point) {
        if (this.isMainFigureAvailable() && this.isOverHandle(point, this.startAnchor, this.finishAnchor)) {
            return Cursors.HAND;
        }
        return super.findCursor(point);
    }

    protected int getConnectionOrientation(Point point) {
        if (this.isMainFigureAvailable()) {
            if (this.isOverHandle(point, this.startAnchor)) {
                return ((TaskBarAnchorFigure)this.startAnchor).getOrientation();
            }
            if (this.isOverHandle(point, this.finishAnchor)) {
                return ((TaskBarAnchorFigure)this.finishAnchor).getOrientation();
            }
        }
        return 0;
    }

    public ITracker findTracker(Point point) {
        if (this.isMainFigureAvailable() && this.isOverHandle(point, this.startAnchor, this.finishAnchor)) {
            if (this.dependencyCreateTracker == null) {
                this.dependencyCreateTracker = new TaskBarDependencyCreateTracker();
            }
            return this.dependencyCreateTracker;
        }
        return super.findTracker(point);
    }

    public void update(Object property) {
        super.update(property);
        if (this.isMainFigureAvailable() && this.getHost().getStatus().isPreSelected()) {
            this.activateHandles(this.startAnchor, this.finishAnchor);
        }
    }

    public boolean containsPoint(Point point) {
        return super.containsPoint(point) || this.isMainFigureAvailable() && this.isOverHandle(point, this.startAnchor, this.finishAnchor);
    }

    public void showTargetFeedback(Request request) {
        String type = request.getType();
        if ("select".equals(type)) {
            if (this.shouldShowSelectionFeedback(request)) {
                this.showSelectionFeedback((Point)request.getParameter("position"));
            } else {
                this.hideSelectionFeedback();
            }
        } else if ("connect".equals(type)) {
            this.activateHandles(this.startAnchor, this.finishAnchor);
            this.showSelectionFeedback(request.getIntParameter(TARGET_ORIENTATION, 8));
        } else {
            super.showTargetFeedback(request);
        }
    }

    private boolean shouldShowSelectionFeedback(Request request) {
        Point point = (Point)request.getParameter("position");
        return point != null && this.containsPoint(point);
    }

    public void hideTargetFeedback(Request request) {
        String type = request.getType();
        if ("select".equals(type)) {
            this.hideSelectionFeedback();
        } else if ("connect".equals(type)) {
            this.deactivateHandles(this.startAnchor, this.finishAnchor);
            this.hideSelectionFeedback();
        } else {
            super.hideTargetFeedback(request);
        }
    }

    private void showSelectionFeedback(Point point) {
        if (this.isOverHandle(point, this.startAnchor)) {
            this.anchorSelectionFeedback.setHost(this.startAnchor);
        } else {
            this.anchorSelectionFeedback.setHost(this.finishAnchor);
        }
        this.activateHandles(new IFigure[]{this.anchorSelectionFeedback});
    }

    private void showSelectionFeedback(int orientation) {
        if (orientation == 8) {
            this.anchorSelectionFeedback.setHost(this.startAnchor);
        } else {
            this.anchorSelectionFeedback.setHost(this.finishAnchor);
        }
        this.activateHandles(new IFigure[]{this.anchorSelectionFeedback});
    }

    private void hideSelectionFeedback() {
        this.deactivateHandles(new IFigure[]{this.anchorSelectionFeedback});
        this.anchorSelectionFeedback.setHost(null);
    }

    public void showSourceFeedback(Request request) {
        String type = request.getType();
        if ("connect".equals(type)) {
            this.activateHandles(this.startAnchor, this.finishAnchor);
            this.showSelectionFeedback(request.getIntParameter(SOURCE_ORIENTATION, 16));
            this.showingSourceFeedback = true;
        } else {
            super.showSourceFeedback(request);
        }
    }

    public void hideSourceFeedback(Request request) {
        String type = request.getType();
        if ("connect".equals(type)) {
            this.showingSourceFeedback = false;
            this.hideSelectionFeedback();
            this.deactivateHandles(this.startAnchor, this.finishAnchor);
        } else {
            super.hideSourceFeedback(request);
        }
    }

    private static class TaskBarAnchorFigure
    extends HandleFigure
    implements IBoundingPathProvider {
        private int orientation;
        private PathDescriptor outline;
        private PathDescriptor fill;

        public TaskBarAnchorFigure(IFigure host, int orientation) {
            this.orientation = orientation;
            this.setHost(host);
            this.setForegroundColor(Colors.moveHandleBorder());
            this.setBackgroundColor(Colors.moveHandleBackground());
        }

        public int getOrientation() {
            return this.orientation;
        }

        protected void calculateBounds(Rectangle source, Rectangle target) {
            this.outline = new PathDescriptor();
            this.fill = new PathDescriptor();
            target.width = 22;
            target.y = source.y;
            target.height = source.height;
            double y1 = (double)target.y + (double)target.height * 0.5;
            double y2 = (double)target.y + (double)(target.height - 5) * 0.5;
            if (this.orientation == 8) {
                target.x = source.x - 22;
                this.outline.addEllipse(target.x + 4, y2, 5.0, 5.0).moveTo(target.x + 9, y1).lineTo(target.x + target.width, y1);
                this.fill.addEllipse(target.x + 4, y2, 6.0, 6.0);
            } else {
                target.x = source.x + source.width;
                this.outline.addEllipse(target.x + target.width - 10, y2, 5.0, 5.0).moveTo(target.x - 1, y1).lineTo(target.x + target.width - 10, y1);
                this.fill.addEllipse(target.x + target.width - 10, y2, 6.0, 6.0);
            }
        }

        protected void paintFigure(Graphics graphics) {
            Path path;
            super.paintFigure(graphics);
            if (this.fill != null) {
                path = new Path((Device)Display.getCurrent());
                try {
                    this.fill.applyTo(path);
                    graphics.fillPath(path);
                }
                finally {
                    path.dispose();
                }
            }
            if (this.outline != null) {
                path = new Path((Device)Display.getCurrent());
                try {
                    this.outline.applyTo(path);
                    graphics.drawPath(path);
                }
                finally {
                    path.dispose();
                }
            }
        }

        public PathDescriptor getBoundingPath() {
            return this.outline;
        }
    }

    private class TaskBarDependencyCreateTracker
    extends AbstractDragTracker {
        private IViewer.IPartSearchCondition taskBarSearchCondition = new IViewer.IPartSearchCondition(){

            public boolean evaluate(IPart part) {
                return part instanceof TaskBarPart && part != TaskBarDependencyAnchorsFeedback.this.getHost();
            }
        };

        private TaskBarDependencyCreateTracker() {
        }

        protected void applyStatus(AbstractDragTracker.Status status) {
            ((IFigure)status.get(TaskBarDependencyAnchorsFeedback.DUMMY_TARGET)).setLocation((Point)status.get(TaskBarDependencyAnchorsFeedback.LOCATION));
            DependencyFigure connection = (DependencyFigure)status.get(TaskBarDependencyAnchorsFeedback.CONNECTION);
            connection.setTargetAnchor((IAnchor)status.get(TaskBarDependencyAnchorsFeedback.ANCHOR));
            connection.setTargetOrientation(status.getInteger(TaskBarDependencyAnchorsFeedback.TARGET_ORIENTATION, 8));
        }

        protected void restoreStatus(AbstractDragTracker.Status initStatus) {
            Request request;
            IPart targetPart;
            TaskBarDependencyAnchorsFeedback.this.getHost().getSite().getViewer().setPartSearchCondition((IViewer.IPartSearchCondition)initStatus.get(TaskBarDependencyAnchorsFeedback.SEARCH_CONDITION));
            DependencyFigure connection = (DependencyFigure)initStatus.get(TaskBarDependencyAnchorsFeedback.CONNECTION);
            if (connection != null) {
                if (connection.getParent() != null) {
                    connection.getParent().remove((IFigure)connection);
                }
                connection.setConnectionRouter(null);
                connection.setSourceAnchor(null);
                connection.setTargetAnchor(null);
            }
            TaskBarDependencyAnchorsFeedback.this.getHost().hideSourceFeedback((Request)initStatus.get(TaskBarDependencyAnchorsFeedback.REQUEST));
            AbstractDragTracker.Status status = this.getCurrentStatus();
            if (status != null && (targetPart = (IPart)status.get(TaskBarDependencyAnchorsFeedback.TARGET_PART)) != null && targetPart instanceof IEditPart && (request = (Request)status.get(TaskBarDependencyAnchorsFeedback.REQUEST)) != null) {
                ((IEditPart)targetPart).hideTargetFeedback(request);
            }
        }

        protected boolean captureInitialStatus(MouseEvent me, AbstractDragTracker.Status status) {
            Point cursorLocation = me.cursorLocation;
            int sourceOrientation = TaskBarDependencyAnchorsFeedback.this.getConnectionOrientation(cursorLocation);
            if (sourceOrientation == 0) {
                return false;
            }
            int targetOrientation = 8;
            status.set((Object)TaskBarDependencyAnchorsFeedback.LOCATION, new Point(cursorLocation));
            status.set((Object)TaskBarDependencyAnchorsFeedback.SOURCE_ORIENTATION, sourceOrientation);
            status.set((Object)TaskBarDependencyAnchorsFeedback.TARGET_ORIENTATION, targetOrientation);
            Figure dummyTarget = new Figure();
            dummyTarget.setPreferredSize(new Dimension());
            dummyTarget.setSize(dummyTarget.getPreferredSize());
            dummyTarget.setLocation(cursorLocation);
            status.set((Object)TaskBarDependencyAnchorsFeedback.DUMMY_TARGET, dummyTarget);
            ChopBoxAnchor dummyAnchor = new ChopBoxAnchor((IFigure)dummyTarget);
            status.set((Object)TaskBarDependencyAnchorsFeedback.DUMMY_ANCHOR, dummyAnchor);
            status.set((Object)TaskBarDependencyAnchorsFeedback.ANCHOR, dummyAnchor);
            DependencyFigure connection = new DependencyFigure();
            connection.setForegroundColor(Colors.dummyDependency());
            connection.setAlpha(170);
            connection.setLineWidth(2);
            DependencyArrowDecoration arrow = new DependencyArrowDecoration();
            arrow.setForegroundColor(Colors.dummyDependency());
            connection.add(arrow);
            arrow.setHost(connection);
            connection.setSourceOrientation(sourceOrientation);
            connection.setTargetOrientation(targetOrientation);
            connection.setSourceAnchor(TaskBarDependencyAnchorsFeedback.this.getHost().getSourceAnchor(null));
            connection.setTargetAnchor((IAnchor)dummyAnchor);
            connection.setConnectionRouter((IConnectionRouter)TaskBarDependencyAnchorsFeedback.this.getHost().getSite().getRoot().getAdapter(IConnectionRouter.class));
            TaskBarDependencyAnchorsFeedback.this.getLayer(GEF.LAYER_HANDLE).add((IFigure)connection);
            status.set((Object)TaskBarDependencyAnchorsFeedback.CONNECTION, connection);
            status.set((Object)TaskBarDependencyAnchorsFeedback.TARGET_PART, null);
            IViewer viewer = TaskBarDependencyAnchorsFeedback.this.getHost().getSite().getViewer();
            status.set((Object)TaskBarDependencyAnchorsFeedback.SEARCH_CONDITION, viewer.getPartSearchCondition());
            viewer.setPartSearchCondition(this.taskBarSearchCondition);
            Request request = new Request("connect");
            request.setDomain(this.getEditDomain());
            request.setViewer(TaskBarDependencyAnchorsFeedback.this.getHost().getSite().getViewer());
            request.setParameter("position", (Object)new Point(cursorLocation));
            request.setParameter("source", (Object)TaskBarDependencyAnchorsFeedback.this.getHost());
            request.setParameter(TaskBarDependencyAnchorsFeedback.SOURCE_ORIENTATION, (Object)sourceOrientation);
            request.setParameter(TaskBarDependencyAnchorsFeedback.TARGET_ORIENTATION, (Object)targetOrientation);
            TaskBarDependencyAnchorsFeedback.this.getHost().showSourceFeedback(request);
            status.set((Object)TaskBarDependencyAnchorsFeedback.REQUEST, request);
            return true;
        }

        protected Command getCommand(AbstractDragTracker.Status initStatus, AbstractDragTracker.Status status) {
            ITopic predecessor;
            TaskBarPart targetPart = (TaskBarPart)status.get(TaskBarDependencyAnchorsFeedback.TARGET_PART);
            if (targetPart == null) {
                return null;
            }
            ITopic successor = targetPart.getTask();
            if (!this.passesDependencyConflictCheck(successor, predecessor = TaskBarDependencyAnchorsFeedback.this.getHost().getTask())) {
                return null;
            }
            int sourceOrientation = status.getInteger(TaskBarDependencyAnchorsFeedback.SOURCE_ORIENTATION, 16);
            int targetOrientation = status.getInteger(TaskBarDependencyAnchorsFeedback.TARGET_ORIENTATION, 8);
            String type = sourceOrientation == 16 ? (targetOrientation == 8 ? "FS" : "FF") : (targetOrientation == 8 ? "SS" : "SF");
            return TaskInfoUtils.createAddDependencyCommand((ITopic)successor, (ITopic)predecessor, (String)type);
        }

        protected boolean updateStatus(MouseEvent me, AbstractDragTracker.Status initStatus, AbstractDragTracker.Status status) {
            int orientation;
            Request request = (Request)status.get(TaskBarDependencyAnchorsFeedback.REQUEST);
            IPart oldTarget = (IPart)status.get(TaskBarDependencyAnchorsFeedback.TARGET_PART);
            if (oldTarget != null && oldTarget instanceof IEditPart && request != null) {
                ((IEditPart)oldTarget).hideTargetFeedback(request);
            }
            IPart target = me.target;
            Point cursorLocation = me.cursorLocation;
            Object anchor = status.get(TaskBarDependencyAnchorsFeedback.DUMMY_ANCHOR);
            int n = orientation = target instanceof TaskBarPart ? ((TaskBarPart)target).getConnectionOrientation(cursorLocation) : 0;
            if (orientation == 0) {
                target = null;
                request = null;
            } else {
                status.set((Object)TaskBarDependencyAnchorsFeedback.TARGET_ORIENTATION, orientation);
                TaskBarPart taskBarPart = (TaskBarPart)target;
                anchor = taskBarPart.getTargetAnchor(null);
                request = new Request("connect");
                request.setDomain(this.getEditDomain());
                request.setViewer(TaskBarDependencyAnchorsFeedback.this.getHost().getSite().getViewer());
                request.setPrimaryTarget(target);
                request.setParameter("position", (Object)new Point(cursorLocation));
                request.setParameter("source", (Object)TaskBarDependencyAnchorsFeedback.this.getHost());
                request.setParameter(TaskBarDependencyAnchorsFeedback.SOURCE_ORIENTATION, initStatus.get(TaskBarDependencyAnchorsFeedback.SOURCE_ORIENTATION));
                request.setParameter(TaskBarDependencyAnchorsFeedback.TARGET_ORIENTATION, (Object)orientation);
                taskBarPart.showTargetFeedback(request);
            }
            status.set((Object)TaskBarDependencyAnchorsFeedback.LOCATION, new Point(cursorLocation));
            status.set((Object)TaskBarDependencyAnchorsFeedback.ANCHOR, anchor);
            status.set((Object)TaskBarDependencyAnchorsFeedback.TARGET_PART, target);
            status.set((Object)TaskBarDependencyAnchorsFeedback.REQUEST, request);
            return true;
        }

        private boolean passesDependencyConflictCheck(ITopic task, ITopic predecessor) {
            if (task == predecessor) {
                return false;
            }
            if (this.dependencyExists(task, predecessor)) {
                this.alertConflict(GanttMessages.TaskBarDependencyAnchorsFeedback_DuplicatedDependency_warning);
                return false;
            }
            if (TaskInfoUtils.isCircularDependencies((ITopic)task, (ITopic)predecessor)) {
                this.alertConflict(GanttMessages.TaskBarDependencyAnchorsFeedback_CircularDependencies_warning);
                return false;
            }
            return true;
        }

        private void alertConflict(String message) {
            MessageDialog.openWarning((Shell)TaskBarDependencyAnchorsFeedback.this.getHost().getSite().getShell(), (String)GanttMessages.TaskBarDependencyAnchorsFeedback_InvalidDependencyDialog_windowTitle, (String)message);
        }

        private boolean dependencyExists(ITopic task, ITopic predecessor) {
            for (Dependency dependency : TaskInfoUtils.getDependencies((ITopic)task)) {
                if (dependency.getPredecessor() != predecessor) continue;
                return true;
            }
            return false;
        }

        public boolean handleMouseEntered(MouseEvent me, IViewer viewer) {
            if (viewer != TaskBarDependencyAnchorsFeedback.this.getHost().getSite().getViewer()) {
                return true;
            }
            if (me.target != null && me.target.hasRole("selectable role")) {
                viewer.setPreselected((Object)me.target);
            }
            return true;
        }

        public boolean handleMouseExited(MouseEvent me, IViewer viewer) {
            if (viewer != TaskBarDependencyAnchorsFeedback.this.getHost().getSite().getViewer()) {
                return true;
            }
            if (me.target != null && me.target == viewer.getPreselectedPart()) {
                viewer.setPreselected(null);
            }
            return true;
        }

        public Cursor getCurrentCursor(Point pos, IPart host) {
            return Cursors.HAND;
        }
    }
}

