/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IPartFactory;
import org.xmind.gef.part.IRootPart;
import org.xmind.ui.gantt2.gefext.GraphicalViewer2;
import org.xmind.ui.gantt2.viewer.Colors;
import org.xmind.ui.gantt2.viewer.GanttViewer;
import org.xmind.ui.gantt2.viewer.TaskTreePartFactory;
import org.xmind.ui.gantt2.viewer.TaskTreeRootPart;
import org.xmind.ui.gantt2.viewer.TaskTreeWidthsSupport;

public class TaskTreeViewer
extends GraphicalViewer2
implements PropertyChangeListener {
    public static final Object LAYER_BACKGROUND_LINE = "org.xmind.ui.gantt.layer.backgroundLine";
    public static final Object LAYER_BACKGROUND_ITEM = "org.xmind.ui.gantt.layer.backgroundItem";
    private TaskTreeWidthsSupport widthsSupport;
    private GanttViewer ganttViewer;
    private SplitBar[] splits;
    private PropertyChangeListener itemsChangeListener;
    private int height;

    public void setHeight(int height) {
        if (height != this.height) {
            this.height = height;
            this.getCanvas().layout();
        }
    }

    public TaskTreeViewer(TaskTreeWidthsSupport widthsSupport, GanttViewer ganttViewer) {
        this.widthsSupport = widthsSupport;
        this.ganttViewer = ganttViewer;
        this.setPartFactory(TaskTreePartFactory.DEFAULT);
        this.setRootPart((IRootPart)new TaskTreeRootPart());
        widthsSupport.addPropertyChangeListener(this);
        widthsSupport.addItemsChangeListener(this.getItemsChangeListener());
    }

    protected Control internalCreateControl(Composite parent, int style) {
        final FigureCanvas canvas = (FigureCanvas)super.internalCreateControl(parent, style);
        canvas.setVerticalScrollBarVisibility(FigureCanvas.NEVER);
        canvas.setHorizontalScrollBarVisibility(FigureCanvas.ALWAYS);
        this.addSplitBars(canvas);
        canvas.getViewport().getVerticalRangeModel().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                canvas.layout();
            }
        });
        canvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TaskTreeViewer.this.widthsSupport.removePropertyChangeListener(TaskTreeViewer.this);
                TaskTreeViewer.this.widthsSupport.removeItemsChangeListener(TaskTreeViewer.this.getItemsChangeListener());
            }
        });
        return canvas;
    }

    protected IPart createContents(IRootPart root, Object input) {
        IPartFactory factory = this.getPartFactory();
        if (input == null || factory == null) {
            return null;
        }
        if (factory instanceof TaskTreePartFactory) {
            return ((TaskTreePartFactory)factory).createPart((IPart)root, input, this.ganttViewer);
        }
        return factory.createPart((IPart)root, input);
    }

    public void update() {
        this.getCanvas().forceFocus();
        this.setInput(this.getInput());
    }

    private void addSplitBars(FigureCanvas canvas) {
        this.splits = new SplitBar[this.widthsSupport.getSize()];
        canvas.setLayout((Layout)new SplitsLayout());
        int i = 0;
        while (i < this.splits.length) {
            this.splits[i] = new SplitBar((Composite)canvas, 0);
            this.splits[i].getControl().setBackground(Colors.split());
            this.splits[i].setWidth(this.widthsSupport.getWidth(i));
            ++i;
        }
    }

    private void refreshWidths() {
        int i = 0;
        while (i < this.splits.length) {
            this.widthsSupport.setWidth(i, this.splits[i].width);
            ++i;
        }
    }

    public void refreshSplitWidths() {
        int i = 0;
        while (i < this.splits.length) {
            this.splits[i].setWidth(this.widthsSupport.getWidth(i));
            ++i;
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.refreshSplitWidths();
        if (this.getCanvas() != null && !this.getCanvas().isDisposed()) {
            this.getCanvas().layout();
        }
    }

    private void update2() {
        Control[] children;
        Control[] controlArray = children = this.getCanvas().getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        this.addSplitBars(this.getCanvas());
        this.update();
        this.getCanvas().layout();
    }

    public TaskTreeWidthsSupport getWidthsSupport() {
        return this.widthsSupport;
    }

    public PropertyChangeListener getItemsChangeListener() {
        if (this.itemsChangeListener == null) {
            this.itemsChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    TaskTreeViewer.this.update2();
                }
            };
        }
        return this.itemsChangeListener;
    }

    private class SplitBar
    implements Listener {
        private Control control;
        private org.eclipse.swt.graphics.Point start = null;
        private int width;
        private int startWidth;

        public SplitBar(Composite parent, int style) {
            this.control = new Composite(parent, style);
            this.hook(this.control);
        }

        public Control getControl() {
            return this.control;
        }

        private void hook(Control control) {
            control.setCursor(control.getDisplay().getSystemCursor(9));
            control.addListener(3, (Listener)this);
            control.addListener(5, (Listener)this);
            control.addListener(4, (Listener)this);
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 3: {
                    this.handleMouseDown(event);
                    break;
                }
                case 5: {
                    this.handleMouseMove(event);
                    break;
                }
                case 4: {
                    this.handleMouseUp(event);
                }
            }
        }

        private void handleMouseDown(Event e) {
            this.start = this.getCursorPosition(e);
            this.startWidth = this.width;
        }

        private void handleMouseUp(Event e) {
            this.start = null;
            this.startWidth = 0;
        }

        private void handleMouseMove(Event e) {
            if (this.start == null) {
                return;
            }
            org.eclipse.swt.graphics.Point p = this.getCursorPosition(e);
            this.setWidth(Math.max(3, p.x - this.start.x + this.startWidth));
            TaskTreeViewer.this.refreshWidths();
        }

        private org.eclipse.swt.graphics.Point getCursorPosition(Event e) {
            return ((Control)e.widget).toDisplay(e.x, e.y);
        }

        public void setWidth(int width) {
            this.width = width;
        }
    }

    private class SplitsLayout
    extends Layout {
        private SplitsLayout() {
        }

        protected org.eclipse.swt.graphics.Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            return composite.computeSize(wHint, hHint, flushCache);
        }

        protected void layout(Composite composite, boolean flushCache) {
            Viewport viewport = ((FigureCanvas)composite).getViewport();
            Point origin = new Point();
            if (viewport != null) {
                origin = viewport.getViewLocation();
            }
            int y = composite.getClientArea().y;
            int i = 0;
            while (i < TaskTreeViewer.this.splits.length) {
                TaskTreeViewer.this.splits[i].getControl().setBounds(TaskTreeViewer.this.widthsSupport.sum(i) - origin.x, y, 1, TaskTreeViewer.this.height);
                ++i;
            }
            viewport.invalidateTree();
            viewport.validate();
        }
    }
}

