/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mapshot;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.ui.internal.editor.MindMapEditor;
import org.xmind.ui.internal.mapshot.Button;
import org.xmind.ui.internal.mapshot.Messages;
import org.xmind.ui.internal.mapshot.TransparentCornerLabel;
import org.xmind.ui.mindmap.MindMapUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapShotTemporaryStorage {
    private TransparentCornerLabel sizeLabel;
    static final String ID_SAVE = "Save";
    static final String ID_CANCEL = "Cancel";
    static final String ID_COPY = "Copy";
    private Map<String, Button> buttonsMap = new HashMap<String, Button>();

    public TransparentCornerLabel getSizeLabel() {
        return this.sizeLabel;
    }

    public void setSizeLabel(TransparentCornerLabel sizeLabel) {
        this.sizeLabel = sizeLabel;
    }

    public void putButton(String id, Button button) {
        this.buttonsMap.put(id, button);
    }

    public Button getEnsureButton(String id) {
        Button button = this.buttonsMap.get(id);
        if (button == null) {
            button = this.createButton(id);
        }
        return button;
    }

    private Button createButton(String id) {
        if (ID_CANCEL.equals(id)) {
            return this.createButtonFromStorage(id, Messages.MapShotTemporaryStorage_Button_Cancel);
        }
        if (ID_SAVE.equals(id)) {
            return this.createButtonFromStorage(id, Messages.MapShotTemporaryStorage_Button_Save);
        }
        if (ID_COPY.equals(id)) {
            return this.createButtonFromStorage(id, Messages.MapShotTemporaryStorage_Button_Copy);
        }
        return null;
    }

    private Button createButtonFromStorage(String id, String text) {
        Layer layer = this.getLayer(MindMapUI.LAYER_SKYLIGHT);
        Button button = new Button(id, text, null);
        layer.add((IFigure)button);
        this.putButton(id, button);
        return button;
    }

    private Layer getLayer(Object key) {
        IGraphicalViewer viewer = this.getGraphicalViewer();
        return viewer == null ? null : viewer.getLayer(key);
    }

    private IGraphicalViewer getGraphicalViewer() {
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor instanceof MindMapEditor) {
            return ((MindMapEditor)editor).getActivePageInstance().getViewer();
        }
        return null;
    }

    public Map<String, Button> getMaps() {
        return this.buttonsMap;
    }
}

