/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.presentation;

import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.Viewport;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ScrollBar;
import org.xmind.gef.EditDomain;
import org.xmind.gef.GEF;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.draw2d.IRelayeredPane;
import org.xmind.gef.draw2d.ISkylightLayer;
import org.xmind.gef.service.FeedbackService;
import org.xmind.gef.service.IFeedbackService;
import org.xmind.gef.service.IRevealService;
import org.xmind.gef.service.IShadowService;
import org.xmind.gef.service.IViewerService;
import org.xmind.gef.service.ShadowService;
import org.xmind.gef.util.Properties;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.TopicContextService;
import org.xmind.ui.internal.layers.SkylightLayer;
import org.xmind.ui.internal.mindmap.DrillDownTraceService;
import org.xmind.ui.internal.mindmap.MindMapRevealService;
import org.xmind.ui.internal.mindmap.MindMapViewer;
import org.xmind.ui.internal.mindmap.filtering.FilterService;
import org.xmind.ui.internal.mindmap.filtering.IPropertyFilterListener;
import org.xmind.ui.internal.mindmap.filtering.PropertyFilter;
import org.xmind.ui.internal.presentation.AbstractPresentationWindows;
import org.xmind.ui.internal.presentation.HideCursorService;
import org.xmind.ui.internal.presentation.IPresentationPage;
import org.xmind.ui.internal.presentation.NavigationHistory;
import org.xmind.ui.internal.presentation.NavigationHistoryService;
import org.xmind.ui.internal.presentation.PresentationEditDomain;
import org.xmind.ui.internal.presentation.PresentationHighlightService;
import org.xmind.ui.internal.presentation.PresentationTopicContextService;
import org.xmind.ui.internal.presentation.PresentationViewer;
import org.xmind.ui.mindmap.IDrillDownTraceService;
import org.xmind.ui.mindmap.IHighlightService;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.ColorUtils;

public class PresentationPage
implements IPresentationPage,
IColorProvider,
IPropertyFilterListener {
    private AbstractPresentationWindows window;
    private MindMapViewer viewer;
    private IMindMap input;
    private EditDomain editDomain;
    private NavigationHistory history;
    private IHighlightService highlightService;
    private NavigationHistoryService historyService;
    private FilterService filterService;
    private IRevealService revealService;

    public PresentationPage(AbstractPresentationWindows window, IMindMap input, Properties properties) {
        this(window, input, properties, new PresentationEditDomain());
    }

    public PresentationPage(AbstractPresentationWindows window, IMindMap input, Properties properties, EditDomain editDomain) {
        this.window = window;
        this.input = input;
        this.viewer = new PresentationViewer();
        this.viewer.setProperties(properties);
        this.editDomain = editDomain;
        Assert.isNotNull((Object)editDomain);
        this.editDomain.setCommandStack(window.getSourceEditor().getCommandStack());
        this.history = new NavigationHistory();
        this.initViewer();
    }

    public IMindMap getInput() {
        return this.input;
    }

    private void initViewer() {
        this.viewer.getZoomManager().setConstraints(0.1, 5.0);
        this.installServices();
        this.viewer.setEditDomain(this.editDomain);
    }

    public void createControl(Composite parent) {
        this.viewer.createControl(parent);
        FigureCanvas canvas = this.viewer.getCanvas();
        canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        canvas.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16 || e.detail == 8) {
                    e.doit = false;
                } else if (e.detail == 2) {
                    e.doit = PresentationPage.this.window.canHandleShellCloseEvent();
                }
            }
        });
        this.installScrollListener();
        this.viewer.setInput((Object)this.input);
    }

    private void installServices() {
        Layer shadowLayer;
        this.historyService = new NavigationHistoryService((IViewer)this.viewer, true);
        this.historyService.setHistory(this.history);
        this.viewer.installService(NavigationHistoryService.class, (IViewerService)this.historyService);
        this.historyService.setActive(true);
        HideCursorService hideCursorService = new HideCursorService((IViewer)this.viewer);
        this.viewer.installService(HideCursorService.class, (IViewerService)hideCursorService);
        hideCursorService.setActive(true);
        MindMapRevealService revealService = new MindMapRevealService((IGraphicalViewer)this.viewer);
        revealService.setCentered(true);
        revealService.setZoomed(true);
        revealService.setAnimationEnabled(true);
        revealService.setDuration(400);
        this.viewer.installService(IRevealService.class, (IViewerService)revealService);
        revealService.setActive(true);
        this.revealService = revealService;
        Layer coverLayer = this.viewer.getLayer(MindMapUI.LAYER_COVER);
        Layer highlightLayer = this.viewer.getLayer(MindMapUI.LAYER_SKYLIGHT);
        if (coverLayer instanceof IRelayeredPane || highlightLayer instanceof ISkylightLayer) {
            this.highlightService = new PresentationHighlightService((IGraphicalViewer)this.viewer, true);
            if (coverLayer instanceof IRelayeredPane) {
                this.highlightService.setRelayeredPane((IRelayeredPane)coverLayer);
            }
            if (highlightLayer instanceof ISkylightLayer) {
                this.highlightService.setHighlightLayer((ISkylightLayer)((SkylightLayer)highlightLayer));
            }
            this.viewer.installService(IHighlightService.class, (IViewerService)this.highlightService);
            this.highlightService.setActive(true);
        }
        this.filterService = new FilterService((IGraphicalViewer)this.viewer);
        this.filterService.addFilterListener((IPropertyFilterListener)this);
        this.viewer.installService(FilterService.class, (IViewerService)this.filterService);
        this.filterService.setActive(true);
        DrillDownTraceService traceService = new DrillDownTraceService((IGraphicalViewer)this.viewer);
        this.viewer.installService(IDrillDownTraceService.class, (IViewerService)traceService);
        traceService.setActive(true);
        Layer feedbackLayer = this.viewer.getLayer(GEF.LAYER_FEEDBACK);
        if (feedbackLayer != null) {
            FeedbackService feedbackService = new FeedbackService((IGraphicalViewer)this.viewer);
            this.viewer.installService(IFeedbackService.class, (IViewerService)feedbackService);
            feedbackService.setLayer((IFigure)feedbackLayer);
            feedbackService.setSelectionColorProvider((IColorProvider)this);
            feedbackService.setSelectionLineWidth(4);
            feedbackService.setSelectionCorner(5);
            feedbackService.setActive(true);
        }
        if (MindMapUIPlugin.getDefault().getPreferenceStore().getBoolean("shadowEnabled") && (shadowLayer = this.viewer.getLayer(GEF.LAYER_SHADOW)) != null) {
            ShadowService shadowService = new ShadowService((IGraphicalViewer)this.viewer);
            this.viewer.installService(IShadowService.class, (IViewerService)shadowService);
            shadowService.setLayer((IFigure)shadowLayer);
            shadowService.setActive(true);
        }
        PresentationTopicContextService topicContextService = new PresentationTopicContextService((IViewer)this.viewer, this.window);
        this.viewer.installService(TopicContextService.class, (IViewerService)topicContextService);
        topicContextService.setActive(true);
    }

    private void installScrollListener() {
        FigureCanvas canvas = this.viewer.getCanvas();
        final ScrollBar horizontalBar = canvas.getHorizontalBar();
        horizontalBar.removeListener(13, horizontalBar.getListeners(13)[0]);
        horizontalBar.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Viewport viewport = PresentationPage.this.viewer.getCanvas().getViewport();
                RangeModel model = viewport.getHorizontalRangeModel();
                int hBarOffset = Math.max(0, -model.getMinimum());
                int hOffset = horizontalBar.getSelection() - hBarOffset;
                hOffset = this.verifyScrollBarOffset(model, hOffset);
                viewport.setHorizontalLocation(hOffset);
            }

            private int verifyScrollBarOffset(RangeModel model, int value) {
                value = Math.max(model.getMinimum(), value);
                return Math.min(model.getMaximum() - model.getExtent(), value);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final ScrollBar vBar = canvas.getVerticalBar();
        vBar.removeListener(13, vBar.getListeners(13)[0]);
        vBar.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Viewport viewport = PresentationPage.this.viewer.getCanvas().getViewport();
                RangeModel model = viewport.getVerticalRangeModel();
                int vBarOffset = Math.max(0, -model.getMinimum());
                int vOffset = vBar.getSelection() - vBarOffset;
                vOffset = this.verifyScrollBarOffset(model, vOffset);
                viewport.setVerticalLocation(vOffset);
            }

            private int verifyScrollBarOffset(RangeModel model, int value) {
                value = Math.max(model.getMinimum(), value);
                return Math.min(model.getMaximum() - model.getExtent(), value);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void dispose() {
        if (this.viewer != null) {
            this.viewer.uninstallService(NavigationHistoryService.class);
            this.viewer.uninstallService(IRevealService.class);
            this.viewer.uninstallService(HideCursorService.class);
            this.viewer.uninstallService(IHighlightService.class);
            this.viewer.uninstallService(FilterService.class);
            this.viewer.uninstallService(IDrillDownTraceService.class);
            this.viewer.uninstallService(IFeedbackService.class);
            this.viewer.uninstallService(IShadowService.class);
            this.viewer.uninstallService(TopicContextService.class);
            this.viewer = null;
        }
        if (this.historyService != null) {
            this.historyService.dispose();
            this.historyService = null;
        }
        if (this.revealService != null) {
            this.revealService.dispose();
            this.revealService = null;
        }
        if (this.filterService != null) {
            this.filterService.removeFilterListener((IPropertyFilterListener)this);
            this.filterService.dispose();
            this.filterService = null;
        }
        if (this.highlightService != null) {
            this.highlightService.dispose();
            this.highlightService = null;
        }
    }

    public void turnLight(boolean onOrOff) {
        if (this.highlightService != null) {
            this.highlightService.setActive(!onOrOff);
        }
    }

    public Control getControl() {
        return this.viewer.getControl();
    }

    public IGraphicalViewer getViewer() {
        return this.viewer;
    }

    public Color getBackground(Object element) {
        if (IFeedbackService.PreselectionColor.equals(element) || IFeedbackService.DisabledPreselectionColor.equals(element)) {
            return ColorUtils.getColor((String)"#80c0d0");
        }
        return null;
    }

    public Color getForeground(Object element) {
        if (IFeedbackService.FocusColor.equals(element) || IFeedbackService.DisabledFocusColor.equals(element)) {
            return ColorUtils.getColor((String)"#1020f0");
        }
        if (IFeedbackService.SelectionColor.equals(element) || IFeedbackService.DisabledSelectionColor.equals(element)) {
            return ColorUtils.getColor((String)"#1040a8");
        }
        if (IFeedbackService.PreselectionColor.equals(element) || IFeedbackService.DisabledPreselectionColor.equals(element)) {
            return ColorUtils.getColor((String)"#a8c0d8");
        }
        return null;
    }

    public void filterChanged(PropertyFilter filter) {
        if (this.getControl() == null || this.getControl().isDisposed()) {
            return;
        }
        if (Boolean.TRUE.equals(this.viewer.getProperties().get("org.xmind.ui.presentation.lightOnOff"))) {
            return;
        }
        if (this.filterService.hasFilter()) {
            if (this.historyService != null) {
                this.historyService.setActive(false);
            }
        } else if (this.historyService != null) {
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    if (PresentationPage.this.historyService != null && !PresentationPage.this.getControl().isDisposed()) {
                        PresentationPage.this.historyService.setActive(true);
                    }
                }
            });
        }
    }
}

