/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.presentation.slide;

import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.xmind.gef.EditDomain;
import org.xmind.gef.GraphicalViewer;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.service.ZoomingAndPanningRevealService;
import org.xmind.ui.internal.presentation.slide.PresentationSlide;
import org.xmind.ui.internal.presentation.slide.SlideBoundsCalculator;
import org.xmind.ui.internal.presentation.slide.SlideFilter;

public class PresentationSlideModeService
extends ZoomingAndPanningRevealService {
    private PresentationSlide firstSlide;
    private SlideFilter slideFilter;
    private SlideBoundsCalculator boundsCalculator;
    private LightweightSystem lws;
    private boolean showFirstSlideOnce = false;

    public PresentationSlideModeService(IGraphicalViewer viewer) {
        this(viewer, null);
    }

    public PresentationSlideModeService(IGraphicalViewer viewer, PresentationSlide firstSlide) {
        super(viewer);
        this.firstSlide = firstSlide;
        this.slideFilter = new SlideFilter(viewer);
        this.boundsCalculator = new SlideBoundsCalculator(viewer);
        this.lws = (LightweightSystem)viewer.getAdapter(LightweightSystem.class);
    }

    public void showFirstSlideOnce(boolean showFirstSlideOnce) {
        this.showFirstSlideOnce = showFirstSlideOnce;
    }

    public void inputChanged(Object oldInput, Object newInput) {
        super.inputChanged(oldInput, newInput);
        if (this.showFirstSlideOnce && this.firstSlide != null) {
            this.showFirstSlide();
            this.showFirstSlideOnce = false;
        }
    }

    private void showFirstSlide() {
        final GraphicalViewer viewer = (GraphicalViewer)this.getViewer();
        viewer.getLightweightSystem().getUpdateManager().runWithUpdate(new Runnable(){

            public void run() {
                if (viewer.getFocused() == null) {
                    FigureCanvas canvas = viewer.getCanvas();
                    canvas.addListener(9, new Listener((Canvas)canvas){
                        private final /* synthetic */ Canvas val$canvas;
                        {
                            this.val$canvas = canvas;
                        }

                        public void handleEvent(Event event) {
                            this.val$canvas.removeListener(9, (Listener)this);
                            PresentationSlideModeService.this.showSlide(PresentationSlideModeService.this.firstSlide);
                        }
                    });
                }
            }
        });
    }

    public void showSlide(PresentationSlide slide) {
        this.performValidation();
        this.slideFilter.show(slide);
        this.performValidation();
        this.center(slide);
    }

    private void center(PresentationSlide slide) {
        this.setViewerScale(this.boundsCalculator.getSlideBounds(slide));
        this.performValidation();
        Rectangle bounds = this.boundsCalculator.getSlideBounds(slide);
        this.getViewer().center(bounds.x * 2 + bounds.width, bounds.y * 2 + bounds.height);
    }

    private void setViewerScale(Rectangle bounds) {
        if (bounds != null) {
            IGraphicalViewer viewer = this.getViewer();
            double canvasHeight = (double)viewer.getCanvas().getBounds().height * 0.8;
            double heightScale = canvasHeight / (double)bounds.height;
            double canvasWidth = (double)viewer.getCanvas().getBounds().width * 0.8;
            double widthScale = canvasWidth / (double)bounds.width;
            double scale = heightScale > widthScale ? widthScale : heightScale;
            double viewerScale = scale * viewer.getZoomManager().getScale();
            viewerScale = (double)Math.round(viewerScale * 100.0) / 100.0;
            EditDomain ed = viewer.getEditDomain();
            Request request = new Request("zoom");
            request.setViewer((IViewer)viewer);
            request.setParameter("zoomScale", (Object)viewerScale);
            ed.handleRequest(request);
        }
    }

    private void performValidation() {
        if (this.lws != null) {
            this.lws.getUpdateManager().performValidation();
        }
    }
}

