/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d;

import org.eclipse.draw2d.AncestorListener;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutListener;
import org.xmind.gef.draw2d.IShadowedFigure;
import org.xmind.gef.draw2d.graphics.AlphaGraphics;
import org.xmind.gef.draw2d.graphics.ColorMaskGraphics;
import org.xmind.gef.draw2d.graphics.GraphicsUtils;
import org.xmind.gef.draw2d.graphics.GrayedGraphics;

public class ShadowFigure
extends Figure {
    private static int[] offsets;
    private IFigure source = null;
    private int dx = 5;
    private int dy = 5;
    private int alpha = 128;
    private SourceHooker sourceHooker = new SourceHooker();

    static {
        int[] nArray = new int[32];
        nArray[0] = 7;
        nArray[2] = 4;
        nArray[3] = 2;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 2;
        nArray[7] = 4;
        nArray[9] = 7;
        nArray[10] = -2;
        nArray[11] = 4;
        nArray[12] = -1;
        nArray[13] = 1;
        nArray[14] = -4;
        nArray[15] = 2;
        nArray[16] = -7;
        nArray[18] = -4;
        nArray[19] = -2;
        nArray[20] = -1;
        nArray[21] = -1;
        nArray[22] = -2;
        nArray[23] = -4;
        nArray[25] = -7;
        nArray[26] = 2;
        nArray[27] = -4;
        nArray[28] = 1;
        nArray[29] = -1;
        nArray[30] = 4;
        nArray[31] = -2;
        offsets = nArray;
    }

    public IFigure getSource() {
        return this.source;
    }

    public void setSource(IFigure source) {
        if (source == this.source) {
            return;
        }
        if (this.source != null) {
            this.source.removeLayoutListener((LayoutListener)this.sourceHooker);
            this.source.removeAncestorListener((AncestorListener)this.sourceHooker);
        }
        this.source = source;
        if (source != null) {
            source.addAncestorListener((AncestorListener)this.sourceHooker);
            source.addLayoutListener((LayoutListener)this.sourceHooker);
        }
        this.update();
        this.revalidate();
    }

    public int getOffsetX() {
        return this.dx;
    }

    public int getOffsetY() {
        return this.dy;
    }

    public void setOffsetX(int dx) {
        this.setOffset(dx, this.getOffsetY());
    }

    public void setOffsetY(int dy) {
        this.setOffset(this.getOffsetX(), dy);
    }

    public void setOffset(int dx, int dy) {
        boolean translate = dx != this.dx || dy != this.dy;
        this.dx = dx;
        this.dy = dy;
        if (translate) {
            this.updateBounds();
        }
    }

    protected void update() {
        this.updateBounds();
        this.updateVisibility();
    }

    protected void updateBounds() {
        if (this.source != null) {
            this.setBounds(this.source.getBounds().getTranslated(this.getOffsetX(), this.getOffsetY()).expand(10, 10));
        }
        this.repaint();
    }

    protected void updateVisibility() {
        if (this.source != null) {
            this.setVisible(this.source.isShowing());
        } else {
            this.setVisible(false);
        }
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        if (alpha == this.alpha) {
            return;
        }
        this.alpha = alpha;
        this.repaint();
    }

    public boolean isVisible() {
        return super.isVisible() && this.isSourceShowing();
    }

    private boolean isSourceShowing() {
        if (this.source == null) {
            return false;
        }
        if (this.source instanceof IShadowedFigure) {
            return ((IShadowedFigure)this.source).isShadowShowing();
        }
        return this.source.isShowing();
    }

    public void paint(Graphics graphics) {
        GraphicsUtils.fixGradientBugForCarbon(graphics, (IFigure)this);
        int mainAlpha = this.getAlpha();
        if (offsets.length > 0) {
            int subAlpha = mainAlpha / (offsets.length / 2);
            graphics.pushState();
            graphics.translate(this.getOffsetX(), this.getOffsetY());
            int i = 0;
            while (i < offsets.length - 1) {
                int offX = offsets[i];
                int offY = offsets[i + 1];
                graphics.translate(offX, offY);
                this.paintShadow(graphics, subAlpha);
                graphics.translate(-offX, -offY);
                i += 2;
            }
            graphics.popState();
        } else {
            graphics.pushState();
            graphics.translate(this.getOffsetX(), this.getOffsetY());
            this.paintShadow(graphics, mainAlpha);
            graphics.popState();
        }
    }

    protected void paintShadow(Graphics graphics, int alpha) {
        AlphaGraphics g1 = new AlphaGraphics(graphics);
        g1.setMainAlpha(alpha);
        g1.setAlpha(graphics.getAlpha());
        if (this.source instanceof IShadowedFigure) {
            ((IShadowedFigure)this.source).paintShadow(g1);
        } else {
            ColorMaskGraphics g2 = this.createGlowGraphics(g1);
            this.paintSourceAsShadow(g2);
            g2.dispose();
        }
        g1.dispose();
    }

    protected void paintSourceAsShadow(Graphics g) {
        if (this.source != null) {
            this.source.paint(g);
        }
    }

    protected ColorMaskGraphics createGlowGraphics(Graphics graphics) {
        return new GrayedGraphics(graphics);
    }

    private class SourceHooker
    extends LayoutListener.Stub
    implements AncestorListener {
        private SourceHooker() {
        }

        public void invalidate(IFigure container) {
            super.invalidate(container);
            ShadowFigure.this.updateVisibility();
        }

        public void ancestorAdded(IFigure ancestor) {
        }

        public void ancestorMoved(IFigure ancestor) {
            ShadowFigure.this.updateBounds();
        }

        public void ancestorRemoved(IFigure ancestor) {
        }
    }
}

