/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal.renderer;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.basic.MDialog;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.IWindowCloseHandler;
import org.eclipse.e4.ui.workbench.renderers.swt.SWTPartRenderer;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.osgi.service.event.Event;

public class XDialogRenderer
extends SWTPartRenderer {
    WindowSizeUpdateJob boundsJob;
    @Inject
    private IEclipseContext context;
    @Inject
    private Display display;
    @Inject
    private MApplication application;
    @Inject
    @Optional
    @Named(value="localActiveShell")
    private Shell parentShell;

    @Inject
    @Optional
    private void subscribeTopicChildAdded(@UIEventTopic(value="org/eclipse/e4/ui/model/ui/ElementContainer/children/*") Event event) {
        Object changedObject = event.getProperty("ChangedElement");
        if (!(changedObject instanceof MDialog)) {
            return;
        }
        if (UIEvents.isADD((Event)event)) {
            this.processContents((MElementContainer<MUIElement>)((MElementContainer)changedObject));
            this.postProcess((MUIElement)((MDialog)changedObject));
        }
    }

    @Inject
    @Optional
    private void subscribeTopicWindowChanged(@UIEventTopic(value="org/eclipse/e4/ui/model/basic/Window/*") Event event) {
        Object objElement = event.getProperty("ChangedElement");
        if (!(objElement instanceof MDialog)) {
            return;
        }
        MDialog dialogModel = (MDialog)objElement;
        if (dialogModel.getRenderer() != this) {
            return;
        }
        Shell theShell = (Shell)dialogModel.getWidget();
        if (theShell == null) {
            return;
        }
        String attName = (String)event.getProperty("AttName");
        if ("x".equals(attName) || "y".equals(attName) || "width".equals(attName) || "height".equals(attName)) {
            if (this.boundsJob == null) {
                this.boundsJob = new WindowSizeUpdateJob();
                this.boundsJob.windowsToUpdate.add((MWindow)dialogModel);
                theShell.getDisplay().asyncExec((Runnable)this.boundsJob);
            } else if (!this.boundsJob.windowsToUpdate.contains(dialogModel)) {
                this.boundsJob.windowsToUpdate.add((MWindow)dialogModel);
            }
        }
    }

    public Object createWidget(MUIElement element, Object parent) {
        Shell wbwShell;
        int style;
        if (!(element instanceof MDialog) || parent != null && !(parent instanceof Control)) {
            return null;
        }
        MDialog dialogModel = (MDialog)element;
        MApplication appModel = (MApplication)dialogModel.getContext().get(MApplication.class);
        Boolean rtlMode = (Boolean)appModel.getTransientData().get("dir");
        int rtlStyle = rtlMode != null && rtlMode != false ? 0x4000000 : 0;
        Shell parentShell = parent == null ? null : ((Control)parent).getShell();
        int styleOverride = this.getStyleOverride((MUIElement)dialogModel) | rtlStyle;
        if (parentShell == null) {
            style = styleOverride == -1 ? 0x4F0 | rtlStyle : styleOverride;
            wbwShell = new Shell(this.display, style);
            dialogModel.getTags().add("topLevel");
        } else {
            style = 0x470 | rtlStyle;
            style = styleOverride == -1 ? style : styleOverride;
            wbwShell = dialogModel.getTags().contains("shellTopLevel") ? new Shell(this.display, style) : new Shell(parentShell, style);
        }
        wbwShell.setBackgroundMode(1);
        Rectangle modelBounds = wbwShell.getBounds();
        modelBounds.x = dialogModel.getX();
        modelBounds.y = dialogModel.getY();
        modelBounds.height = dialogModel.getHeight();
        modelBounds.width = dialogModel.getWidth();
        Rectangle displayBounds = Display.getCurrent().getPrimaryMonitor().getBounds();
        if (!modelBounds.intersects(displayBounds)) {
            Rectangle clientArea = Display.getCurrent().getPrimaryMonitor().getClientArea();
            modelBounds.x = clientArea.x;
            modelBounds.y = clientArea.y;
        }
        wbwShell.setBounds(modelBounds);
        this.setCSSInfo((MUIElement)dialogModel, wbwShell);
        wbwShell.setLayout((Layout)new FillLayout(512));
        Shell newWidget = wbwShell;
        this.bindWidget(element, newWidget);
        IEclipseContext localContext = this.getContext((MUIElement)dialogModel);
        localContext.set(Shell.class, (Object)wbwShell);
        localContext.set("localActiveShell", (Object)wbwShell);
        localContext.set(IShellProvider.class, (Object)new IShellProvider(){

            public Shell getShell() {
                return wbwShell;
            }
        });
        localContext.set(IWindowCloseHandler.class, (Object)new IWindowCloseHandler(){

            public boolean close(MWindow window) {
                return XDialogRenderer.this.closeDetachedWindow(window);
            }
        });
        if (dialogModel.getLabel() != null) {
            wbwShell.setText(dialogModel.getLocalizedLabel());
        }
        if (dialogModel.getIconURI() != null && dialogModel.getIconURI().length() > 0) {
            wbwShell.setImage(this.getImage((MUILabel)dialogModel));
        } else {
            wbwShell.setImages(Window.getDefaultImages());
        }
        return newWidget;
    }

    private boolean closeDetachedWindow(MWindow window) {
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        List parts = this.modelService.findElements((MUIElement)window, null, MPart.class, null);
        for (MPart part : parts) {
            if (partService.savePart(part, true)) continue;
            return false;
        }
        for (MPart part : parts) {
            partService.hidePart(part);
        }
        return true;
    }

    public void hookControllerLogic(final MUIElement me) {
        super.hookControllerLogic(me);
        Widget widget = (Widget)me.getWidget();
        if (widget instanceof Shell && me instanceof MWindow) {
            final Shell shell = (Shell)widget;
            shell.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    String splitSymbol = ",";
                    Rectangle bounds = shell.getBounds();
                    String location = String.valueOf(bounds.x) + splitSymbol + bounds.y + splitSymbol + bounds.width + splitSymbol + bounds.height;
                    me.getPersistedState().put("org.xmind.ui.dialogPart.customLocation", location);
                    MWindow window = (MWindow)me;
                    IWindowCloseHandler closeHandler = (IWindowCloseHandler)window.getContext().get(IWindowCloseHandler.class);
                    if (closeHandler == null || closeHandler.close(window)) {
                        Object parentModel = shell.getParent().getData("modelElement");
                        if (parentModel instanceof MWindow) {
                            List children = ((MWindow)parentModel).getChildren();
                            if (children.contains(window)) {
                                children.remove(window);
                            }
                        } else {
                            MWindow trimmedWindow = (MWindow)XDialogRenderer.this.application.getChildren().get(0);
                            List windows = trimmedWindow.getWindows();
                            if (windows.contains(window)) {
                                windows.remove(window);
                            }
                        }
                    }
                }
            });
        }
    }

    public void processContents(MElementContainer<MUIElement> me) {
        if (!(me instanceof MDialog)) {
            return;
        }
        MDialog wbwModel = (MDialog)me;
        super.processContents(me);
        IPresentationEngine renderer = (IPresentationEngine)this.context.get(IPresentationEngine.class);
        if (wbwModel.getMainMenu() != null) {
            renderer.createGui((MUIElement)wbwModel.getMainMenu(), me.getWidget(), null);
            Shell shell = (Shell)me.getWidget();
            shell.setMenuBar((Menu)wbwModel.getMainMenu().getWidget());
        }
        for (MWindow dw : wbwModel.getWindows()) {
            renderer.createGui((MUIElement)dw, me.getWidget(), wbwModel.getContext());
        }
    }

    public void postProcess(MUIElement shellME) {
        if (!(shellME instanceof MDialog)) {
            return;
        }
        MDialog dialogModel = (MDialog)shellME;
        super.postProcess(shellME);
        Shell shell = (Shell)shellME.getWidget();
        String location = (String)shellME.getPersistedState().get("org.xmind.ui.dialogPart.customLocation");
        location = location == null ? "" : location;
        String[] locations = location.split(",");
        if (locations.length < 4) {
            String[] tempLocations = new String[4];
            int i = 0;
            while (i < locations.length) {
                tempLocations[i] = locations[i];
                ++i;
            }
            locations = tempLocations;
        }
        Point size = shell.computeSize(-1, -1, true);
        if (this.isNone(locations[2])) {
            locations[2] = String.valueOf(size.x);
        }
        if (this.isNone(locations[3])) {
            locations[3] = String.valueOf(size.y);
        }
        size = new Point(Integer.valueOf(locations[2]).intValue(), Integer.valueOf(locations[3]).intValue());
        Point initLocation = this.getInitialLocation(shell, size);
        Rectangle bounds = this.getConstrainedShellBounds(shell, new Rectangle(initLocation.x, initLocation.y, size.x, size.y));
        if (this.isNone(locations[0]) && this.isNone(locations[1])) {
            locations[0] = String.valueOf(bounds.x);
            locations[1] = String.valueOf(bounds.y);
        }
        dialogModel.setX(Integer.valueOf(locations[0]).intValue());
        dialogModel.setY(Integer.valueOf(locations[1]).intValue());
        dialogModel.setWidth(Integer.valueOf(locations[2]).intValue());
        dialogModel.setHeight(Integer.valueOf(locations[3]).intValue());
        StringBuffer sb = new StringBuffer();
        sb.append(locations[0]);
        sb.append(",");
        sb.append(locations[1]);
        sb.append(",");
        sb.append(locations[2]);
        sb.append(",");
        sb.append(locations[3]);
        dialogModel.getPersistedState().put("org.xmind.ui.dialogPart.customLocation", sb.toString());
        shell.layout(true);
        this.forceLayout(shell);
        if (shellME.isVisible()) {
            shell.open();
        } else {
            shell.setVisible(false);
        }
    }

    private boolean isNone(String value) {
        return value == null || "".equals(value);
    }

    private Point getInitialLocation(Shell shell, Point initialSize) {
        Composite parent = shell.getParent();
        Monitor monitor = shell.getDisplay().getPrimaryMonitor();
        if (parent != null) {
            monitor = parent.getMonitor();
        }
        Rectangle monitorBounds = monitor.getClientArea();
        Point centerPoint = parent != null ? Geometry.centerPoint((Rectangle)parent.getBounds()) : Geometry.centerPoint((Rectangle)monitorBounds);
        return new Point(centerPoint.x - initialSize.x / 2, centerPoint.y - initialSize.y / 2);
    }

    protected Rectangle getConstrainedShellBounds(Shell shell, Rectangle preferredSize) {
        Rectangle result = new Rectangle(preferredSize.x, preferredSize.y, preferredSize.width, preferredSize.height);
        Monitor mon = XDialogRenderer.getClosestMonitor(shell.getDisplay(), Geometry.centerPoint((Rectangle)result));
        Rectangle bounds = mon.getClientArea();
        if (result.height > bounds.height) {
            result.height = bounds.height;
        }
        if (result.width > bounds.width) {
            result.width = bounds.width;
        }
        result.x = Math.max(bounds.x, Math.min(result.x, bounds.x + bounds.width - result.width));
        result.y = Math.max(bounds.y, Math.min(result.y, bounds.y + bounds.height - result.height));
        return result;
    }

    private static Monitor getClosestMonitor(Display toSearch, Point toFind) {
        int closest = Integer.MAX_VALUE;
        Monitor[] monitors = toSearch.getMonitors();
        Monitor result = monitors[0];
        int idx = 0;
        while (idx < monitors.length) {
            Monitor current = monitors[idx];
            Rectangle clientArea = current.getClientArea();
            if (clientArea.contains(toFind)) {
                return current;
            }
            int distance = Geometry.distanceSquared((Point)Geometry.centerPoint((Rectangle)clientArea), (Point)toFind);
            if (distance < closest) {
                closest = distance;
                result = current;
            }
            ++idx;
        }
        return result;
    }

    private void forceLayout(Shell shell) {
        int i = 0;
        while (shell.isLayoutDeferred()) {
            shell.setLayoutDeferred(false);
            ++i;
        }
        while (i > 0) {
            shell.setLayoutDeferred(true);
            --i;
        }
    }

    private class WindowSizeUpdateJob
    implements Runnable {
        public List<MWindow> windowsToUpdate = new ArrayList<MWindow>();

        private WindowSizeUpdateJob() {
        }

        @Override
        public void run() {
            XDialogRenderer.this.boundsJob = null;
            while (!this.windowsToUpdate.isEmpty()) {
                MWindow window = this.windowsToUpdate.remove(0);
                Shell shell = (Shell)window.getWidget();
                if (shell == null || shell.isDisposed()) continue;
                shell.setBounds(window.getX(), window.getY(), window.getWidth(), window.getHeight());
            }
        }
    }
}

