/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.de.erichseifert.vectorgraphics2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.xml.bind.DatatypeConverter;
import org.xmind.de.erichseifert.vectorgraphics2d.VectorGraphics2D;
import org.xmind.de.erichseifert.vectorgraphics2d.util.DataUtils;
import org.xmind.de.erichseifert.vectorgraphics2d.util.GraphicsUtils;

public class SVGGraphics2D
extends VectorGraphics2D {
    private static final Map<Integer, String> STROKE_ENDCAPS = DataUtils.map(new Integer[]{0, 1, 2}, new String[]{"butt", "round", "square"});
    private static final Map<Integer, String> STROKE_LINEJOIN = DataUtils.map(new Integer[]{0, 1, 2}, new String[]{"miter", "round", "bevel"});
    private static final String CLIP_PATH_ID = "clip";
    private long clipCounter;

    public SVGGraphics2D(double x, double y, double width, double height) {
        super(x, y, width, height);
        this.writeHeader();
    }

    @Override
    protected void writeString(String str, double x, double y) {
        str = str.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        float fontSize = this.getFont().getSize2D();
        str = str.replaceAll("[\r\n]", "");
        this.writeln("<text x=\"", x, "\" y=\"", y, "\" style=\"font:", Float.valueOf(fontSize), "px ", this.getFont().getFamily(), "\">", str, "</text>");
    }

    @Override
    protected void writeImage(Image img, int imgWidth, int imgHeight, double x, double y, double width, double height) {
        BufferedImage bufferedImg = GraphicsUtils.toBufferedImage(img);
        String imgData = SVGGraphics2D.getSvg(bufferedImg);
        this.write("<image x=\"", x, "\" y=\"", y, "\" ", "width=\"", width, "\" height=\"", height, "\" ", "xlink:href=\"", imgData, "\" ", "/>");
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        Path2D.Double s = new Path2D.Double(1, xPoints.length);
        this.write("<polygon points=\"");
        int i = 0;
        while (i < nPoints) {
            if (i == 0) {
                ((Path2D)s).moveTo(xPoints[i], yPoints[i]);
            } else {
                ((Path2D)s).lineTo(xPoints[i], yPoints[i]);
                this.write(" ");
            }
            this.write(xPoints[i], ",", yPoints[i]);
            ++i;
        }
        this.write("\" ");
        s.closePath();
        this.writeClosingDraw(s);
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        Path2D.Double s = new Path2D.Double(1, xPoints.length);
        this.write("<polyline points=\"");
        int i = 0;
        while (i < nPoints) {
            if (i == 0) {
                ((Path2D)s).moveTo(xPoints[i], yPoints[i]);
            } else {
                ((Path2D)s).lineTo(xPoints[i], yPoints[i]);
                this.write(" ");
            }
            this.write(xPoints[i], ",", yPoints[i]);
            ++i;
        }
        this.write("\" ");
        this.writeClosingDraw(s);
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        Path2D.Double s = new Path2D.Double(1, xPoints.length);
        this.write("<polygon points=\"");
        int i = 0;
        while (i < nPoints) {
            if (i == 0) {
                ((Path2D)s).moveTo(xPoints[i], yPoints[i]);
            } else {
                ((Path2D)s).lineTo(xPoints[i], yPoints[i]);
                this.write(" ");
            }
            this.write(xPoints[i], ",", yPoints[i]);
            ++i;
        }
        this.write("\" ");
        s.closePath();
        this.writeClosingFill(s);
    }

    @Override
    protected void setAffineTransform(AffineTransform tx) {
        if (this.getTransform().equals(tx)) {
            return;
        }
        if (this.isTransformed()) {
            this.writeln("</g>");
        }
        super.setAffineTransform(tx);
        if (this.isTransformed()) {
            double[] matrix = new double[6];
            this.getTransform().getMatrix(matrix);
            this.writeln("<g transform=\"matrix(", DataUtils.join(" ", matrix), ") \">");
        }
    }

    @Override
    protected void writeHeader() {
        Rectangle2D bounds = this.getBounds();
        double x = bounds.getX();
        double y = bounds.getY();
        double w = bounds.getWidth();
        double h = bounds.getHeight();
        this.writeln("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.writeln("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" ", "\"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">");
        this.writeln("<svg version=\"1.2\" xmlns=\"http://www.w3.org/2000/svg\" ", "xmlns:xlink=\"http://www.w3.org/1999/xlink\" ", "x=\"", x, "\" y=\"", y, "\" ", "width=\"", w, "\" height=\"", h, "\" viewBox=\"", x, " ", y, " ", w, " ", h, "\"", ">");
        this.writeln("<style type=\"text/css\"><![CDATA[");
        this.writeln("text { font:", Float.valueOf(this.getFont().getSize2D()), "px ", this.getFont().getFamily(), "; }");
        this.writeln("]]></style>");
    }

    @Override
    protected void writeClosingDraw(Shape s) {
        this.write("style=\"fill:none;stroke:", SVGGraphics2D.getSvg(this.getColor()));
        if (this.getStroke() instanceof BasicStroke) {
            BasicStroke stroke = (BasicStroke)this.getStroke();
            if (stroke.getLineWidth() != 1.0f) {
                this.write(";stroke-width:", Float.valueOf(stroke.getLineWidth()));
            }
            if (stroke.getEndCap() != 0) {
                this.write(";stroke-linecap:", STROKE_ENDCAPS.get(stroke.getEndCap()));
            }
            if (stroke.getLineJoin() != 0) {
                this.write(";stroke-linejoin:", STROKE_LINEJOIN.get(stroke.getLineJoin()));
            }
            if (stroke.getDashArray() != null && stroke.getDashArray().length > 0) {
                this.write(";stroke-dasharray:", DataUtils.join(",", stroke.getDashArray()));
                this.write(";stroke-dashoffset:", Float.valueOf(stroke.getDashPhase()));
            }
        }
        if (this.getClip() != null) {
            this.write("\" clip-path=\"url(#", this.getClipId(), ")");
        }
        this.writeln("\" />");
    }

    @Override
    protected void writeClosingFill(Shape s) {
        if (this.getPaint() instanceof Color) {
            this.write("style=\"fill:", SVGGraphics2D.getSvg(this.getColor()), ";stroke:none");
            if (this.getClip() != null) {
                this.write("\" clip-path=\"url(#", this.getClipId(), ")");
            }
            this.writeln("\" />");
        } else {
            this.write("style=\"stroke:none\" />");
            super.writeClosingFill(s);
        }
    }

    @Override
    protected void writeShape(Shape s) {
        this.writeClip();
        this.writeUnclippedShape(s);
    }

    private String getClipId() {
        return CLIP_PATH_ID + this.clipCounter;
    }

    private String nextClipId() {
        ++this.clipCounter;
        return this.getClipId();
    }

    private void writeClip() {
        Shape clip = this.getClip();
        if (clip == null) {
            return;
        }
        this.write("<clipPath id=\"", this.nextClipId(), "\">");
        this.writeUnclippedShape(clip);
        this.write("/>");
        this.writeln("</clipPath>");
    }

    private void writeUnclippedShape(Shape s) {
        if (s instanceof Line2D) {
            Line2D l = (Line2D)s;
            double x1 = l.getX1();
            double y1 = l.getY1();
            double x2 = l.getX2();
            double y2 = l.getY2();
            this.write("<line x1=\"", x1, "\" y1=\"", y1, "\" x2=\"", x2, "\" y2=\"", y2, "\" ");
        } else if (s instanceof Rectangle2D) {
            Rectangle2D r = (Rectangle2D)s;
            double x = r.getX();
            double y = r.getY();
            double width = r.getWidth();
            double height = r.getHeight();
            this.write("<rect x=\"", x, "\" y=\"", y, "\" width=\"", width, "\" height=\"", height, "\" ");
        } else if (s instanceof RoundRectangle2D) {
            RoundRectangle2D r = (RoundRectangle2D)s;
            double x = r.getX();
            double y = r.getY();
            double width = r.getWidth();
            double height = r.getHeight();
            double arcWidth = r.getArcWidth();
            double arcHeight = r.getArcHeight();
            this.write("<rect x=\"", x, "\" y=\"", y, "\" width=\"", width, "\" height=\"", height, "\" rx=\"", arcWidth, "\" ry=\"", arcHeight, "\" ");
        } else if (s instanceof Ellipse2D) {
            Ellipse2D e = (Ellipse2D)s;
            double x = e.getX();
            double y = e.getY();
            double rx = e.getWidth() / 2.0;
            double ry = e.getHeight() / 2.0;
            this.write("<ellipse cx=\"", x + rx, "\" cy=\"", y + ry, "\" rx=\"", rx, "\" ry=\"", ry, "\" ");
        } else {
            this.write("<path d=\"");
            this.writePath(s);
            this.write("\" ");
        }
    }

    protected void writePath(Shape s) {
        PathIterator segments = s.getPathIterator(null);
        double[] coords = new double[6];
        int i = 0;
        while (!segments.isDone()) {
            if (i > 0) {
                this.write(" ");
            }
            int segmentType = segments.currentSegment(coords);
            switch (segmentType) {
                case 0: {
                    this.write("M", coords[0], ",", coords[1]);
                    break;
                }
                case 1: {
                    this.write("L", coords[0], ",", coords[1]);
                    break;
                }
                case 3: {
                    this.write("C", coords[0], ",", coords[1], " ", coords[2], ",", coords[3], " ", coords[4], ",", coords[5]);
                    break;
                }
                case 2: {
                    this.write("Q", coords[0], ",", coords[1], " ", coords[2], ",", coords[3]);
                    break;
                }
                case 4: {
                    this.write("Z");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown path operation.");
                }
            }
            ++i;
            segments.next();
        }
    }

    private static String getSvg(Color c) {
        String color = "rgb(" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + ")";
        if (c.getAlpha() < 255) {
            double opacity = (double)c.getAlpha() / 255.0;
            color = String.valueOf(color) + ";opacity:" + opacity;
        }
        return color;
    }

    private static String getSvg(BufferedImage bufferedImg) {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)bufferedImg, "png", data);
        }
        catch (IOException iOException) {
            return "";
        }
        String dataBase64 = DatatypeConverter.printBase64Binary((byte[])data.toByteArray());
        return "data:image/png;base64," + dataBase64;
    }

    @Override
    protected String getFooter() {
        String footer = "";
        if (this.isTransformed()) {
            footer = String.valueOf(footer) + "</g>\n";
        }
        footer = String.valueOf(footer) + "</svg>\n";
        return footer;
    }

    @Override
    public String toString() {
        String doc = super.toString();
        doc = doc.replaceAll("<g transform=\"[^\"]*\">\n*</g>\n", "");
        return doc;
    }
}

