## Description

**Summary**: [Brief one-line description of changes]

**Motivation**: [Why is this change needed? What problem does it solve?]

**Related Issue(s)**: Fixes #XXX

## Type of Change

- [ ] Bug fix (non-breaking change fixing an issue)
- [ ] New feature (non-breaking change adding functionality)
- [ ] Breaking change (fix or feature causing existing functionality to not work as expected)
- [ ] Documentation update
- [ ] Refactoring (no functional changes)
- [ ] Performance improvement
- [ ] Test coverage improvement

## Changes Made

### Core Changes
- [Change 1]
- [Change 2]
- [...]

### API Changes
- [ ] No API changes
- [ ] New API added (backward compatible)
- [ ] API modified (breaking change)
- [ ] API deprecated

### Documentation Changes
- [Doc change 1]
- [Doc change 2]

## Testing

### Test Coverage
- [ ] Unit tests added/updated
- [ ] Integration tests added/updated
- [ ] Test coverage maintained or improved
- [ ] All tests pass locally

### Testing Checklist
- [ ] Tested on CPython 3.11
- [ ] Tested on CPython 3.12
- [ ] Tested on CPython 3.13
- [ ] Tested on PyPy 3.11
- [ ] Tested with Twisted (if applicable)
- [ ] Tested with asyncio (if applicable)
- [ ] Tested on Linux
- [ ] Tested on macOS
- [ ] Tested on Windows

### Test Results
```
# Paste test output here
# Example: pytest output, coverage report, etc.
```

## Code Quality

- [ ] Code follows project style guidelines (ruff, black)
- [ ] Type hints added/updated (mypy passes)
- [ ] Docstrings added/updated
- [ ] Comments added for complex logic
- [ ] No new linter warnings
- [ ] No security vulnerabilities introduced

## Performance Impact

- [ ] No performance impact
- [ ] Performance improved
- [ ] Performance regression (justified in description)

**Benchmarks** (if applicable):
```
# Paste benchmark results
```

## Breaking Changes

- [ ] No breaking changes
- [ ] Breaking changes documented below

**Breaking Changes Description**:
[Describe what breaks and migration path]

**Migration Guide**:
```python
# Before
old_api()

# After
new_api()
```

## Deployment Notes

- [ ] No special deployment steps required
- [ ] Database migration needed
- [ ] Configuration changes needed
- [ ] Dependencies updated

**Deployment Steps** (if applicable):
1. [Step 1]
2. [Step 2]

## Screenshots/Recordings

[If applicable, add screenshots or recordings demonstrating the changes]

## Checklist

- [ ] My code follows the project's style guidelines
- [ ] I have performed a self-review of my code
- [ ] I have commented my code, particularly in hard-to-understand areas
- [ ] I have made corresponding changes to the documentation
- [ ] My changes generate no new warnings
- [ ] I have added tests that prove my fix is effective or that my feature works
- [ ] New and existing unit tests pass locally with my changes
- [ ] Any dependent changes have been merged and published

## AI Assistance Disclosure

- [ ] This PR was created entirely by a human
- [ ] This PR was created with AI assistance

**If AI-assisted, please provide details**:
- **AI Tool**: [e.g., Claude Code, GitHub Copilot]
- **Scope of AI Assistance**: [e.g., "Code refactoring suggestions", "Test generation", "Documentation writing"]
- **Human Review**: [Describe how you reviewed and validated the AI-generated content]

**Note**: Per AI_POLICY.md, you (the human) are the sole author of this contribution.
AI assistance is acknowledged but does not constitute co-authorship.

## Additional Notes

[Any additional context, concerns, or discussion points]
