
function(get_target_property2 VAR TARGET PROPERTY)
    get_target_property(_pflags ${TARGET} ${PROPERTY})
    if(_pflags)
        set(${VAR} ${_pflags} PARENT_SCOPE)
    else()
        set(${VAR} "" PARENT_SCOPE)
    endif()
endfunction()


macro(append_flags FLAGS TARGET PROPERTY PREFIX)
    get_target_property2(_pflags ${TARGET} ${PROPERTY})
    foreach(FLAG ${_pflags})
        if(TARGET ${FLAG})
            target_flags(_pflags2 ${FLAG})
            string(APPEND ${FLAGS} " ${_pflags2}")
        else()
            string(APPEND ${FLAGS} " ${PREFIX}${FLAG}")
        endif()
    endforeach()
endmacro()

macro(append_link_flags FLAGS TARGET PROPERTY)
    get_target_property2(_pflags ${TARGET} ${PROPERTY})
    foreach(FLAG ${_pflags})
        if(TARGET ${FLAG})
            target_flags(_pflags2 ${FLAG})
            string(APPEND ${FLAGS} " ${_pflags2}")
        elseif(FLAG MATCHES "^-.*")
            string(APPEND ${FLAGS} " ${FLAG}")
        elseif(EXISTS ${FLAG})
            string(APPEND ${FLAGS} " ${FLAG}")
        else()
            string(APPEND ${FLAGS} " -l${FLAG}")
        endif()
    endforeach()
endmacro()

function(target_flags FLAGS TARGET)
    set(_flags)
    append_flags(_flags ${TARGET} "INTERFACE_COMPILE_OPTIONS" "")
    append_flags(_flags ${TARGET} "INTERFACE_COMPILE_DEFINITIONS" "-D")
    append_flags(_flags ${TARGET} "INTERFACE_INCLUDE_DIRECTORIES" "-isystem ")
    append_flags(_flags ${TARGET} "INTERFACE_LINK_DIRECTORIES" "-L ")
    append_flags(_flags ${TARGET} "INTERFACE_LINK_OPTIONS" "")
    append_link_flags(_flags ${TARGET} "INTERFACE_LINK_LIBRARIES" "")
    # message("_flags: ${_flags}")
    set(${FLAGS} ${_flags} PARENT_SCOPE)
endfunction()
