      PROGRAM MAIN80
C...Example PYTHIA main program using new interface to FeynHiggs. 
C   (Requires PYTHIA version 6.321 or later)
C...Note: FeynHiggs *corrects* the Higgs sector with higher precision,
C         but needs to *start* from an already defined SUSY spectrum. Below
C         is shown how to do this either in the case of using an SLHA
C         spectrum, or by using the PYTHIA-ISAJET interface for RGE
C         running.

C...Example process: Higgs strahlung at ILC (500GeV).

C...To compile and link from a fresh PYTHIA 6.3 source, with the 
C   FeynHiggs routines in the library libFH.a: 
C   1) In the PYTHIA source, first remove the dummy routines: 
C       FHSETFLAGS
C       FHSETPARA
C       FHHIGGSCORR
C      (These are only included to make sure PYTHIA can still compile 
C       also when not linked to FeynHiggs)
C      Compile the modified source -> PYTHIA library.
C   2) Compile this example program, linking to the PYTHIA and 
C      FeynHiggs libraries
C...(To compile with an already existing PYTHIA library, step 1 is
C    normally not needed, since the dummy routines are normally not
C    included in the pre-compiled libraries. If, by mistake, the 
C    dummy routines are not removed, you will get an error message).

C...There are 2 ways of using the FeynHiggs Interface (IMODE below):
C IMODE = 1 : Use a SuSy Les Houches Accord input spectrum to start 
C             from (requires the file softsusy.spc)
C       = 2 : Use the PYSUGI ISASUSY interface to start from
C             (requires linking with ISAJET library as well)

C--------------- PREAMBLE: COMMON BLOCK DECLARATIONS ETC -------------
C...All real arithmetic done in double precision.
      IMPLICIT DOUBLE PRECISION(A-H, O-Z)
C...The PYTHIA event record:
      COMMON/PYJETS/N,NPAD,K(4000,5),P(4000,5),V(4000,5)
C...Commonblocks.
      COMMON/PYDAT1/MSTU(200),PARU(200),MSTJ(200),PARJ(200)
      COMMON/PYPARS/MSTP(200),PARP(200),MSTI(200),PARI(200)
C...PYTHIA MSSM and subprocess common blocks
      COMMON/PYMSSM/IMSS(0:99),RMSS(0:99)
      COMMON/PYSUBS/MSEL,MSELPD,MSUB(500),KFIN(2,-40:40),CKIN(200)
C...EXTERNAL statement links PYDATA on most machines.
      EXTERNAL PYDATA

C-------------------------- PYTHIA SETUP -----------------------------
C - Number of events to generate.
      NEV=1000

C - Subprocesses: e+e- -> h0 Z0
      MSEL=0
      MSUB(24)=1

C - CM energy
      ECM=500D0

      IMODE = 2

      IF (IMODE.EQ.1) THEN
C - Set SuSy parameters, using SLHA input.
C...Switch on SUSY MSSM input from an SLHA file.
        IMSS(1)=11
C...Open the SLHA file and tell Pythia where (on which LUN) to find it:
        LUNSPC=88
        OPEN(LUNSPC,file='softsusy.spc',status='old')
        IMSS(21)=LUNSPC
C...If the file also contains an SLHA decay table that you want to use,
C...uncomment the next line: 
C        IMSS(22)=LUNSPC

      ELSEIF (IMODE.EQ.2) THEN      
C...SUSY Model specifications. Interface ISASUSY.
        IMSS(1)=12
C...Set parameters for old interface (SPS1a)
        RMSS(1)=250D0
        RMSS(4)=1D0
        RMSS(5)=10D0
        RMSS(8)=100D0
        RMSS(16)=-100D0
      ELSE
        CALL PYERRM(9,'(Main:) IMODE not valid.')
      ENDIF

C***Tell PYTHIA to improve Higgs sector using FeynHiggs***
      IMSS(4)=3

C...Just a fast test: switch off hafdronization, ISR, and FSR
      MSTP(111)=0
      MSTP(61)=0
      MSTP(71)=0

C - Initialize PYTHIA
      CALL PYINIT('CMS','e+','e-',ECM)


C - Close the SLHA file (only used during initialization).
      IF (IMODE.EQ.1) THEN
        CLOSE(LUNSPC)
      ENDIF

C      CALL PYSTAT(2)

C------------------------- GENERATE EVENTS ---------------------------
      DO 100 IEV=1,NEV
        CALL PYEVNW
C...Make a print of the event record for the first event.
        IF (IEV.EQ.1) THEN 
          CALL PYLIST(2)
        ENDIF

 100  CONTINUE

C----------------------------- FINALIZE ------------------------------
C - Print info on cross sections and errors/warnings
      CALL PYSTAT(1)

      END
